/*
 * Decompiled with CFR 0.152.
 */
package RASMI.rlogin.jda.jda.internal.handle;

import RASMI.rlogin.jda.jda.api.JDA;
import RASMI.rlogin.jda.jda.api.entities.Guild;
import RASMI.rlogin.jda.jda.api.entities.channel.ChannelType;
import RASMI.rlogin.jda.jda.api.events.interaction.GenericInteractionCreateEvent;
import RASMI.rlogin.jda.jda.api.events.interaction.ModalInteractionEvent;
import RASMI.rlogin.jda.jda.api.events.interaction.command.CommandAutoCompleteInteractionEvent;
import RASMI.rlogin.jda.jda.api.events.interaction.command.MessageContextInteractionEvent;
import RASMI.rlogin.jda.jda.api.events.interaction.command.SlashCommandInteractionEvent;
import RASMI.rlogin.jda.jda.api.events.interaction.command.UserContextInteractionEvent;
import RASMI.rlogin.jda.jda.api.events.interaction.component.ButtonInteractionEvent;
import RASMI.rlogin.jda.jda.api.events.interaction.component.EntitySelectInteractionEvent;
import RASMI.rlogin.jda.jda.api.events.interaction.component.StringSelectInteractionEvent;
import RASMI.rlogin.jda.jda.api.interactions.InteractionType;
import RASMI.rlogin.jda.jda.api.interactions.commands.Command;
import RASMI.rlogin.jda.jda.api.interactions.components.Component;
import RASMI.rlogin.jda.jda.api.utils.data.DataObject;
import RASMI.rlogin.jda.jda.internal.JDAImpl;
import RASMI.rlogin.jda.jda.internal.handle.SocketHandler;
import RASMI.rlogin.jda.jda.internal.interactions.InteractionImpl;
import RASMI.rlogin.jda.jda.internal.interactions.command.CommandAutoCompleteInteractionImpl;
import RASMI.rlogin.jda.jda.internal.interactions.command.MessageContextInteractionImpl;
import RASMI.rlogin.jda.jda.internal.interactions.command.SlashCommandInteractionImpl;
import RASMI.rlogin.jda.jda.internal.interactions.command.UserContextInteractionImpl;
import RASMI.rlogin.jda.jda.internal.interactions.component.ButtonInteractionImpl;
import RASMI.rlogin.jda.jda.internal.interactions.component.EntitySelectInteractionImpl;
import RASMI.rlogin.jda.jda.internal.interactions.component.StringSelectInteractionImpl;
import RASMI.rlogin.jda.jda.internal.interactions.modal.ModalInteractionImpl;
import RASMI.rlogin.jda.jda.internal.requests.WebSocketClient;

public class InteractionCreateHandler
extends SocketHandler {
    public InteractionCreateHandler(JDAImpl api) {
        super(api);
    }

    @Override
    protected Long handleInternally(DataObject content) {
        int type = content.getInt("type");
        int version = content.getInt("version", 1);
        if (version != 1) {
            WebSocketClient.LOG.debug("Received interaction with version {}. This version is currently unsupported by this version of JDA. Consider updating!", (Object)version);
            return null;
        }
        long guildId = content.getUnsignedLong("guild_id", 0L);
        Guild guild = this.api.getGuildById(guildId);
        if (this.api.getGuildSetupController().isLocked(guildId)) {
            return guildId;
        }
        if (guildId != 0L && guild == null) {
            return null;
        }
        DataObject channelJson = content.getObject("channel");
        ChannelType channelType = ChannelType.fromId(channelJson.getInt("type"));
        if (!channelType.isMessage() || channelType == ChannelType.GROUP) {
            WebSocketClient.LOG.debug("Discarding INTERACTION_CREATE event from unexpected channel type. Channel: {}", (Object)channelJson);
            return null;
        }
        switch (InteractionType.fromKey(type)) {
            case COMMAND: {
                this.handleCommand(content);
                break;
            }
            case COMPONENT: {
                this.handleAction(content);
                break;
            }
            case COMMAND_AUTOCOMPLETE: {
                this.api.handleEvent(new CommandAutoCompleteInteractionEvent((JDA)this.api, this.responseNumber, new CommandAutoCompleteInteractionImpl(this.api, content)));
                break;
            }
            case MODAL_SUBMIT: {
                this.api.handleEvent(new ModalInteractionEvent((JDA)this.api, this.responseNumber, new ModalInteractionImpl(this.api, content)));
                break;
            }
            default: {
                this.api.handleEvent(new GenericInteractionCreateEvent(this.api, this.responseNumber, new InteractionImpl(this.api, content)));
            }
        }
        return null;
    }

    private void handleCommand(DataObject content) {
        switch (Command.Type.fromId(content.getObject("data").getInt("type"))) {
            case SLASH: {
                this.api.handleEvent(new SlashCommandInteractionEvent((JDA)this.api, this.responseNumber, new SlashCommandInteractionImpl(this.api, content)));
                break;
            }
            case MESSAGE: {
                this.api.handleEvent(new MessageContextInteractionEvent((JDA)this.api, this.responseNumber, new MessageContextInteractionImpl(this.api, content)));
                break;
            }
            case USER: {
                this.api.handleEvent(new UserContextInteractionEvent((JDA)this.api, this.responseNumber, new UserContextInteractionImpl(this.api, content)));
            }
        }
    }

    private void handleAction(DataObject content) {
        switch (Component.Type.fromKey(content.getObject("data").getInt("component_type"))) {
            case BUTTON: {
                this.api.handleEvent(new ButtonInteractionEvent((JDA)this.api, this.responseNumber, new ButtonInteractionImpl(this.api, content)));
                break;
            }
            case STRING_SELECT: {
                this.api.handleEvent(new StringSelectInteractionEvent((JDA)this.api, this.responseNumber, new StringSelectInteractionImpl(this.api, content)));
                break;
            }
            case USER_SELECT: 
            case ROLE_SELECT: 
            case MENTIONABLE_SELECT: 
            case CHANNEL_SELECT: {
                this.api.handleEvent(new EntitySelectInteractionEvent((JDA)this.api, this.responseNumber, new EntitySelectInteractionImpl(this.api, content)));
            }
        }
    }
}

