/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.infernal.fluid;

import net.mcreator.infernal.init.InfernalModBlocks;
import net.mcreator.infernal.init.InfernalModFluidTypes;
import net.mcreator.infernal.init.InfernalModFluids;
import net.mcreator.infernal.init.InfernalModItems;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.neoforged.neoforge.fluids.BaseFlowingFluid;
import net.neoforged.neoforge.fluids.FluidType;

public abstract class NetherWaterFluid
extends BaseFlowingFluid {
    public static final BaseFlowingFluid.Properties PROPERTIES = new BaseFlowingFluid.Properties(() -> (FluidType)InfernalModFluidTypes.NETHER_WATER_TYPE.get(), () -> (Fluid)InfernalModFluids.NETHER_WATER.get(), () -> (Fluid)InfernalModFluids.FLOWING_NETHER_WATER.get()).explosionResistance(100.0f).tickRate(2).bucket(() -> (Item)InfernalModItems.NETHER_WATER_BUCKET.get()).block(() -> (LiquidBlock)InfernalModBlocks.NETHER_WATER.get());

    private NetherWaterFluid() {
        super(PROPERTIES);
    }

    public ParticleOptions getDripParticle() {
        return ParticleTypes.DRIPPING_WATER;
    }

    public static class Flowing
    extends NetherWaterFluid {
        protected void createFluidStateDefinition(StateDefinition.Builder<Fluid, FluidState> builder) {
            super.createFluidStateDefinition(builder);
            builder.add(new Property[]{LEVEL});
        }

        public int getAmount(FluidState state) {
            return (Integer)state.getValue((Property)LEVEL);
        }

        public boolean isSource(FluidState state) {
            return false;
        }
    }

    public static class Source
    extends NetherWaterFluid {
        public int getAmount(FluidState state) {
            return 8;
        }

        public boolean isSource(FluidState state) {
            return true;
        }
    }
}

