/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.infernal.init;

import com.google.common.base.Suppliers;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import net.mcreator.infernal.init.InfernalModBlocks;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeGenerationSettings;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.biome.FeatureSorter;
import net.minecraft.world.level.biome.MultiNoiseBiomeSource;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.dimension.BuiltinDimensionTypes;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.levelgen.NoiseBasedChunkGenerator;
import net.minecraft.world.level.levelgen.SurfaceRules;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.placement.CaveSurface;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.server.ServerAboutToStartEvent;

@EventBusSubscriber
public class InfernalModBiomes {
    @SubscribeEvent
    public static void onServerAboutToStart(ServerAboutToStartEvent event) {
        MinecraftServer server = event.getServer();
        Registry levelStemTypeRegistry = server.registryAccess().lookupOrThrow(Registries.LEVEL_STEM);
        Registry biomeRegistry = server.registryAccess().lookupOrThrow(Registries.BIOME);
        for (LevelStem levelStem : levelStemTypeRegistry.stream().toList()) {
            NoiseBasedChunkGenerator noiseGenerator;
            Object parameters;
            MultiNoiseBiomeSource noiseSource;
            ChunkGenerator chunkGenerator;
            Holder dimensionType = levelStem.type();
            if (dimensionType.is(BuiltinDimensionTypes.OVERWORLD)) {
                chunkGenerator = levelStem.generator();
                BiomeSource biomeSource = chunkGenerator.getBiomeSource();
                if (biomeSource instanceof MultiNoiseBiomeSource) {
                    noiseSource = (MultiNoiseBiomeSource)biomeSource;
                    parameters = new ArrayList(noiseSource.parameters().values());
                    InfernalModBiomes.addParameterPoint((List<Pair<Climate.ParameterPoint, Holder<Biome>>>)parameters, (Pair<Climate.ParameterPoint, Holder<Biome>>)new Pair((Object)new Climate.ParameterPoint(Climate.Parameter.span((float)-0.5f, (float)0.5f), Climate.Parameter.span((float)-0.5f, (float)0.5f), Climate.Parameter.span((float)0.3f, (float)1.0f), Climate.Parameter.span((float)-0.5f, (float)0.5f), Climate.Parameter.point((float)0.0f), Climate.Parameter.span((float)-1.0f, (float)1.0f), 0L), (Object)biomeRegistry.getOrThrow(ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"infernal", (String)"electric_forest")))));
                    InfernalModBiomes.addParameterPoint((List<Pair<Climate.ParameterPoint, Holder<Biome>>>)parameters, (Pair<Climate.ParameterPoint, Holder<Biome>>)new Pair((Object)new Climate.ParameterPoint(Climate.Parameter.span((float)-0.5f, (float)0.5f), Climate.Parameter.span((float)-0.5f, (float)0.5f), Climate.Parameter.span((float)0.3f, (float)1.0f), Climate.Parameter.span((float)-0.5f, (float)0.5f), Climate.Parameter.point((float)1.0f), Climate.Parameter.span((float)-1.0f, (float)1.0f), 0L), (Object)biomeRegistry.getOrThrow(ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"infernal", (String)"electric_forest")))));
                    chunkGenerator.biomeSource = MultiNoiseBiomeSource.createFromList((Climate.ParameterList)new Climate.ParameterList((List)parameters));
                    chunkGenerator.featuresPerStep = Suppliers.memoize(() -> FeatureSorter.buildFeaturesPerStep(List.copyOf(chunkGenerator.biomeSource.possibleBiomes()), biome -> ((BiomeGenerationSettings)chunkGenerator.generationSettingsGetter.apply(biome)).features(), (boolean)true));
                }
                if (chunkGenerator instanceof NoiseBasedChunkGenerator) {
                    noiseGenerator = (NoiseBasedChunkGenerator)chunkGenerator;
                    ((InfernalModNoiseGeneratorSettings)noiseGenerator.settings.value()).setinfernalDimensionTypeReference((Holder<DimensionType>)dimensionType);
                }
            }
            if (!dimensionType.is(BuiltinDimensionTypes.NETHER)) continue;
            chunkGenerator = levelStem.generator();
            parameters = chunkGenerator.getBiomeSource();
            if (parameters instanceof MultiNoiseBiomeSource) {
                noiseSource = (MultiNoiseBiomeSource)parameters;
                parameters = new ArrayList(noiseSource.parameters().values());
                InfernalModBiomes.addParameterPoint((List<Pair<Climate.ParameterPoint, Holder<Biome>>>)parameters, (Pair<Climate.ParameterPoint, Holder<Biome>>)new Pair((Object)new Climate.ParameterPoint(Climate.Parameter.span((float)-0.5f, (float)0.5f), Climate.Parameter.span((float)-0.5f, (float)0.5f), Climate.Parameter.span((float)0.3f, (float)1.0f), Climate.Parameter.span((float)-0.5f, (float)0.5f), Climate.Parameter.point((float)0.0f), Climate.Parameter.span((float)-1.0f, (float)1.0f), 0L), (Object)biomeRegistry.getOrThrow(ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"infernal", (String)"lushios_fields")))));
                InfernalModBiomes.addParameterPoint((List<Pair<Climate.ParameterPoint, Holder<Biome>>>)parameters, (Pair<Climate.ParameterPoint, Holder<Biome>>)new Pair((Object)new Climate.ParameterPoint(Climate.Parameter.span((float)-0.5f, (float)0.5f), Climate.Parameter.span((float)-0.5f, (float)0.5f), Climate.Parameter.span((float)0.3f, (float)1.0f), Climate.Parameter.span((float)-0.5f, (float)0.5f), Climate.Parameter.point((float)1.0f), Climate.Parameter.span((float)-1.0f, (float)1.0f), 0L), (Object)biomeRegistry.getOrThrow(ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"infernal", (String)"lushios_fields")))));
                InfernalModBiomes.addParameterPoint((List<Pair<Climate.ParameterPoint, Holder<Biome>>>)parameters, (Pair<Climate.ParameterPoint, Holder<Biome>>)new Pair((Object)new Climate.ParameterPoint(Climate.Parameter.span((float)-0.1f, (float)0.9f), Climate.Parameter.span((float)-0.1f, (float)1.45f), Climate.Parameter.span((float)0.3f, (float)0.7f), Climate.Parameter.span((float)-0.1f, (float)0.95f), Climate.Parameter.point((float)0.0f), Climate.Parameter.span((float)-1.0f, (float)1.0f), 0L), (Object)biomeRegistry.getOrThrow(ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"infernal", (String)"nether_plains")))));
                InfernalModBiomes.addParameterPoint((List<Pair<Climate.ParameterPoint, Holder<Biome>>>)parameters, (Pair<Climate.ParameterPoint, Holder<Biome>>)new Pair((Object)new Climate.ParameterPoint(Climate.Parameter.span((float)-0.1f, (float)0.9f), Climate.Parameter.span((float)-0.1f, (float)1.45f), Climate.Parameter.span((float)0.3f, (float)0.7f), Climate.Parameter.span((float)-0.1f, (float)0.95f), Climate.Parameter.point((float)1.0f), Climate.Parameter.span((float)-1.0f, (float)1.0f), 0L), (Object)biomeRegistry.getOrThrow(ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"infernal", (String)"nether_plains")))));
                InfernalModBiomes.addParameterPoint((List<Pair<Climate.ParameterPoint, Holder<Biome>>>)parameters, (Pair<Climate.ParameterPoint, Holder<Biome>>)new Pair((Object)new Climate.ParameterPoint(Climate.Parameter.span((float)0.0f, (float)2.0f), Climate.Parameter.span((float)-0.5f, (float)0.5f), Climate.Parameter.span((float)0.1f, (float)0.8f), Climate.Parameter.span((float)-0.1f, (float)0.7f), Climate.Parameter.point((float)0.0f), Climate.Parameter.span((float)-1.0f, (float)1.0f), 0L), (Object)biomeRegistry.getOrThrow(ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"infernal", (String)"volcanic_barrens")))));
                InfernalModBiomes.addParameterPoint((List<Pair<Climate.ParameterPoint, Holder<Biome>>>)parameters, (Pair<Climate.ParameterPoint, Holder<Biome>>)new Pair((Object)new Climate.ParameterPoint(Climate.Parameter.span((float)0.0f, (float)2.0f), Climate.Parameter.span((float)-0.5f, (float)0.5f), Climate.Parameter.span((float)0.1f, (float)0.8f), Climate.Parameter.span((float)-0.1f, (float)0.7f), Climate.Parameter.point((float)1.0f), Climate.Parameter.span((float)-1.0f, (float)1.0f), 0L), (Object)biomeRegistry.getOrThrow(ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"infernal", (String)"volcanic_barrens")))));
                InfernalModBiomes.addParameterPoint((List<Pair<Climate.ParameterPoint, Holder<Biome>>>)parameters, (Pair<Climate.ParameterPoint, Holder<Biome>>)new Pair((Object)new Climate.ParameterPoint(Climate.Parameter.span((float)0.05f, (float)0.825f), Climate.Parameter.span((float)-0.5f, (float)0.5f), Climate.Parameter.span((float)0.02f, (float)0.6f), Climate.Parameter.span((float)-0.07f, (float)0.85f), Climate.Parameter.point((float)0.0f), Climate.Parameter.span((float)-1.0f, (float)1.0f), 0L), (Object)biomeRegistry.getOrThrow(ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"infernal", (String)"nether_desert")))));
                InfernalModBiomes.addParameterPoint((List<Pair<Climate.ParameterPoint, Holder<Biome>>>)parameters, (Pair<Climate.ParameterPoint, Holder<Biome>>)new Pair((Object)new Climate.ParameterPoint(Climate.Parameter.span((float)0.05f, (float)0.825f), Climate.Parameter.span((float)-0.5f, (float)0.5f), Climate.Parameter.span((float)0.02f, (float)0.6f), Climate.Parameter.span((float)-0.07f, (float)0.85f), Climate.Parameter.point((float)1.0f), Climate.Parameter.span((float)-1.0f, (float)1.0f), 0L), (Object)biomeRegistry.getOrThrow(ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"infernal", (String)"nether_desert")))));
                InfernalModBiomes.addParameterPoint((List<Pair<Climate.ParameterPoint, Holder<Biome>>>)parameters, (Pair<Climate.ParameterPoint, Holder<Biome>>)new Pair((Object)new Climate.ParameterPoint(Climate.Parameter.span((float)-0.15f, (float)1.15f), Climate.Parameter.span((float)-0.95f, (float)0.9f), Climate.Parameter.span((float)0.2f, (float)0.6f), Climate.Parameter.span((float)0.0f, (float)0.75f), Climate.Parameter.point((float)0.0f), Climate.Parameter.span((float)-1.0f, (float)1.0f), 0L), (Object)biomeRegistry.getOrThrow(ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"infernal", (String)"toxic_wasteland")))));
                InfernalModBiomes.addParameterPoint((List<Pair<Climate.ParameterPoint, Holder<Biome>>>)parameters, (Pair<Climate.ParameterPoint, Holder<Biome>>)new Pair((Object)new Climate.ParameterPoint(Climate.Parameter.span((float)-0.15f, (float)1.15f), Climate.Parameter.span((float)-0.95f, (float)0.9f), Climate.Parameter.span((float)0.2f, (float)0.6f), Climate.Parameter.span((float)0.0f, (float)0.75f), Climate.Parameter.point((float)1.0f), Climate.Parameter.span((float)-1.0f, (float)1.0f), 0L), (Object)biomeRegistry.getOrThrow(ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"infernal", (String)"toxic_wasteland")))));
                InfernalModBiomes.addParameterPoint((List<Pair<Climate.ParameterPoint, Holder<Biome>>>)parameters, (Pair<Climate.ParameterPoint, Holder<Biome>>)new Pair((Object)new Climate.ParameterPoint(Climate.Parameter.span((float)-1.0f, (float)0.3f), Climate.Parameter.span((float)-2.0f, (float)0.45f), Climate.Parameter.span((float)-0.4f, (float)0.55f), Climate.Parameter.span((float)-0.9f, (float)0.3f), Climate.Parameter.point((float)0.0f), Climate.Parameter.span((float)-1.0f, (float)1.0f), 0L), (Object)biomeRegistry.getOrThrow(ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"infernal", (String)"wet_forest")))));
                InfernalModBiomes.addParameterPoint((List<Pair<Climate.ParameterPoint, Holder<Biome>>>)parameters, (Pair<Climate.ParameterPoint, Holder<Biome>>)new Pair((Object)new Climate.ParameterPoint(Climate.Parameter.span((float)-1.0f, (float)0.3f), Climate.Parameter.span((float)-2.0f, (float)0.45f), Climate.Parameter.span((float)-0.4f, (float)0.55f), Climate.Parameter.span((float)-0.9f, (float)0.3f), Climate.Parameter.point((float)1.0f), Climate.Parameter.span((float)-1.0f, (float)1.0f), 0L), (Object)biomeRegistry.getOrThrow(ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"infernal", (String)"wet_forest")))));
                chunkGenerator.biomeSource = MultiNoiseBiomeSource.createFromList((Climate.ParameterList)new Climate.ParameterList((List)parameters));
                chunkGenerator.featuresPerStep = Suppliers.memoize(() -> FeatureSorter.buildFeaturesPerStep(List.copyOf(chunkGenerator.biomeSource.possibleBiomes()), biome -> ((BiomeGenerationSettings)chunkGenerator.generationSettingsGetter.apply(biome)).features(), (boolean)true));
            }
            if (!(chunkGenerator instanceof NoiseBasedChunkGenerator)) continue;
            noiseGenerator = (NoiseBasedChunkGenerator)chunkGenerator;
            ((InfernalModNoiseGeneratorSettings)noiseGenerator.settings.value()).setinfernalDimensionTypeReference((Holder<DimensionType>)dimensionType);
        }
    }

    public static SurfaceRules.RuleSource adaptSurfaceRule(SurfaceRules.RuleSource currentRuleSource, Holder<DimensionType> dimensionType) {
        if (dimensionType.is(BuiltinDimensionTypes.OVERWORLD)) {
            return InfernalModBiomes.injectOverworldSurfaceRules(currentRuleSource);
        }
        if (dimensionType.is(BuiltinDimensionTypes.NETHER)) {
            return InfernalModBiomes.injectNetherSurfaceRules(currentRuleSource);
        }
        return currentRuleSource;
    }

    private static SurfaceRules.RuleSource injectOverworldSurfaceRules(SurfaceRules.RuleSource currentRuleSource) {
        ArrayList<SurfaceRules.RuleSource> customSurfaceRules = new ArrayList<SurfaceRules.RuleSource>();
        customSurfaceRules.add(InfernalModBiomes.preliminarySurfaceRule((ResourceKey<Biome>)ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"infernal", (String)"electric_forest")), Blocks.GRASS_BLOCK.defaultBlockState(), Blocks.DIRT.defaultBlockState(), Blocks.GRAVEL.defaultBlockState()));
        if (currentRuleSource instanceof SurfaceRules.SequenceRuleSource) {
            SurfaceRules.SequenceRuleSource sequenceRuleSource = (SurfaceRules.SequenceRuleSource)currentRuleSource;
            customSurfaceRules.addAll(sequenceRuleSource.sequence());
            return SurfaceRules.sequence((SurfaceRules.RuleSource[])((SurfaceRules.RuleSource[])customSurfaceRules.toArray(SurfaceRules.RuleSource[]::new)));
        }
        customSurfaceRules.add(currentRuleSource);
        return SurfaceRules.sequence((SurfaceRules.RuleSource[])((SurfaceRules.RuleSource[])customSurfaceRules.toArray(SurfaceRules.RuleSource[]::new)));
    }

    private static SurfaceRules.RuleSource injectNetherSurfaceRules(SurfaceRules.RuleSource currentRuleSource) {
        ArrayList<SurfaceRules.RuleSource> customSurfaceRules = new ArrayList<SurfaceRules.RuleSource>();
        customSurfaceRules.add(InfernalModBiomes.anySurfaceRule((ResourceKey<Biome>)ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"infernal", (String)"lushios_fields")), ((Block)InfernalModBlocks.LUSHIOS_NYLIUM.get()).defaultBlockState(), Blocks.NETHERRACK.defaultBlockState(), Blocks.GRAVEL.defaultBlockState()));
        customSurfaceRules.add(InfernalModBiomes.anySurfaceRule((ResourceKey<Biome>)ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"infernal", (String)"nether_plains")), ((Block)InfernalModBlocks.RESINATED_NYLIUM.get()).defaultBlockState(), Blocks.NETHERRACK.defaultBlockState(), Blocks.GRAVEL.defaultBlockState()));
        customSurfaceRules.add(InfernalModBiomes.anySurfaceRule((ResourceKey<Biome>)ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"infernal", (String)"volcanic_barrens")), Blocks.BLACKSTONE.defaultBlockState(), Blocks.BLACKSTONE.defaultBlockState(), Blocks.NETHERRACK.defaultBlockState()));
        customSurfaceRules.add(InfernalModBiomes.anySurfaceRule((ResourceKey<Biome>)ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"infernal", (String)"nether_desert")), Blocks.TERRACOTTA.defaultBlockState(), Blocks.RED_TERRACOTTA.defaultBlockState(), Blocks.GRAVEL.defaultBlockState()));
        customSurfaceRules.add(InfernalModBiomes.anySurfaceRule((ResourceKey<Biome>)ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"infernal", (String)"toxic_wasteland")), ((Block)InfernalModBlocks.TOXIC_NYLIUM.get()).defaultBlockState(), Blocks.SMOOTH_BASALT.defaultBlockState(), Blocks.NETHERRACK.defaultBlockState()));
        customSurfaceRules.add(InfernalModBiomes.anySurfaceRule((ResourceKey<Biome>)ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"infernal", (String)"wet_forest")), ((Block)InfernalModBlocks.WET_NYLIUM.get()).defaultBlockState(), Blocks.NETHERRACK.defaultBlockState(), Blocks.BASALT.defaultBlockState()));
        if (currentRuleSource instanceof SurfaceRules.SequenceRuleSource) {
            SurfaceRules.SequenceRuleSource sequenceRuleSource = (SurfaceRules.SequenceRuleSource)currentRuleSource;
            customSurfaceRules.addAll(sequenceRuleSource.sequence());
            return SurfaceRules.sequence((SurfaceRules.RuleSource[])((SurfaceRules.RuleSource[])customSurfaceRules.toArray(SurfaceRules.RuleSource[]::new)));
        }
        customSurfaceRules.add(currentRuleSource);
        return SurfaceRules.sequence((SurfaceRules.RuleSource[])((SurfaceRules.RuleSource[])customSurfaceRules.toArray(SurfaceRules.RuleSource[]::new)));
    }

    private static SurfaceRules.RuleSource preliminarySurfaceRule(ResourceKey<Biome> biomeKey, BlockState groundBlock, BlockState undergroundBlock, BlockState underwaterBlock) {
        return SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.isBiome((ResourceKey[])new ResourceKey[]{biomeKey}), (SurfaceRules.RuleSource)SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.abovePreliminarySurface(), (SurfaceRules.RuleSource)SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.stoneDepthCheck((int)0, (boolean)false, (int)0, (CaveSurface)CaveSurface.FLOOR), (SurfaceRules.RuleSource)SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.waterBlockCheck((int)-1, (int)0), (SurfaceRules.RuleSource)SurfaceRules.state((BlockState)groundBlock)), SurfaceRules.state((BlockState)underwaterBlock)})), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.stoneDepthCheck((int)0, (boolean)true, (int)0, (CaveSurface)CaveSurface.FLOOR), (SurfaceRules.RuleSource)SurfaceRules.state((BlockState)undergroundBlock))})));
    }

    private static SurfaceRules.RuleSource anySurfaceRule(ResourceKey<Biome> biomeKey, BlockState groundBlock, BlockState undergroundBlock, BlockState underwaterBlock) {
        return SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.isBiome((ResourceKey[])new ResourceKey[]{biomeKey}), (SurfaceRules.RuleSource)SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.yBlockCheck((VerticalAnchor)VerticalAnchor.aboveBottom((int)5), (int)0), (SurfaceRules.RuleSource)SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.not((SurfaceRules.ConditionSource)SurfaceRules.yBlockCheck((VerticalAnchor)VerticalAnchor.belowTop((int)5), (int)0)), (SurfaceRules.RuleSource)SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.stoneDepthCheck((int)0, (boolean)false, (int)0, (CaveSurface)CaveSurface.FLOOR), (SurfaceRules.RuleSource)SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.waterBlockCheck((int)-1, (int)0), (SurfaceRules.RuleSource)SurfaceRules.state((BlockState)groundBlock)), SurfaceRules.state((BlockState)underwaterBlock)})), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.stoneDepthCheck((int)0, (boolean)true, (int)0, (CaveSurface)CaveSurface.FLOOR), (SurfaceRules.RuleSource)SurfaceRules.state((BlockState)undergroundBlock))}))));
    }

    private static void addParameterPoint(List<Pair<Climate.ParameterPoint, Holder<Biome>>> parameters, Pair<Climate.ParameterPoint, Holder<Biome>> point) {
        if (!parameters.contains(point)) {
            parameters.add(point);
        }
    }

    public static interface InfernalModNoiseGeneratorSettings {
        public void setinfernalDimensionTypeReference(Holder<DimensionType> var1);
    }
}

