/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.infernal.init;

import net.mcreator.infernal.entity.FlamingBallProjectileEntity;
import net.mcreator.infernal.entity.PiglinAssassinEntity;
import net.mcreator.infernal.entity.RadioactiveWalkerEntity;
import net.mcreator.infernal.entity.WispEntity;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.EntityAttributeCreationEvent;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public class InfernalModEntities {
    public static final DeferredRegister<EntityType<?>> REGISTRY = DeferredRegister.create((ResourceKey)Registries.ENTITY_TYPE, (String)"infernal");
    public static final DeferredHolder<EntityType<?>, EntityType<WispEntity>> WISP = InfernalModEntities.register("wisp", EntityType.Builder.of(WispEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).ridingOffset(-0.6f).sized(0.6f, 1.8f));
    public static final DeferredHolder<EntityType<?>, EntityType<PiglinAssassinEntity>> PIGLIN_ASSASSIN = InfernalModEntities.register("piglin_assassin", EntityType.Builder.of(PiglinAssassinEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(96).setUpdateInterval(3).sized(0.6f, 1.95f));
    public static final DeferredHolder<EntityType<?>, EntityType<FlamingBallProjectileEntity>> FLAMING_BALL_PROJECTILE = InfernalModEntities.register("flaming_ball_projectile", EntityType.Builder.of(FlamingBallProjectileEntity::new, (MobCategory)MobCategory.MISC).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(1).sized(0.5f, 0.5f));
    public static final DeferredHolder<EntityType<?>, EntityType<RadioactiveWalkerEntity>> RADIOACTIVE_WALKER = InfernalModEntities.register("radioactive_walker", EntityType.Builder.of(RadioactiveWalkerEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).ridingOffset(-0.6f).sized(0.6f, 1.8f));

    private static <T extends Entity> DeferredHolder<EntityType<?>, EntityType<T>> register(String registryname, EntityType.Builder<T> entityTypeBuilder) {
        return REGISTRY.register(registryname, () -> entityTypeBuilder.build(ResourceKey.create((ResourceKey)Registries.ENTITY_TYPE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"infernal", (String)registryname))));
    }

    @SubscribeEvent
    public static void init(RegisterSpawnPlacementsEvent event) {
        WispEntity.init(event);
        PiglinAssassinEntity.init(event);
        RadioactiveWalkerEntity.init(event);
    }

    @SubscribeEvent
    public static void registerAttributes(EntityAttributeCreationEvent event) {
        event.put((EntityType)WISP.get(), WispEntity.createAttributes().build());
        event.put((EntityType)PIGLIN_ASSASSIN.get(), PiglinAssassinEntity.createAttributes().build());
        event.put((EntityType)RADIOACTIVE_WALKER.get(), RadioactiveWalkerEntity.createAttributes().build());
    }
}

