/*
 * Decompiled with CFR 0.152.
 */
package dev.dfonline.codeclient;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import dev.dfonline.codeclient.ChestFeature;
import dev.dfonline.codeclient.Event;
import dev.dfonline.codeclient.Feature;
import dev.dfonline.codeclient.Utility;
import dev.dfonline.codeclient.action.Action;
import dev.dfonline.codeclient.action.None;
import dev.dfonline.codeclient.action.impl.DevForBuild;
import dev.dfonline.codeclient.command.CommandManager;
import dev.dfonline.codeclient.command.CommandSender;
import dev.dfonline.codeclient.config.Config;
import dev.dfonline.codeclient.config.KeyBinds;
import dev.dfonline.codeclient.data.DFItem;
import dev.dfonline.codeclient.data.ItemData;
import dev.dfonline.codeclient.data.PublicBukkitValues;
import dev.dfonline.codeclient.data.value.DataValue;
import dev.dfonline.codeclient.data.value.NumberDataValue;
import dev.dfonline.codeclient.data.value.StringDataValue;
import dev.dfonline.codeclient.dev.BlockBreakDeltaCalculator;
import dev.dfonline.codeclient.dev.BuildPhaser;
import dev.dfonline.codeclient.dev.ChatAutoEdit;
import dev.dfonline.codeclient.dev.LastPos;
import dev.dfonline.codeclient.dev.MessageHiding;
import dev.dfonline.codeclient.dev.Navigation;
import dev.dfonline.codeclient.dev.NoClip;
import dev.dfonline.codeclient.dev.PreviewSoundChest;
import dev.dfonline.codeclient.dev.RecentChestInsert;
import dev.dfonline.codeclient.dev.ReportBrokenBlocks;
import dev.dfonline.codeclient.dev.ValueDetails;
import dev.dfonline.codeclient.dev.debug.Debug;
import dev.dfonline.codeclient.dev.highlighter.ExpressionHighlighter;
import dev.dfonline.codeclient.dev.menu.AdvancedMiddleClickFeature;
import dev.dfonline.codeclient.dev.menu.InsertOverlayFeature;
import dev.dfonline.codeclient.dev.menu.RecentValues;
import dev.dfonline.codeclient.dev.menu.SlotGhostManager;
import dev.dfonline.codeclient.dev.overlay.ActionViewer;
import dev.dfonline.codeclient.dev.overlay.CPUDisplay;
import dev.dfonline.codeclient.dev.overlay.ChestPeeker;
import dev.dfonline.codeclient.hypercube.actiondump.ActionDump;
import dev.dfonline.codeclient.location.Build;
import dev.dfonline.codeclient.location.Creator;
import dev.dfonline.codeclient.location.Dev;
import dev.dfonline.codeclient.location.Location;
import dev.dfonline.codeclient.location.Plot;
import dev.dfonline.codeclient.location.Spawn;
import dev.dfonline.codeclient.switcher.ScopeSwitcher;
import dev.dfonline.codeclient.switcher.SpeedSwitcher;
import dev.dfonline.codeclient.switcher.StateSwitcher;
import dev.dfonline.codeclient.websocket.SocketHandler;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.net.URI;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientLifecycleEvents;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.item.v1.ItemTooltipCallback;
import net.fabricmc.fabric.api.client.rendering.v1.BlockRenderLayerMap;
import net.fabricmc.fabric.api.client.screen.v1.ScreenEvents;
import net.fabricmc.fabric.api.client.screen.v1.ScreenKeyboardEvents;
import net.fabricmc.fabric.api.client.screen.v1.ScreenMouseEvents;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.fabricmc.fabric.api.resource.ResourcePackActivationType;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.class_11515;
import net.minecraft.class_124;
import net.minecraft.class_1713;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2547;
import net.minecraft.class_2561;
import net.minecraft.class_2591;
import net.minecraft.class_2596;
import net.minecraft.class_2622;
import net.minecraft.class_2637;
import net.minecraft.class_2645;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3965;
import net.minecraft.class_408;
import net.minecraft.class_433;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_465;
import net.minecraft.class_638;
import net.minecraft.class_8042;
import net.minecraft.class_8242;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CodeClient
implements ClientModInitializer {
    public static final String MOD_NAME = "CodeClient";
    public static final String MOD_ID = "codeclient";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"CodeClient");
    public static final Gson gson = new Gson();
    public static class_310 MC = class_310.method_1551();
    public static AutoJoin autoJoin = AutoJoin.NONE;
    public static Utility.Toast startupToast;
    @NotNull
    public static Action currentAction;
    public static Action confirmingAction;
    public static Location lastLocation;
    public static Location location;
    public static class_437 screenToOpen;
    public static boolean shouldReload;
    public static boolean isPreviewingItemTags;
    private static final HashMap<Class<? extends Feature>, Feature> features;
    private static boolean isCodeChest;
    public static SocketHandler API;

    public void onInitializeClient() {
        MC = class_310.method_1551();
        CodeClient.loadFeatures();
        ClientTickEvents.START_CLIENT_TICK.register(client -> {
            if (CodeClient.MC.field_1724 == null || CodeClient.MC.field_1687 == null) {
                CodeClient.clean();
            }
            if (screenToOpen != null) {
                MC.method_1507(screenToOpen);
                screenToOpen = null;
            }
        });
        BlockRenderLayerMap.putBlock((class_2248)class_2246.field_10499, (class_11515)class_11515.field_60926);
        BlockRenderLayerMap.putBlock((class_2248)class_2246.field_10369, (class_11515)class_11515.field_60926);
        BlockRenderLayerMap.putBlock((class_2248)class_2246.field_31037, (class_11515)class_11515.field_60926);
        ClientLifecycleEvents.CLIENT_STOPPING.register(class_2960.method_60655((String)MOD_ID, (String)"close"), client -> API.stop());
        ClientTickEvents.END_CLIENT_TICK.register(client -> CommandSender.tick());
        if (Config.getConfig().CodeClientAPI) {
            try {
                API.start();
            }
            catch (Exception e) {
                LOGGER.error(e.getMessage());
            }
        }
        if (Config.getConfig().AutoJoin) {
            autoJoin = AutoJoin.GAME;
        }
        KeyBinds.init();
        ClientCommandRegistrationCallback.EVENT.register((dispatcher, registryAccess) -> CommandManager.init((CommandDispatcher<FabricClientCommandSource>)dispatcher, registryAccess));
        ItemTooltipCallback.EVENT.register((stack, context, type, lines) -> {
            Plot plot;
            Location patt0$temp;
            if (isPreviewingItemTags && ((patt0$temp = location) instanceof Plot && (plot = (Plot)patt0$temp).getHasDev().orElse(false).booleanValue() || location instanceof Creator)) {
                DFItem item = DFItem.of(stack);
                ItemData itemData = item.getItemData();
                if (itemData == null) {
                    return;
                }
                PublicBukkitValues publicBukkit = itemData.getPublicBukkitValues();
                if (publicBukkit == null) {
                    return;
                }
                for (String key : publicBukkit.getHypercubeKeys()) {
                    String stringElement;
                    DataValue element = publicBukkit.getHypercubeValue(key);
                    class_124 formatting = class_124.field_1060;
                    String string = stringElement = element.getValue() == null ? "?" : element.getValue().toString();
                    if (element instanceof StringDataValue) {
                        formatting = class_124.field_1075;
                    }
                    if (element instanceof NumberDataValue) {
                        NumberDataValue numberDataValue = (NumberDataValue)element;
                        formatting = class_124.field_1061;
                        stringElement = String.valueOf(numberDataValue.getValue());
                    }
                    lines.add(class_2561.method_43470((String)key).method_54663(0xAAFF55).method_10852((class_2561)class_2561.method_43470((String)" = ").method_27692(class_124.field_1063)).method_10852((class_2561)class_2561.method_43470((String)stringElement).method_27692(formatting)));
                }
            }
        });
        ScreenEvents.AFTER_INIT.register((client, screen, scaledWidth, scaledHeight) -> {
            ScreenKeyboardEvents.allowKeyPress((class_437)screen).register((screen1, key, scancode, modifiers) -> !CodeClient.onKeyPressed(key, scancode, modifiers));
            ScreenKeyboardEvents.allowKeyRelease((class_437)screen).register((screen1, key, scancode, modifiers) -> !CodeClient.onKeyReleased(key, scancode, modifiers));
            ScreenMouseEvents.allowMouseClick((class_437)screen).register((screen1, mouseX, mouseY, button) -> !CodeClient.onMouseClicked(mouseX, mouseY, button));
            ScreenMouseEvents.allowMouseScroll((class_437)screen).register((screen1, mouseX, mouseY, horizontalAmount, verticalAmount) -> !CodeClient.onMouseScrolled(mouseX, mouseY, horizontalAmount, verticalAmount));
        });
        try {
            this.registerResourcePack("dark_mode", (class_2561)class_2561.method_43470((String)"Dark Mode").method_27692(class_124.field_1068));
        }
        catch (NullPointerException exception) {
            LOGGER.warn("Could not load dark mode resource pack!");
        }
        LOGGER.info("CodeClient, making it easier to wipe your plot and get banned for hacks since 2022");
    }

    private static void feat(Feature feature) {
        features.put(feature.getClass(), feature);
    }

    private static void loadFeatures() {
        features.clear();
        CodeClient.feat(new BuildPhaser());
        CodeClient.feat(new ChestPeeker());
        CodeClient.feat(new Debug());
        CodeClient.feat(new RecentChestInsert());
        CodeClient.feat(new BlockBreakDeltaCalculator());
        CodeClient.feat(new Navigation());
        CodeClient.feat(new NoClip());
        CodeClient.feat(new ReportBrokenBlocks());
        CodeClient.feat(new InsertOverlayFeature());
        CodeClient.feat(new SlotGhostManager());
        CodeClient.feat(new ActionViewer());
        CodeClient.feat(new RecentValues());
        CodeClient.feat(new ValueDetails());
        CodeClient.feat(new ChatAutoEdit());
        CodeClient.feat(new CPUDisplay());
        CodeClient.feat(new MessageHiding());
        CodeClient.feat(new ExpressionHighlighter());
        CodeClient.feat(new PreviewSoundChest());
        CodeClient.feat(new AdvancedMiddleClickFeature());
        CodeClient.feat(new StateSwitcher.StateSwitcherFeature());
        CodeClient.feat(new SpeedSwitcher.SpeedSwitcherFeature());
        CodeClient.feat(new ScopeSwitcher.ScopeSwitcherFeature());
    }

    private static Stream<Feature> features() {
        return features.values().stream().filter(Feature::enabled);
    }

    private static Stream<ChestFeature> chestFeatures() {
        return CodeClient.features().map(Feature::getChest).filter(Optional::isPresent).map(Optional::get);
    }

    public static class_2960 getId(String path) {
        return class_2960.method_60655((String)MOD_ID, (String)path);
    }

    public static void isCodeChest() {
        isCodeChest = true;
    }

    public static <T extends Feature> Optional<T> getFeature(Class<T> clazz) {
        Feature feat = features.get(clazz);
        if (feat != null && feat.enabled()) {
            return Optional.of((Feature)clazz.cast(feat));
        }
        return Optional.empty();
    }

    public static <T extends class_2547> boolean handlePacket(class_2596<T> packet) {
        if (packet instanceof class_8042) {
            class_8042 bundle = (class_8042)packet;
            bundle.method_48324().forEach(CodeClient::handlePacket);
            return false;
        }
        if (currentAction.onReceivePacket(packet)) {
            return true;
        }
        for (Feature feature : CodeClient.features().toList()) {
            if (!feature.onReceivePacket(packet)) continue;
            return true;
        }
        Event.handlePacket(packet);
        LastPos.handlePacket(packet);
        String name = packet.getClass().getName().replace("net.minecraft.network.packet.s2c.play.", "");
        Location location = CodeClient.location;
        if (location instanceof Dev) {
            Dev dev = (Dev)location;
            try {
                class_2622 beu;
                if (packet instanceof class_2622 && dev.isInDev((beu = (class_2622)packet).method_11293()).booleanValue() && beu.method_11291() == class_2591.field_11911) {
                    class_2487 compound = beu.method_11290();
                    if (compound.method_10545("front_text")) {
                        class_8242 text = (class_8242)((Pair)class_8242.field_43298.decode((DynamicOps)class_2509.field_11560, (Object)beu.method_11290().method_10580("front_text")).getOrThrow()).getFirst();
                        if (Plot.lineStarterPattern.matcher(text.method_49859(0, false).getString()).matches()) {
                            dev.getLineStartCache().put(beu.method_11293(), text);
                        }
                    } else {
                        dev.clearLineStarterCache();
                    }
                }
            }
            catch (ConcurrentModificationException exception) {
                dev.clearLineStarterCache();
            }
            catch (IllegalStateException exception) {
                dev.clearLineStarterCache();
            }
            if (packet instanceof class_2637) {
                class_2637 update = (class_2637)packet;
                update.method_30621((blockPos, blockState) -> dev.getLineStartCache().remove(blockPos));
            }
        }
        return (CodeClient.MC.field_1755 instanceof class_433 || CodeClient.MC.field_1755 instanceof class_408 || CodeClient.MC.field_1755 instanceof StateSwitcher) && packet instanceof class_2645;
    }

    public static <T extends class_2547> boolean onSendPacket(class_2596<T> packet) {
        if (currentAction.onSendPacket(packet)) {
            return true;
        }
        for (Feature feature : CodeClient.features().toList()) {
            if (!feature.onSendPacket(packet)) continue;
            return true;
        }
        Event.onSendPacket(packet);
        String name = packet.getClass().getName().replace("net.minecraft.network.packet.c2s.play.", "");
        return false;
    }

    public static void onTick() {
        Location location;
        currentAction.tick();
        CodeClient.features().forEach(Feature::tick);
        KeyBinds.tick();
        if (!(CodeClient.location instanceof Dev) || !(CodeClient.MC.field_1755 instanceof class_465)) {
            isCodeChest = false;
            CodeClient.features().forEach(Feature::closeChest);
        }
        if ((location = CodeClient.location) instanceof Dev) {
            Dev dev = (Dev)location;
            if (CodeClient.MC.field_1724 == null) {
                return;
            }
            class_2338 pos = new class_2338(dev.getX() - 1, 49, dev.getZ().intValue());
            if (dev.getSize() == null) {
                class_638 world = CodeClient.MC.field_1687;
                if (world == null) {
                    return;
                }
                class_2680 FIFTY = world.method_8320(pos.method_10077(50));
                class_2680 FIFTY_ONE = world.method_8320(pos.method_10077(51));
                class_2680 HUNDRED = world.method_8320(pos.method_10077(100));
                class_2680 HUNDRED_ONE = world.method_8320(pos.method_10077(101));
                class_2680 THREE_HUNDRED = world.method_8320(pos.method_10077(300));
                class_2680 THREE_HUNDRED_ONE = world.method_8320(pos.method_10077(301));
                class_2680 MEGA = world.method_8320(pos.method_10069(-19, 0, 10));
                class_2680 MEGA_ONE = world.method_8320(pos.method_10069(-20, 0, 10));
                if (MEGA_ONE.method_27852(class_2246.field_10219) && MEGA.method_27852(class_2246.field_10219)) {
                    dev.setSize(Plot.Size.MEGA);
                } else if (!(MEGA.method_27852(class_2246.field_10243) || MEGA_ONE.method_27852(class_2246.field_10243) || MEGA.method_27852(class_2246.field_10219) || MEGA.method_27852(class_2246.field_10340) || MEGA_ONE.method_27852(class_2246.field_10219))) {
                    dev.setSize(Plot.Size.MEGA);
                } else if (!(FIFTY.method_27852(class_2246.field_10243) || FIFTY_ONE.method_27852(class_2246.field_10243) || FIFTY.method_27852(FIFTY_ONE.method_26204()))) {
                    dev.setSize(Plot.Size.BASIC);
                } else if (!(HUNDRED.method_27852(class_2246.field_10243) || HUNDRED_ONE.method_27852(class_2246.field_10243) || HUNDRED.method_27852(HUNDRED_ONE.method_26204()))) {
                    dev.setSize(Plot.Size.LARGE);
                } else if (!(THREE_HUNDRED.method_27852(class_2246.field_10243) || THREE_HUNDRED_ONE.method_27852(class_2246.field_10243) || THREE_HUNDRED.method_27852(THREE_HUNDRED_ONE.method_26204()))) {
                    dev.setSize(Plot.Size.MASSIVE);
                }
            }
            Plot.Size size = dev.assumeSize();
            assert (CodeClient.MC.field_1687 != null);
            class_2680 groundCheck = CodeClient.MC.field_1687.method_8320(new class_2338(Math.max(Math.min((int)CodeClient.MC.field_1724.method_23317(), dev.getX() - 1), dev.getX() - size.codeWidth), 49, Math.max(Math.min((int)CodeClient.MC.field_1724.method_23321(), dev.getZ() + size.codeLength), dev.getZ())));
            if (!groundCheck.method_27852(class_2246.field_10243)) {
                dev.setHasUnderground(!groundCheck.method_27852(class_2246.field_10219) && !groundCheck.method_27852(class_2246.field_10340));
            }
        }
        if ((location = CodeClient.location) instanceof Spawn) {
            Spawn spawn = (Spawn)location;
            if (MC.method_1562() != null && spawn.consumeHasJustJoined()) {
                if (autoJoin == AutoJoin.PLOT) {
                    MC.method_1562().method_45730("join " + Config.getConfig().AutoJoinPlotId);
                    autoJoin = AutoJoin.NONE;
                } else if (Config.getConfig().AutoFly) {
                    MC.method_1562().method_45730("fly");
                }
            }
        }
    }

    public static void onRender(class_4587 matrices, class_4597.class_4598 vertexConsumers, double cameraX, double cameraY, double cameraZ) {
        CodeClient.features().forEach(feature -> feature.render(matrices, vertexConsumers, cameraX, cameraY, cameraZ));
        if (shouldReload) {
            CodeClient.MC.field_1769.method_3279();
            shouldReload = false;
        }
    }

    public static void onClickChest(class_3965 hitResult) {
        CodeClient.features().forEach(feature -> feature.onClickChest(hitResult));
    }

    public static void onBreakBlock(Dev dev, class_2338 pos, class_2338 breakPos) {
        CodeClient.features().forEach(feature -> feature.onBreakBlock(dev, pos, breakPos));
    }

    public static void onScreenInit(class_465<?> screen) {
        CodeClient.features().forEach(Feature::closeChest);
        if (!isCodeChest) {
            return;
        }
        CodeClient.features().forEach(feat -> feat.openChest(screen));
    }

    public static void onScreenClosed() {
        isCodeChest = false;
        CodeClient.features().forEach(Feature::closeChest);
    }

    public static void onRender(class_332 context, int mouseX, int mouseY, int x, int y, float delta) {
        CodeClient.chestFeatures().forEach(feat -> feat.render(context, mouseX, mouseY, x, y, delta));
    }

    public static void onDrawSlot(class_332 context, class_1735 slot) {
        CodeClient.chestFeatures().forEach(feat -> feat.drawSlot(context, slot));
    }

    public static class_1799 onGetHoverStack(class_1735 instance) {
        return CodeClient.chestFeatures().map(feat -> feat.getHoverStack(instance)).filter(Objects::nonNull).findFirst().orElse(null);
    }

    public static boolean onMouseClicked(double mouseX, double mouseY, int button) {
        return CodeClient.chestFeatures().anyMatch(feature -> feature.mouseClicked(mouseX, mouseY, button));
    }

    public static boolean onKeyPressed(int keyCode, int scanCode, int modifiers) {
        return CodeClient.chestFeatures().anyMatch(feature -> feature.keyPressed(keyCode, scanCode, modifiers));
    }

    public static boolean onKeyReleased(int keyCode, int scanCode, int modifiers) {
        return CodeClient.chestFeatures().anyMatch(feature -> feature.keyReleased(keyCode, scanCode, modifiers));
    }

    public static boolean onCharTyped(char chr, int modifiers) {
        return CodeClient.chestFeatures().anyMatch(feature -> feature.charTyped(chr, modifiers));
    }

    public static boolean onClickSlot(class_1735 slot, int button, class_1713 actionType, int syncId, int revision) {
        return CodeClient.chestFeatures().anyMatch(feature -> feature.clickSlot(slot, button, actionType, syncId, revision));
    }

    public static boolean onMouseScrolled(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        return CodeClient.chestFeatures().anyMatch(feature -> feature.mouseScrolled(mouseX, mouseY, horizontalAmount, verticalAmount));
    }

    public static boolean noClipOn() {
        if (CodeClient.MC.field_1724 == null) {
            return false;
        }
        if (!Config.getConfig().NoClipEnabled) {
            return false;
        }
        if (!(location instanceof Dev)) {
            return false;
        }
        if (!(currentAction instanceof None)) {
            return false;
        }
        return CodeClient.MC.field_1724.method_31549().field_7477;
    }

    public static void clean() {
        for (Feature feature : features.values()) {
            feature.reset();
        }
        currentAction = new None();
        confirmingAction = null;
        location = null;
        screenToOpen = null;
    }

    public static void reset() {
        CodeClient.clean();
        CodeClient.loadFeatures();
        API.setConnection(null);
        ActionDump.clear();
        Config.clear();
    }

    public static void onModeChange(Location location) {
        if (location instanceof Dev) {
            Dev dev = (Dev)location;
            dev.clearLineStarterCache();
        }
        if (Config.getConfig().DevForBuild && (currentAction instanceof None || currentAction instanceof DevForBuild) && location instanceof Build) {
            currentAction = new DevForBuild(() -> {
                currentAction = new None();
            });
            currentAction.init();
        }
        currentAction.onModeChange(location);
    }

    public static ModContainer getModContainer() throws NullPointerException {
        Optional container = FabricLoader.getInstance().getModContainer(MOD_ID);
        if (container.isEmpty()) {
            throw new NullPointerException("Could not get mod container.");
        }
        return (ModContainer)container.get();
    }

    private boolean registerResourcePack(String id, class_2561 name) throws NullPointerException {
        return this.registerResourcePack(id, name, ResourcePackActivationType.NORMAL);
    }

    private boolean registerResourcePack(String id, class_2561 name, ResourcePackActivationType type) throws NullPointerException {
        String prefix = String.format("[%s] ", MOD_NAME);
        return ResourceManagerHelper.registerBuiltinResourcePack((class_2960)CodeClient.getId(id), (ModContainer)CodeClient.getModContainer(), (class_2561)class_2561.method_43470((String)prefix).method_27692(class_124.field_1080).method_10852(name), (ResourcePackActivationType)type);
    }

    public static void parseVersionInfo(String response) {
        JsonObject json = JsonParser.parseString((String)response).getAsJsonObject();
        String versionNumber = json.get("version_number").getAsString();
        if (Config.getConfig().AutoUpdateOption != Config.AutoUpdate.UPDATE) {
            startupToast = new Utility.Toast((class_2561)class_2561.method_43469((String)"toast.codeclient.update_available.title", (Object[])new Object[]{versionNumber}), (class_2561)class_2561.method_43471((String)"toast.codeclient.update_available"));
            return;
        }
        JsonArray files = json.getAsJsonArray("files");
        files.forEach(file -> {
            JsonObject fileObject = file.getAsJsonObject();
            if (fileObject.get("primary").getAsBoolean()) {
                String url = fileObject.get("url").getAsString();
                LOGGER.info("Updated mod URL: {}", (Object)url);
                try (InputStream inputStream = new URI(url).toURL().openStream();
                     ReadableByteChannel rbc = Channels.newChannel(inputStream);
                     FileOutputStream fos = new FileOutputStream("mods/CodeClient-" + versionNumber + ".jar");){
                    LOGGER.info("Starting download...");
                    fos.getChannel().transferFrom(rbc, 0L, Long.MAX_VALUE);
                }
                catch (Exception e) {
                    try {
                        LOGGER.error("Failed to download the file: {}", (Object)e.getMessage());
                    }
                    catch (Throwable throwable) {
                        LOGGER.info("Download complete.");
                        startupToast = new Utility.Toast((class_2561)class_2561.method_43469((String)"toast.codeclient.update.title", (Object[])new Object[]{versionNumber}), (class_2561)class_2561.method_43471((String)"toast.codeclient.update"));
                        throw throwable;
                    }
                    LOGGER.info("Download complete.");
                    startupToast = new Utility.Toast((class_2561)class_2561.method_43469((String)"toast.codeclient.update.title", (Object[])new Object[]{versionNumber}), (class_2561)class_2561.method_43471((String)"toast.codeclient.update"));
                }
                LOGGER.info("Download complete.");
                startupToast = new Utility.Toast((class_2561)class_2561.method_43469((String)"toast.codeclient.update.title", (Object[])new Object[]{versionNumber}), (class_2561)class_2561.method_43471((String)"toast.codeclient.update"));
            }
        });
    }

    static {
        currentAction = new None();
        confirmingAction = null;
        lastLocation = null;
        location = null;
        screenToOpen = null;
        shouldReload = false;
        isPreviewingItemTags = false;
        features = new HashMap();
        isCodeChest = false;
        API = new SocketHandler();
    }

    public static enum AutoJoin {
        NONE,
        GAME,
        PLOT;

    }
}

