/*
 * Decompiled with CFR 0.152.
 */
package dev.dfonline.codeclient;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import dev.dfonline.codeclient.ChatType;
import dev.dfonline.codeclient.CodeClient;
import dev.dfonline.codeclient.action.impl.GetActionDump;
import dev.dfonline.codeclient.data.DFItem;
import dev.dfonline.codeclient.hypercube.template.Template;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.HexFormat;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.GZIPOutputStream;
import net.kyori.adventure.platform.modcommon.impl.NonWrappingComponentSerializer;
import net.kyori.adventure.text.Component;
import net.minecraft.class_124;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2519;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2596;
import net.minecraft.class_2873;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_5250;
import net.minecraft.class_5251;
import net.minecraft.class_5481;
import net.minecraft.class_746;
import net.minecraft.class_8824;
import org.jetbrains.annotations.Nullable;

public class Utility {
    public static int getRemoteSlot(int slot) {
        if (0 <= slot && slot <= 8) {
            return slot + 36;
        }
        return slot;
    }

    public static void sendInventory() {
        if (CodeClient.MC.method_1562() == null || CodeClient.MC.field_1724 == null) {
            return;
        }
        for (int i = 0; i <= 35; ++i) {
            CodeClient.MC.method_1562().method_52787((class_2596)new class_2873(Utility.getRemoteSlot(i), CodeClient.MC.field_1724.method_31548().method_5438(i)));
        }
    }

    public static void makeHolding(class_1799 item) {
        if (CodeClient.MC.field_1724 == null) {
            return;
        }
        class_1661 inv = CodeClient.MC.field_1724.method_31548();
        Utility.sendHandItem(item);
        inv.method_61496(0);
        inv.method_5447(0, item);
    }

    public static void debug(Object object) {
        Utility.debug(Objects.toString(object));
    }

    public static void debug(String message) {
        CodeClient.LOGGER.info("%%% DEBUG: {}", (Object)message);
    }

    public static String templateDataItem(class_1799 item) {
        DFItem dfItem = DFItem.of(item);
        Optional<String> codeTemplateData = dfItem.getHypercubeStringValue("codetemplatedata");
        return codeTemplateData.map(s -> JsonParser.parseString((String)s).getAsJsonObject().get("code").getAsString()).orElse(null);
    }

    public static class_1799 makeTemplate(String code) {
        class_1799 template = new class_1799((class_1935)class_1802.field_8466);
        DFItem dfItem = DFItem.of(template);
        dfItem.editData(data -> data.setHypercubeStringValue("codetemplatedata", "{\"author\":\"CodeClient\",\"name\":\"Template to be placed\",\"version\":1,\"code\":\"" + code + "\"}"));
        return dfItem.getItemStack();
    }

    public static Template templateItem(class_1799 item) {
        String codeTemplateData = Utility.templateDataItem(item);
        return Template.parse64(codeTemplateData);
    }

    public static void addLore(class_1799 stack, class_2561 ... lore) {
        DFItem item = DFItem.of(stack);
        List<class_2561> currentLore = item.getLore();
        ArrayList<class_2561> newLore = new ArrayList<class_2561>(currentLore);
        newLore.addAll(List.of(lore));
        item.setLore(newLore);
    }

    public static void sendHandItem(class_1799 item) {
        if (CodeClient.MC.method_1562() == null || CodeClient.MC.field_1724 == null) {
            return;
        }
        CodeClient.MC.method_1562().method_52787((class_2596)new class_2873(36 + CodeClient.MC.field_1724.method_31548().method_67532(), item));
    }

    public static List<class_1799> templatesInInventory() {
        if (CodeClient.MC.field_1724 == null) {
            return null;
        }
        class_1661 inv = CodeClient.MC.field_1724.method_31548();
        ArrayList<class_1799> templates = new ArrayList<class_1799>();
        for (int i = 0; i < 36; ++i) {
            class_1799 item = inv.method_5438(i);
            DFItem dfItem = DFItem.of(item);
            if (!dfItem.hasHypercubeKey("codetemplatedata")) continue;
            templates.add(item);
        }
        return templates;
    }

    public static String compileTemplate(JsonObject data) throws IOException {
        return Utility.compileTemplate(data.getAsString());
    }

    public static String compileTemplate(String data) throws IOException {
        ByteArrayOutputStream obj = new ByteArrayOutputStream();
        GZIPOutputStream gzip = new GZIPOutputStream(obj);
        gzip.write(data.getBytes());
        gzip.close();
        return new String(Base64.getEncoder().encode(obj.toByteArray()));
    }

    @Deprecated
    public static void sendMessage(String message, ChatType type) {
        Utility.sendMessage((class_2561)class_2561.method_43470((String)message), type);
    }

    public static void sendMessage(class_2561 message) {
        Utility.sendMessage(message, ChatType.INFO);
    }

    public static void sendMessage(class_2561 message, @Nullable ChatType type) {
        class_746 player = CodeClient.MC.field_1724;
        if (player == null) {
            return;
        }
        if (type == null) {
            player.method_7353(message, false);
        } else {
            player.method_7353((class_2561)class_2561.method_43473().method_10852((class_2561)type.getText()).method_10852((class_2561)class_2561.method_43470((String)" ")).method_10852(message), false);
            if (type == ChatType.FAIL) {
                player.method_5783((class_3414)class_3417.field_18310.comp_349(), 2.0f, 0.0f);
            }
        }
    }

    public static class_2519 textToNBT(class_2561 text) {
        JsonElement json = (JsonElement)class_8824.field_46597.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)text).getOrThrow();
        if (json.isJsonObject()) {
            JsonObject obj = (JsonObject)json;
            if (!obj.has("color")) {
                obj.addProperty("color", "white");
            }
            if (!obj.has("italic")) {
                obj.addProperty("italic", Boolean.valueOf(false));
            }
            if (!obj.has("bold")) {
                obj.addProperty("bold", Boolean.valueOf(false));
            }
            return class_2519.method_23256((String)obj.toString());
        }
        return class_2519.method_23256((String)json.toString());
    }

    public static class_5250 textFromString(String text) {
        class_5250 output = class_2561.method_43473().method_10862(class_2561.method_43473().method_10866().method_27703(class_5251.method_27717((int)0xFFFFFF)).method_10978(Boolean.valueOf(false)));
        class_5250 component = class_2561.method_43473().method_27694(s -> s.method_10978(Boolean.valueOf(false)));
        Matcher m = Pattern.compile("\u00a7(([0-9a-kfmnolr])|x(\u00a7[0-9a-f]){6})|[^\u00a7]+").matcher(text);
        while (m.find()) {
            String data = m.group();
            if (data.startsWith("\u00a7")) {
                if (data.startsWith("\u00a7x")) {
                    component = component.method_10862(component.method_10866().method_36139(Integer.valueOf(data.replaceAll("\u00a7x|\u00a7", ""), 16).intValue()));
                    continue;
                }
                component = component.method_27692(class_124.method_544((char)data.charAt(1)));
                continue;
            }
            component.method_27693(data);
            output.method_10852((class_2561)component);
            component = class_2561.method_43473().method_10862(component.method_10866());
        }
        return output;
    }

    public static boolean isGlitchStick(class_1799 item) {
        DFItem dfItem = DFItem.of(item);
        if (!dfItem.hasHypercubeKey("item_instance")) {
            return false;
        }
        return Objects.equals(dfItem.getName(), class_2561.method_43470((String)"Glitch Stick").method_10862(class_2583.field_24360.method_10977(class_124.field_1061).method_10978(Boolean.valueOf(false))));
    }

    public static HashMap<Integer, String> getBlockTagLines(class_1799 item) {
        return null;
    }

    public static void textToString(class_2561 content, StringBuilder build, GetActionDump.ColorMode colorMode) {
        class_5251 lastColor = null;
        for (class_2561 text : content.method_10855()) {
            class_5251 color = text.method_10866().method_10973();
            if (color != null && lastColor != color && colorMode != GetActionDump.ColorMode.NONE) {
                lastColor = color;
                if (color.method_27721().contains("#")) {
                    build.append(String.join((CharSequence)colorMode.text, color.method_27721().split("")).replace("#", colorMode.text + "x").toLowerCase());
                } else {
                    build.append(class_124.valueOf((String)String.valueOf(color).toUpperCase()).toString().replace("\u00a7", colorMode.text));
                }
            }
            build.append(text.getString());
        }
    }

    public static String textToString(class_2561 content) {
        StringBuilder builder = new StringBuilder();
        Utility.textToString(content, builder, GetActionDump.ColorMode.SECTION);
        return builder.toString();
    }

    public static String genAuthToken() {
        SecureRandom random = new SecureRandom();
        byte[] randomBytes = new byte[32];
        random.nextBytes(randomBytes);
        return HexFormat.of().formatHex(randomBytes);
    }

    public static String fromTrimmed(String trimmedUUID) {
        if (trimmedUUID == null) {
            throw new IllegalArgumentException();
        }
        StringBuilder builder = new StringBuilder(trimmedUUID.trim());
        try {
            builder.insert(20, "-");
            builder.insert(16, "-");
            builder.insert(12, "-");
            builder.insert(8, "-");
        }
        catch (StringIndexOutOfBoundsException e) {
            throw new IllegalArgumentException();
        }
        return builder.toString();
    }

    public static class_5481 componentToOrderedText(Component component) {
        return NonWrappingComponentSerializer.INSTANCE.serialize(component).method_30937();
    }

    public static class_2561 componentToText(Component component) {
        return NonWrappingComponentSerializer.INSTANCE.serialize(component);
    }

    public record Toast(class_2561 title, class_2561 description) {
    }
}

