/*
 * Decompiled with CFR 0.152.
 */
package dev.dfonline.codeclient.action.impl;

import dev.dfonline.codeclient.Callback;
import dev.dfonline.codeclient.CodeClient;
import dev.dfonline.codeclient.Utility;
import dev.dfonline.codeclient.action.Action;
import dev.dfonline.codeclient.action.impl.GoTo;
import dev.dfonline.codeclient.hypercube.template.Template;
import dev.dfonline.codeclient.location.Dev;
import dev.dfonline.codeclient.location.Location;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Pattern;
import net.minecraft.class_10185;
import net.minecraft.class_1268;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_243;
import net.minecraft.class_2596;
import net.minecraft.class_2653;
import net.minecraft.class_2851;
import net.minecraft.class_2873;
import net.minecraft.class_3965;
import net.minecraft.class_634;
import net.minecraft.class_636;
import net.minecraft.class_746;
import org.jetbrains.annotations.Nullable;

public class ScanPlot
extends Action {
    private static final class_243 goToOffset = new class_243(0.0, 1.5, 0.0);
    private final ArrayList<class_1799> returnList;
    private List<class_2338> blocks = null;
    private HashMap<class_2338, class_1799> scanned = null;
    private Action step = null;

    public ScanPlot(Callback callback, ArrayList<class_1799> scanList) {
        super(callback);
        this.returnList = scanList;
        if (!(CodeClient.location instanceof Dev)) {
            throw new IllegalStateException("Player must be in dev mode.");
        }
    }

    @Override
    public void init() {
        Location location = CodeClient.location;
        if (location instanceof Dev) {
            Dev plot = (Dev)location;
            this.blocks = plot.scanForSigns(Pattern.compile("(PLAYER|ENTITY) EVENT|FUNCTION|PROCESS"), Pattern.compile(".*")).keySet().stream().toList();
            this.scanned = new HashMap(this.blocks.size());
        }
    }

    @Override
    public boolean onReceivePacket(class_2596<?> packet) {
        if (this.step != null) {
            return this.step.onReceivePacket(packet);
        }
        return false;
    }

    @Nullable
    private class_2338 findNextBlock() {
        class_243 player = CodeClient.MC.field_1724.method_19538();
        class_2338 nearest = null;
        for (class_2338 pos : this.blocks) {
            if (nearest != null && !pos.method_19769((class_2374)player, nearest.method_46558().method_1022(player)) || this.scanned.containsKey(pos) && this.scanned.get(pos) != null) continue;
            nearest = pos;
        }
        return nearest;
    }

    private void next() {
        class_2338 block = this.findNextBlock();
        if (block == null) {
            this.returnList.clear();
            this.returnList.addAll(this.scanned.values());
            this.callback();
            return;
        }
        this.step = new GoTo(block.method_46558().method_1019(goToOffset), () -> {
            this.step = new PickUpBlock(block, () -> {
                this.step = null;
            });
            this.step.init();
        });
        this.step.init();
    }

    @Override
    public void tick() {
        if (this.blocks == null) {
            return;
        }
        if (this.step != null) {
            this.step.tick();
        } else {
            this.next();
        }
    }

    private class PickUpBlock
    extends Action {
        private final class_2338 pos;
        private Integer ticks;

        public PickUpBlock(class_2338 pos, Callback callback) {
            super(callback);
            this.ticks = 0;
            this.pos = pos;
        }

        @Override
        public void init() {
            boolean sneaky;
            class_634 net = CodeClient.MC.method_1562();
            Utility.makeHolding(class_1799.field_8037);
            class_746 player = CodeClient.MC.field_1724;
            class_636 inter = CodeClient.MC.field_1761;
            boolean bl = sneaky = !player.method_5715();
            if (sneaky) {
                net.method_52787((class_2596)new class_2851(new class_10185(false, false, false, false, false, true, false)));
            }
            inter.method_2896(player, class_1268.field_5808, new class_3965(this.pos.method_46558(), class_2350.field_11036, this.pos, false));
            if (sneaky) {
                net.method_52787((class_2596)new class_2851(CodeClient.MC.field_1724.method_71091()));
            }
        }

        @Override
        public boolean onReceivePacket(class_2596<?> packet) {
            class_634 net = CodeClient.MC.method_1562();
            if (net != null && packet instanceof class_2653) {
                class_2653 slot = (class_2653)packet;
                String data = Utility.templateDataItem(slot.method_11449());
                Template template = Template.parse64(data);
                if (template == null) {
                    return false;
                }
                ScanPlot.this.scanned.put(this.pos, slot.method_11449());
                net.method_52787((class_2596)new class_2873(slot.method_11450(), class_1799.field_8037));
                this.callback();
                return true;
            }
            return super.onReceivePacket(packet);
        }

        @Override
        public void tick() {
            this.ticks = this.ticks + 1;
            if (this.ticks == 10) {
                this.ticks = 0;
                this.init();
            }
        }
    }
}

