/*
 * Decompiled with CFR 0.152.
 */
package dev.dfonline.codeclient.command.impl;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import dev.dfonline.codeclient.ChatType;
import dev.dfonline.codeclient.CodeClient;
import dev.dfonline.codeclient.Utility;
import dev.dfonline.codeclient.command.Command;
import java.math.BigDecimal;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2583;
import net.minecraft.class_5250;
import net.minecraft.class_7157;

public class CommandCalc
extends Command {
    @Override
    public String name() {
        return "calc";
    }

    @Override
    public LiteralArgumentBuilder<FabricClientCommandSource> create(LiteralArgumentBuilder<FabricClientCommandSource> cmd, class_7157 registryAccess) {
        return (LiteralArgumentBuilder)cmd.then(ClientCommandManager.argument((String)"calc", (ArgumentType)StringArgumentType.greedyString()).executes(context -> {
            String expr = (String)context.getArgument("calc", String.class);
            if (CodeClient.MC.method_1562() == null) {
                return -1;
            }
            try {
                String result = String.valueOf(CommandCalc.calc(expr));
                class_5250 message = class_2561.method_43469((String)"codeclient.command.calc.success", (Object[])new Object[]{expr, result}).method_27696(class_2583.field_24360.method_10949((class_2568)new class_2568.class_10613((class_2561)class_2561.method_43471((String)"codeclient.hover.click_to_copy"))).method_10958((class_2558)new class_2558.class_10606(result)));
                Utility.sendMessage((class_2561)message, ChatType.SUCCESS);
            }
            catch (Exception e) {
                Utility.sendMessage((class_2561)class_2561.method_43469((String)"codeclient.command.calc.failure", (Object[])new Object[]{expr}), ChatType.FAIL);
            }
            return 0;
        }));
    }

    public static double calc(String exp) throws Exception {
        String result = exp.toLowerCase();
        if (result.contains("(")) {
            int open = -1;
            for (int pos = 0; pos < result.length(); ++pos) {
                if (result.charAt(pos) == '(') {
                    open = pos;
                    continue;
                }
                if (result.charAt(pos) != ')') continue;
                if (open != -1) {
                    int close = pos;
                    String pre = result.substring(0, open);
                    String res = String.valueOf(CommandCalc.calcPart(result.substring(open + 1, close)));
                    String post = result.substring(close + 1);
                    return CommandCalc.calc(pre + res + post);
                }
                throw new Exception("Invalid Brackets");
            }
            throw new Exception("Invalid Brackets");
        }
        return CommandCalc.calcPart(result);
    }

    public static double calcPart(String exp) {
        String texp = exp.replaceAll(" ", "");
        String old = null;
        while (!Objects.equals(old, texp)) {
            double num2;
            double num1;
            old = texp;
            Matcher powm = Pattern.compile("(?<n1>-?(\\.\\d+|\\d+\\.\\d+|\\d+))\\^(?<n2>-?(\\.\\d+|\\d+\\.\\d+|\\d+))").matcher(texp);
            Matcher mulm = Pattern.compile("(?<n1>-?(\\.\\d+|\\d+\\.\\d+|\\d+))(?<e>\\*|\\/|%)(?<n2>-?(\\.\\d+|\\d+\\.\\d+|\\d+))").matcher(texp);
            Matcher addm = Pattern.compile("(?<n1>-?(\\.\\d+|\\d+\\.\\d+|\\d+))(?<e>\\+|\\-)(?<n2>-?(\\.\\d+|\\d+\\.\\d+|\\d+))").matcher(texp);
            if (powm.find()) {
                num1 = Double.parseDouble(powm.group("n1"));
                num2 = Double.parseDouble(powm.group("n2"));
                texp = powm.replaceFirst(BigDecimal.valueOf(Math.pow(num1, num2)).toPlainString());
                continue;
            }
            if (mulm.find()) {
                num1 = Double.parseDouble(mulm.group("n1"));
                num2 = Double.parseDouble(mulm.group("n2"));
                if (Objects.equals(mulm.group("e"), "*")) {
                    texp = mulm.replaceFirst(new BigDecimal(num1 * num2).toPlainString());
                    continue;
                }
                if (Objects.equals(mulm.group("e"), "%")) {
                    texp = mulm.replaceFirst(new BigDecimal(num1 % num2).toPlainString());
                    continue;
                }
                texp = mulm.replaceFirst(new BigDecimal(num1 / num2).toPlainString());
                continue;
            }
            if (!addm.find()) continue;
            num1 = Double.parseDouble(addm.group("n1"));
            num2 = Double.parseDouble(addm.group("n2"));
            if (Objects.equals(addm.group("e"), "+")) {
                texp = addm.replaceFirst(new BigDecimal(num1 + num2).toPlainString());
                continue;
            }
            texp = addm.replaceFirst(new BigDecimal(num1 - num2).toPlainString());
        }
        return Double.parseDouble(texp);
    }
}

