/*
 * Decompiled with CFR 0.152.
 */
package dev.dfonline.codeclient.command.impl;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import dev.dfonline.codeclient.ChatType;
import dev.dfonline.codeclient.CodeClient;
import dev.dfonline.codeclient.FileManager;
import dev.dfonline.codeclient.Utility;
import dev.dfonline.codeclient.action.impl.ScanPlot;
import dev.dfonline.codeclient.command.TemplateActionCommand;
import dev.dfonline.codeclient.hypercube.template.Template;
import dev.dfonline.codeclient.hypercube.template.TemplateBlock;
import dev.dfonline.codeclient.location.Dev;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Objects;
import java.util.stream.Stream;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2583;
import net.minecraft.class_7157;
import org.apache.commons.lang3.SystemUtils;

public class CommandScanPlot
extends TemplateActionCommand {
    @Override
    public String name() {
        return "scanplot";
    }

    @Override
    public LiteralArgumentBuilder<FabricClientCommandSource> create(LiteralArgumentBuilder<FabricClientCommandSource> cmd, class_7157 registryAccess) {
        return (LiteralArgumentBuilder)cmd.then(ClientCommandManager.argument((String)"folder", (ArgumentType)StringArgumentType.greedyString()).suggests((x$0, x$1) -> this.suggestDirectories((CommandContext<FabricClientCommandSource>)x$0, x$1)).executes(context -> {
            if (CodeClient.location instanceof Dev) {
                String arg = (String)context.getArgument("folder", String.class);
                String[] path = arg.split("/");
                Path currentPath = FileManager.templatesPath();
                for (String dir : path) {
                    if (Files.notExists(currentPath = currentPath.resolve(dir), new LinkOption[0])) {
                        try {
                            Files.createDirectory(currentPath, new FileAttribute[0]);
                        }
                        catch (Exception ignored) {
                            Utility.sendMessage((class_2561)class_2561.method_43469((String)"codeclient.files.error.write_folder", (Object[])new Object[]{currentPath}));
                        }
                        continue;
                    }
                    if (Files.isDirectory(currentPath, new LinkOption[0])) continue;
                    Utility.sendMessage((class_2561)class_2561.method_43469((String)"codeclient.files.error.not_dir", (Object[])new Object[]{currentPath}), ChatType.FAIL);
                    return -1;
                }
                boolean invalid = false;
                try {
                    Stream<Path> list = Files.list(currentPath);
                    for (Path file : list.toList()) {
                        invalid = true;
                        if (!file.getFileName().toString().equals(".git")) continue;
                        Utility.sendMessage((class_2561)class_2561.method_43473().method_10852((class_2561)class_2561.method_43471((String)"codeclient.files.git")).method_10852((class_2561)class_2561.method_43470((String)"\n")).method_10852((class_2561)class_2561.method_43471((String)"codeclient.files.open_native").method_27696(class_2583.field_24360.method_10977(class_124.field_1075).method_10958((class_2558)new class_2558.class_10607(currentPath.toAbsolutePath().toString())).method_10949((class_2568)new class_2568.class_10613((class_2561)class_2561.method_43470((String)currentPath.toAbsolutePath().toString()))))), ChatType.INFO);
                        invalid = false;
                        break;
                    }
                    list.close();
                }
                catch (Exception ignored) {
                    Utility.sendMessage((class_2561)class_2561.method_43471((String)"codeclient.files.error.read_folder"), ChatType.FAIL);
                }
                if (invalid) {
                    Utility.sendMessage((class_2561)class_2561.method_43471((String)"codeclient.files.empty_dir"));
                    return -1;
                }
                Utility.sendMessage((class_2561)class_2561.method_43471((String)"codeclient.action.scanning").method_27693(" ").method_10852((class_2561)class_2561.method_43471((String)"codeclient.action.abort")), ChatType.INFO);
                ArrayList<class_1799> scan = new ArrayList<class_1799>();
                Path finalCurrentPath = currentPath;
                CodeClient.currentAction = new ScanPlot(() -> {
                    this.actionCallback();
                    for (class_1799 item : scan) {
                        String data = Utility.templateDataItem(item);
                        Template template = Template.parse64(data);
                        if (template == null) continue;
                        TemplateBlock first = template.blocks.get(0);
                        String name = Objects.requireNonNullElse(first.action != null ? first.action : first.data, "unknown").replaceAll(SystemUtils.IS_OS_WINDOWS ? "[<>:\"/|?*]" : "/", "");
                        Path filePath = finalCurrentPath.resolve(name + ".dft");
                        try {
                            Files.write(filePath, Base64.getDecoder().decode(data), new OpenOption[0]);
                        }
                        catch (Exception ignored) {
                            Utility.sendMessage((class_2561)class_2561.method_43469((String)"codeclient.files.error.write_file", (Object[])new Object[]{filePath.toString()}), ChatType.FAIL);
                        }
                    }
                }, scan);
                CodeClient.currentAction.init();
                return 0;
            }
            Utility.sendMessage((class_2561)class_2561.method_43471((String)"codeclient.warning.dev_mode"), ChatType.FAIL);
            return 1;
        }));
    }
}

