/*
 * Decompiled with CFR 0.152.
 */
package dev.dfonline.codeclient.command.impl;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import dev.dfonline.codeclient.ChatType;
import dev.dfonline.codeclient.CodeClient;
import dev.dfonline.codeclient.Utility;
import dev.dfonline.codeclient.command.Command;
import dev.dfonline.codeclient.command.impl.CommandJump;
import dev.dfonline.codeclient.location.Dev;
import dev.dfonline.codeclient.location.Location;
import java.util.HashMap;
import java.util.regex.Pattern;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_124;
import net.minecraft.class_2338;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2583;
import net.minecraft.class_5250;
import net.minecraft.class_7157;
import net.minecraft.class_8242;

public class CommandSearch
extends Command {
    @Override
    public String name() {
        return "ccsearch";
    }

    @Override
    public void register(CommandDispatcher<FabricClientCommandSource> dispatcher, class_7157 registryAccess) {
        super.register(dispatcher, registryAccess);
        dispatcher.register(this.create((LiteralArgumentBuilder<FabricClientCommandSource>)ClientCommandManager.literal((String)"search"), registryAccess));
    }

    @Override
    public LiteralArgumentBuilder<FabricClientCommandSource> create(LiteralArgumentBuilder<FabricClientCommandSource> cmd, class_7157 registryAccess) {
        return (LiteralArgumentBuilder)cmd.then(ClientCommandManager.argument((String)"query", (ArgumentType)StringArgumentType.greedyString()).suggests((context, builder) -> CommandJump.suggestJump(CommandJump.JumpType.ACTIONS, (CommandContext<FabricClientCommandSource>)context, builder, false)).executes(context -> {
            Location patt0$temp = CodeClient.location;
            if (patt0$temp instanceof Dev) {
                Dev dev = (Dev)patt0$temp;
                String query = (String)context.getArgument("query", String.class);
                HashMap<class_2338, class_8242> results = dev.scanForSigns(CommandJump.JumpType.ACTIONS.pattern, Pattern.compile("^.*" + Pattern.quote(query) + ".*$", 2));
                if (results == null || results.isEmpty()) {
                    Utility.sendMessage((class_2561)class_2561.method_43471((String)"codeclient.search.no_results"), ChatType.INFO);
                    return 0;
                }
                class_5250 message = class_2561.method_43471((String)"codeclient.search.results");
                results.forEach((pos, text) -> {
                    String type = text.method_49859(0, false).getString();
                    String name = text.method_49859(1, false).getString().trim();
                    class_5250 highlightAction = class_2561.method_43473().method_27693(" [\u23fc]").method_10862(class_2583.field_24360.method_36139(0xFF7FAA).method_10958((class_2558)new class_2558.class_10609(String.format("/highlight %s %s %s", pos.method_10263(), pos.method_10264(), pos.method_10260()))).method_10949((class_2568)new class_2568.class_10613((class_2561)class_2561.method_43469((String)"codeclient.search.hover.highlight", (Object[])new Object[]{pos.method_10263(), pos.method_10264(), pos.method_10260()}))));
                    class_2583 actionStyle = CommandSearch.getActionColor(type);
                    class_5250 entry = class_2561.method_43473().method_27693("\n \u23f9 ").method_10862(actionStyle.method_10949((class_2568)new class_2568.class_10613((class_2561)class_2561.method_43473().method_27693(type).method_10862(actionStyle)))).method_10852((class_2561)class_2561.method_43473().method_27693(name).method_10862(class_2583.field_24360.method_10958((class_2558)new class_2558.class_10609(String.format("/ptp %s %s %s", pos.method_10263(), pos.method_10264(), pos.method_10260()))).method_10949((class_2568)new class_2568.class_10613((class_2561)class_2561.method_43469((String)"codeclient.search.hover.teleport", (Object[])new Object[]{pos.method_10263(), pos.method_10264(), pos.method_10260()}))))).method_10852((class_2561)highlightAction);
                    message.method_10852((class_2561)entry);
                });
                Utility.sendMessage((class_2561)message, ChatType.SUCCESS);
            } else {
                Utility.sendMessage((class_2561)class_2561.method_43471((String)"codeclient.warning.dev_mode"), ChatType.FAIL);
            }
            return 0;
        }));
    }

    private static class_2583 getActionColor(String type) {
        return switch (type) {
            case "CONTROL" -> class_2583.field_24360.method_10977(class_124.field_1074);
            case "SELECT OBJECT" -> class_2583.field_24360.method_10977(class_124.field_1076);
            case "REPEAT" -> class_2583.field_24360.method_10977(class_124.field_1062);
            case "SET VARIABLE" -> class_2583.field_24360.method_10977(class_124.field_1068);
            case "GAME ACTION" -> class_2583.field_24360.method_10977(class_124.field_1061);
            case "IF GAME" -> class_2583.field_24360.method_10977(class_124.field_1079);
            case "ENTITY ACTION" -> class_2583.field_24360.method_10977(class_124.field_1077);
            case "PLAYER ACTION" -> class_2583.field_24360.method_10977(class_124.field_1080);
            case "IF PLAYER" -> class_2583.field_24360.method_10977(class_124.field_1065);
            case "CALL FUNCTION" -> class_2583.field_24360.method_10977(class_124.field_1078);
            case "START PROCESS" -> class_2583.field_24360.method_10977(class_124.field_1060);
            case "IF ENTITY" -> class_2583.field_24360.method_36139(16754779);
            default -> class_2583.field_24360.method_10977(class_124.field_1063);
        };
    }
}

