/*
 * Decompiled with CFR 0.152.
 */
package dev.dfonline.codeclient.dev.highlighter;

import dev.dfonline.codeclient.CodeClient;
import dev.dfonline.codeclient.Feature;
import dev.dfonline.codeclient.Utility;
import dev.dfonline.codeclient.config.Config;
import dev.dfonline.codeclient.dev.highlighter.MiniMessageHighlighter;
import dev.dfonline.codeclient.hypercube.HypercubeCommands;
import dev.dfonline.codeclient.hypercube.HypercubeMiniMessage;
import dev.dfonline.codeclient.hypercube.item.VarItem;
import dev.dfonline.codeclient.hypercube.item.VarItems;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_5224;
import net.minecraft.class_5251;
import net.minecraft.class_5481;
import net.minecraft.class_746;
import org.apache.commons.lang3.IntegerRange;
import org.jetbrains.annotations.Nullable;

public class ExpressionHighlighter
extends Feature {
    private final Set<String> CODES = Set.of("default", "selected", "uuid", "var", "math", "damager", "killer", "shooter", "victim", "projectile", "random", "round", "index", "entry");
    private final List<class_5251> COLORS = List.of(class_5251.method_27717((int)16765994), class_5251.method_27717((int)0x33FF00), class_5251.method_27717((int)65504), class_5251.method_27717((int)6191095), class_5251.method_27717((int)13264122), class_5251.method_27717((int)0xFF4242));
    private final class_5251 ERROR_COLOR = class_5251.method_27718((class_124)class_124.field_1061);
    private String cachedInput = "";
    private int cachedPosition = 0;
    private HighlightedExpression cachedHighlight = new HighlightedExpression(class_5481.method_34905(), null);
    private final MiniMessage formatter = HypercubeMiniMessage.MM;
    private final MiniMessageHighlighter highlighter = new MiniMessageHighlighter();

    @Override
    public boolean enabled() {
        return Config.getConfig().HighlighterEnabled;
    }

    public HighlightedExpression format(String input, String partial, IntegerRange range) {
        if (Objects.equals(input, this.cachedInput) && this.cachedPosition == (Integer)range.getMinimum()) {
            return this.cachedHighlight;
        }
        this.cachedPosition = (Integer)range.getMinimum();
        this.cachedInput = input;
        if (input.startsWith("/")) {
            for (CommandType command : CommandType.values()) {
                Matcher matcher = command.regex.matcher(input);
                if (!matcher.find(1) || matcher.start() > 1) continue;
                this.cachedHighlight = this.formatCommand(input, command, matcher.end(), range);
                return this.cachedHighlight;
            }
            this.cachedHighlight = null;
            return null;
        }
        class_746 player = CodeClient.MC.field_1724;
        if (player == null) {
            return null;
        }
        class_1799 item = player.method_6047();
        try {
            Object text;
            VarItem varItem = VarItems.parse(item);
            boolean showPreview = false;
            switch (varItem.getId()) {
                case "num": 
                case "var": 
                case "txt": {
                    if (Config.getConfig().HighlightExpressions) {
                        text = this.highlightExpressions(input, true);
                        break;
                    }
                    text = Component.text((String)input);
                    break;
                }
                case "comp": {
                    text = Config.getConfig().HighlightMiniMessage ? this.highlighter.highlight(input) : Component.text((String)input);
                    showPreview = true;
                    if (!Config.getConfig().HighlightExpressions) break;
                    text = this.highlightExpressions((Component)text);
                    break;
                }
                default: {
                    this.cachedHighlight = null;
                    return null;
                }
            }
            TextComponent preview = Component.empty();
            if (showPreview) {
                preview = this.formatter.deserialize((Object)input);
            }
            this.cachedHighlight = new HighlightedExpression(this.subSequence(Utility.componentToOrderedText((Component)text), range), Utility.componentToOrderedText((Component)preview));
            return this.cachedHighlight;
        }
        catch (Exception ignored) {
            this.cachedHighlight = null;
            return null;
        }
    }

    private HighlightedExpression formatCommand(String input, CommandType command, int index, IntegerRange range) {
        Object highlighted;
        Matcher matcher;
        Pattern pattern;
        int start = index;
        int end = input.length();
        if (start > end) {
            return null;
        }
        if (command.argumentIndex > 0) {
            pattern = Pattern.compile("^(\\S*\\s+){" + command.argumentIndex + "}");
            matcher = pattern.matcher(input);
            if (matcher.find(start)) {
                start = matcher.end();
            }
            if (start > end) {
                return null;
            }
        }
        if (command.hasCount && (matcher = (pattern = Pattern.compile("\\s\\d+$")).matcher(input)).find(start)) {
            end = matcher.start();
        }
        if (command.parseMinimessage) {
            highlighted = Config.getConfig().HighlightMiniMessage ? this.highlighter.highlight(input.substring(start, end)) : Component.text((String)input.substring(start, end));
            if (Config.getConfig().HighlightExpressions) {
                highlighted = this.highlightExpressions((Component)highlighted);
            }
        } else {
            highlighted = Config.getConfig().HighlightExpressions ? this.highlightExpressions(input.substring(start, end), true) : Component.text((String)input.substring(start, end));
        }
        Component combined = ((TextComponent)Component.text((String)input.substring(0, start)).color((TextColor)NamedTextColor.GRAY)).append((Component)highlighted);
        if (end < input.length()) {
            combined = combined.append(Component.text((String)input.substring(end)).color((TextColor)NamedTextColor.LIGHT_PURPLE));
        }
        TextComponent formatted = Component.empty();
        if (command.parseMinimessage) {
            formatted = this.formatter.deserialize((Object)input.substring(start, end));
        }
        return new HighlightedExpression(this.subSequence(Utility.componentToOrderedText(combined), range), Utility.componentToOrderedText((Component)formatted));
    }

    private Component highlightExpressions(Component component) {
        String raw = (String)this.formatter.serialize(component);
        return this.highlightExpressions(raw, false);
    }

    private Component highlightExpressions(String input, boolean escapeTags) {
        String raw = escapeTags ? this.formatter.escapeTags(input) : input;
        StringBuilder sb = new StringBuilder(raw.length());
        Pattern pattern = Pattern.compile("(%[a-zA-Z]+\\(?)|\\)|$");
        Matcher matcher = pattern.matcher(raw);
        int depth = 0;
        int start = 0;
        boolean invalid = false;
        while (matcher.find()) {
            String value = matcher.group();
            if (Objects.equals(value, ")")) {
                if (start != matcher.start()) {
                    String prev = raw.substring(start, matcher.start());
                    sb.append(prev);
                }
                if (depth <= 0) {
                    sb.append(value);
                    start = matcher.end();
                    continue;
                }
                color = this.getColor(depth);
                --depth;
                if (!invalid) {
                    style = color.method_27723();
                    sb.append(String.format("</color:%s>", style));
                    style = this.getColor(depth).method_27723();
                } else {
                    style = this.ERROR_COLOR.method_27723();
                    sb.append(String.format("</color:%s>", style));
                }
                sb.append(value);
                --depth;
                sb.append(String.format("</color:%s>", style));
            } else {
                color = this.getColor(++depth);
                if (value.length() > 1 && !this.CODES.contains(value.replace("%", "").replace("(", "")) && depth <= 1 || invalid) {
                    color = this.ERROR_COLOR;
                    invalid = true;
                }
                if (start != matcher.start()) {
                    String prev = raw.substring(start, matcher.start());
                    sb.append(prev);
                }
                style = color.method_27723();
                sb.append(String.format("<color:%s>", style));
                sb.append(value);
                if (value.endsWith("(")) {
                    ++depth;
                    if (!invalid) {
                        style = this.getColor(depth).method_27723();
                    }
                    sb.append(String.format("<color:%s>", style));
                } else if (depth > 0) {
                    --depth;
                    sb.append(String.format("</color:%s>", style));
                }
            }
            start = matcher.end();
        }
        return this.formatter.deserialize((Object)sb.toString());
    }

    private class_5251 getColor(int depth) {
        if (depth < 1) {
            return this.getColor(this.COLORS.size() - depth);
        }
        try {
            return this.COLORS.get(depth - 1);
        }
        catch (Exception e) {
            return this.getColor(depth - this.COLORS.size());
        }
    }

    private class_5481 subSequence(class_5481 original, int start, int end) {
        return visitor -> this.acceptWithAbsoluteIndex(original, (index, style, codePoint) -> {
            if (index >= start && index < end) {
                return visitor.accept(index - start, style, codePoint);
            }
            return true;
        });
    }

    private class_5481 subSequence(class_5481 original, IntegerRange range) {
        int start = (Integer)range.getMinimum();
        int end = (Integer)range.getMaximum();
        return this.subSequence(original, start, end);
    }

    public boolean acceptWithAbsoluteIndex(class_5481 original, class_5224 visitor) {
        AtomicInteger index = new AtomicInteger();
        return original.accept((ignored, style, codePoint) -> {
            boolean shouldContinue = visitor.accept(index.getAndIncrement(), style, codePoint);
            if (Character.isHighSurrogate(Character.toString(codePoint).charAt(0))) {
                index.getAndIncrement();
            }
            return shouldContinue;
        });
    }

    public void draw(class_332 context, int mouseX, int mouseY, class_5481 input) {
        class_327 renderer = CodeClient.MC.field_1772;
        class_437 screen = CodeClient.MC.field_1755;
        if (screen == null) {
            return;
        }
        int y = screen.field_22790 - 25;
        context.method_35720(renderer, input, 4, y, 0xFFFFFF);
    }

    public record HighlightedExpression(class_5481 text, @Nullable class_5481 preview) {
    }

    private static enum CommandType {
        NUMBER(HypercubeCommands.NUMBER, true, false),
        STRING(HypercubeCommands.STRING, true, false),
        TEXT(HypercubeCommands.TEXT, true),
        VARIABLE(HypercubeCommands.VARIABLE, true, false),
        ITEM_NAME(HypercubeCommands.ITEM_NAME),
        ITEM_LORE_ADD(HypercubeCommands.ITEM_LORE_ADD),
        ITEM_LORE_SET(HypercubeCommands.ITEM_LORE_SET, 1),
        ITEM_LORE_INSERT(HypercubeCommands.ITEM_LORE_INSERT, 1),
        PLOT_NAME(HypercubeCommands.PLOT_NAME),
        RELORE(HypercubeCommands.RELORE);

        final Pattern regex;
        final int argumentIndex;
        final boolean hasCount;
        final boolean parseMinimessage;

        private CommandType(Pattern regex) {
            this(regex, 0);
        }

        private CommandType(Pattern regex, int argumentIndex) {
            this(regex, argumentIndex, false, true);
        }

        private CommandType(Pattern regex, boolean hasCount) {
            this(regex, 0, hasCount, true);
        }

        private CommandType(Pattern regex, boolean hasCount, boolean parseMinimessage) {
            this(regex, 0, hasCount, parseMinimessage);
        }

        private CommandType(Pattern regex, int argumentIndex, boolean hasCount, boolean parseMinimessage) {
            this.regex = regex;
            this.argumentIndex = argumentIndex;
            this.hasCount = hasCount;
            this.parseMinimessage = parseMinimessage;
        }
    }
}

