/*
 * Decompiled with CFR 0.152.
 */
package dev.dfonline.codeclient.dev.menu;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import dev.dfonline.codeclient.ChestFeature;
import dev.dfonline.codeclient.CodeClient;
import dev.dfonline.codeclient.Feature;
import dev.dfonline.codeclient.FileManager;
import dev.dfonline.codeclient.config.Config;
import dev.dfonline.codeclient.data.DFItem;
import dev.dfonline.codeclient.location.Dev;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientLifecycleEvents;
import net.minecraft.class_10799;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_155;
import net.minecraft.class_1657;
import net.minecraft.class_1713;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2522;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_4284;
import net.minecraft.class_465;
import net.minecraft.class_5819;

public class RecentValues
extends Feature {
    private final Path file = FileManager.recentValuesPath();
    private final List<class_1799> pinned = new ArrayList<class_1799>();
    private final List<class_1799> recent = new ArrayList<class_1799>();
    private class_1799 hoveredItem = null;
    private List<class_1799> hoveredOrigin = null;

    @Override
    public boolean enabled() {
        return Config.getConfig().RecentValues > 0;
    }

    public RecentValues() {
        try {
            if (Files.exists(this.file, new LinkOption[0])) {
                JsonObject data = JsonParser.parseString((String)Files.readString(this.file)).getAsJsonObject();
                int version = data.get("version").getAsInt();
                JsonArray pinnedJson = data.getAsJsonArray("pinned");
                JsonArray recentJson = data.getAsJsonArray("recent");
                for (JsonElement item : pinnedJson) {
                    this.pinned.add(this.readItem(version, item));
                }
                for (JsonElement item : recentJson) {
                    this.recent.add(this.readItem(version, item));
                }
            }
            ClientLifecycleEvents.CLIENT_STOPPING.register(mc -> {
                try {
                    if (!Files.exists(this.file.getParent(), new LinkOption[0])) {
                        Files.createDirectories(this.file.getParent(), new FileAttribute[0]);
                    }
                    JsonObject data = new JsonObject();
                    data.addProperty("version", (Number)class_155.method_16673().comp_4026().comp_4038());
                    data.add("pinned", (JsonElement)this.saveItems(this.pinned));
                    data.add("recent", (JsonElement)this.saveItems(this.recent));
                    Files.writeString(this.file, (CharSequence)data.toString(), new OpenOption[0]);
                }
                catch (Exception err) {
                    CodeClient.LOGGER.error("Failed to save recent_values.json!");
                    err.printStackTrace();
                }
            });
        }
        catch (Exception err) {
            CodeClient.LOGGER.error("Failed reading recent_values.json!", (Throwable)err);
        }
    }

    private JsonArray saveItems(List<class_1799> list) {
        JsonArray out = new JsonArray();
        if (CodeClient.MC.field_1687 == null) {
            throw new RuntimeException("World is null!");
        }
        for (class_1799 item : list) {
            out.add(((class_2520)class_1799.field_24671.encodeStart((DynamicOps)CodeClient.MC.field_1724.method_56673().method_57093((DynamicOps)class_2509.field_11560), (Object)item).getOrThrow()).toString());
        }
        return out;
    }

    private class_1799 readItem(int version, JsonElement item) throws Exception {
        if (CodeClient.MC.field_1687 == null) {
            return null;
        }
        DataResult fromNbt = class_1799.field_24671.decode((DynamicOps)CodeClient.MC.field_1724.method_56673().method_57093((DynamicOps)class_2509.field_11560), (Object)class_4284.field_19215.method_48130(CodeClient.MC.method_1543(), class_2522.method_67315((String)item.getAsString()), version));
        return fromNbt.result().map(Pair::getFirst).orElse(null);
    }

    public void remember(class_1799 item) {
        if (CodeClient.MC.field_1687 == null) {
            return;
        }
        DFItem dfItem = DFItem.of(item);
        if (!(CodeClient.location instanceof Dev) || dfItem.getHypercubeStringValue("varitem").isEmpty()) {
            return;
        }
        for (class_1799 it2 : this.pinned) {
            if (it2 == null || item.method_7909() != it2.method_7909() || !item.equals(it2)) continue;
            return;
        }
        class_1799 lambdaItem = item;
        if (item.method_7909() == null) {
            this.recent.remove(item);
            return;
        }
        this.recent.removeIf(it -> it != null && lambdaItem.method_7909() == it.method_7909() && ((class_2520)class_1799.field_24671.encodeStart((DynamicOps)CodeClient.MC.field_1724.method_56673().method_57093((DynamicOps)class_2509.field_11560), (Object)lambdaItem).getOrThrow()).equals(class_1799.field_24671.encodeStart((DynamicOps)CodeClient.MC.field_1724.method_56673().method_57093((DynamicOps)class_2509.field_11560), it).getOrThrow()));
        item = item.method_46651(1);
        this.recent.add(0, item);
        while (this.recent.size() > Config.getConfig().RecentValues) {
            this.recent.remove(this.recent.size() - 1);
        }
    }

    @Override
    public ChestFeature makeChestFeature(class_465<?> screen) {
        return new RecentValuesOverlay(screen);
    }

    class RecentValuesOverlay
    extends ChestFeature {
        public RecentValuesOverlay(class_465<?> screen) {
            super(screen);
        }

        @Override
        public void render(class_332 context, int mouseX, int mouseY, int screenX, int screenY, float delta) {
            RecentValues.this.hoveredItem = null;
            if (RecentValues.this.recent.isEmpty() && RecentValues.this.pinned.isEmpty()) {
                return;
            }
            int xEnd = 320;
            context.method_52706(class_10799.field_56883, class_2960.method_60656((String)"recipe_book/overlay_recipe"), -screenX + 6, -5, Math.min(Math.max(RecentValues.this.pinned.size(), RecentValues.this.recent.size()), 16) * 20 + 10, ((int)Math.ceil((double)RecentValues.this.pinned.size() / 16.0) + (int)Math.ceil((double)RecentValues.this.recent.size() / 16.0)) * 16 + 10);
            RecentValues.this.hoveredItem = null;
            RecentValues.this.hoveredOrigin = null;
            int y = screenY;
            for (List<class_1799> group : List.of(RecentValues.this.pinned, RecentValues.this.recent)) {
                int x = 13;
                for (class_1799 item : group) {
                    if (item == null) continue;
                    context.method_51427(item, x - screenX, y - screenY);
                    context.method_51431(CodeClient.MC.field_1772, item, x - screenX, y - screenY);
                    if (mouseX > x && mouseY > y && mouseX < x + 15 && mouseY < y + 15) {
                        context.method_51446(CodeClient.MC.field_1772, item, mouseX, mouseY);
                        RecentValues.this.hoveredItem = item;
                        RecentValues.this.hoveredOrigin = group;
                    }
                    if ((x += 20) <= xEnd) continue;
                    x = 13;
                    y += 15;
                }
                if (x == 13) continue;
                y += 15;
            }
        }

        @Override
        public boolean mouseClicked(double mouseX, double mouseY, int button) {
            if (RecentValues.this.hoveredItem == null) {
                return false;
            }
            if (button != 1) {
                for (class_1735 slot : this.screen.method_17577().field_7761) {
                    if (slot.method_7681()) continue;
                    CodeClient.MC.method_1483().method_4873((class_1113)new class_1109(class_3417.field_15197, class_3419.field_15248, 2.0f, 1.0f, class_5819.method_43047(), CodeClient.MC.field_1724.method_24515()));
                    if (!CodeClient.MC.field_1724.method_68878()) {
                        return false;
                    }
                    class_1799 previous = CodeClient.MC.field_1724.method_31548().method_5438(0);
                    CodeClient.MC.field_1761.method_2909(RecentValues.this.hoveredItem, 36);
                    CodeClient.MC.field_1761.method_2906(this.screen.method_17577().field_7763, slot.field_7874, 0, class_1713.field_7791, (class_1657)CodeClient.MC.field_1724);
                    CodeClient.MC.field_1761.method_2909(previous, 36);
                    return true;
                }
            } else {
                RecentValues.this.hoveredOrigin.remove(RecentValues.this.hoveredItem);
                if (RecentValues.this.hoveredOrigin == RecentValues.this.pinned) {
                    CodeClient.MC.method_1483().method_4873((class_1113)new class_1109((class_3414)class_3417.field_15015.comp_349(), class_3419.field_15248, 2.0f, 0.5f, class_5819.method_43047(), CodeClient.MC.field_1724.method_24515()));
                    return true;
                }
                CodeClient.MC.method_1483().method_4873((class_1113)new class_1109((class_3414)class_3417.field_15015.comp_349(), class_3419.field_15248, 2.0f, 0.6f, class_5819.method_43047(), CodeClient.MC.field_1724.method_24515()));
                RecentValues.this.pinned.add(RecentValues.this.hoveredItem);
                return true;
            }
            return false;
        }
    }
}

