/*
 * Decompiled with CFR 0.152.
 */
package dev.dfonline.codeclient.hypercube;

import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.minimessage.tag.Tag;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.kyori.adventure.text.minimessage.tag.standard.StandardTags;

public class HypercubeMiniMessage {
    public static final MiniMessage MM = MiniMessage.builder().tags(Tags.ALL).build();
    public static final TagResolver SPACE_TAG = Tags.SPACE;
    public static final TagResolver NEWLINE_TAG = Tags.NEWLINE;

    private static class Tags {
        private static final int MAX_REPETITION_COUNT = 32;
        private static final TagResolver STANDARD = StandardTags.defaults();
        static final TagResolver SPACE = Tags.repetitionTagResolver("space", " ");
        static final TagResolver NEWLINE = Tags.repetitionTagResolver("newline", "\n");
        static final TagResolver ALL = TagResolver.resolver((TagResolver[])new TagResolver[]{STANDARD, SPACE, NEWLINE});

        private Tags() {
        }

        private static TagResolver repetitionTagResolver(String name, String literal) {
            return TagResolver.resolver((String)name, (arguments, context) -> {
                int count = arguments.hasNext() ? arguments.pop().asInt().orElseThrow(() -> {
                    context.newException("Count must be a number");
                    return null;
                }) : 1;
                String repeated = literal.repeat(Math.min(count, 32));
                return Tag.selfClosingInserting((Component)Component.text((String)repeated));
            });
        }
    }
}

