/*
 * Decompiled with CFR 0.152.
 */
package dev.dfonline.codeclient.hypercube.actiondump;

import com.ibm.icu.text.CaseMap;
import dev.dfonline.codeclient.Utility;
import dev.dfonline.codeclient.data.DFItem;
import dev.dfonline.codeclient.hypercube.actiondump.Icon;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2561;
import net.minecraft.class_5250;
import net.minecraft.class_5251;
import org.jetbrains.annotations.Nullable;

public class Argument {
    public String type;
    public boolean plural;
    public boolean optional;
    public String[] description;
    public String[][] notes;
    public String text;

    @Nullable
    public Icon.Type getType() {
        try {
            return Icon.Type.valueOf(this.type);
        }
        catch (Exception ignored) {
            return null;
        }
    }

    public class_1799 getItem() {
        Icon.Type type = this.getType();
        class_1799 item = type == null ? class_1802.field_8298.method_7854() : type.getIcon();
        DFItem dfItem = DFItem.of(item);
        List<class_2561> lore = this.getLore();
        if (lore.isEmpty()) {
            return item;
        }
        dfItem.setName(lore.getFirst());
        lore.removeFirst();
        dfItem.setLore(lore);
        return item;
    }

    public List<class_2561> getLore() {
        ArrayList<class_2561> lore = new ArrayList<class_2561>();
        int i = 0;
        if (this.text != null) {
            this.addToLore(lore, this.text);
        }
        if (this.description != null) {
            for (String string : this.description) {
                class_5250 typeText;
                class_5250 text = class_2561.method_43473().method_27692(class_124.field_1080).method_27694(s -> s.method_10978(Boolean.valueOf(false)));
                try {
                    Icon.Type type = Icon.Type.valueOf(this.type);
                    typeText = class_2561.method_43470((String)type.display).method_10862(class_2561.method_43473().method_10866().method_27703(type.color).method_10978(Boolean.valueOf(false)));
                }
                catch (IllegalArgumentException e) {
                    String properCase = CaseMap.Title.toTitle().apply(Locale.ENGLISH, null, (CharSequence)this.type.replaceAll("_", " "));
                    typeText = class_2561.method_43470((String)properCase).method_10862(class_2561.method_43473().method_10866().method_27703(class_5251.method_27717((int)0x808080)).method_10978(Boolean.valueOf(false)));
                }
                if (i == 0) {
                    if (this.plural) {
                        typeText.method_27693("(s)");
                    }
                    text.method_10852((class_2561)typeText);
                    if (this.optional) {
                        text.method_10852((class_2561)class_2561.method_43470((String)"*").method_27692(class_124.field_1068));
                    }
                    text.method_10852((class_2561)class_2561.method_43470((String)" - ").method_27692(class_124.field_1063));
                    text.method_10852((class_2561)Utility.textFromString(string).method_27692(class_124.field_1080));
                    lore.add((class_2561)text);
                } else {
                    lore.add((class_2561)Utility.textFromString(string).method_27692(class_124.field_1080));
                }
                ++i;
            }
        }
        if (this.notes != null) {
            for (String string : this.notes) {
                i = 0;
                if (string == null) continue;
                for (String line : string) {
                    if (i == 0) {
                        this.addToLore(lore, "\u00a79\u23f5 \u00a77" + line);
                    } else {
                        this.addToLore(lore, "\u00a77" + line);
                    }
                    ++i;
                }
            }
        }
        return lore;
    }

    public boolean isOr() {
        return this.text != null && this.text.endsWith("OR");
    }

    public boolean isSplitter() {
        return Objects.equals(this.text, "");
    }

    private void addToLore(ArrayList<class_2561> lore, String text) {
        lore.add((class_2561)Utility.textFromString(text));
    }
}

