/*
 * Decompiled with CFR 0.152.
 */
package dev.dfonline.codeclient.hypercube.actiondump;

import dev.dfonline.codeclient.Utility;
import dev.dfonline.codeclient.data.DFItem;
import dev.dfonline.codeclient.data.ItemData;
import dev.dfonline.codeclient.hypercube.actiondump.Argument;
import dev.dfonline.codeclient.hypercube.item.Component;
import dev.dfonline.codeclient.hypercube.item.Location;
import dev.dfonline.codeclient.hypercube.item.Number;
import dev.dfonline.codeclient.hypercube.item.Potion;
import dev.dfonline.codeclient.hypercube.item.Sound;
import dev.dfonline.codeclient.hypercube.item.Text;
import dev.dfonline.codeclient.hypercube.item.VarItem;
import dev.dfonline.codeclient.hypercube.item.Variable;
import dev.dfonline.codeclient.hypercube.item.Vector;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_156;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_5251;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

public class Icon {
    private static final class_5251 GOLD = class_5251.method_27718((class_124)class_124.field_1065);
    public String material;
    public String head;
    public String name;
    public Color color;
    public String[] deprecatedNote;
    public String[] description;
    public String[] example;
    public String[] worksWith;
    public String[][] additionalInfo;
    public RequiredRank requiredRank;
    public boolean requireTokens;
    public String requireRankAndTokens;
    public boolean advanced;
    public Boolean cancellable;
    public Boolean cancelledAutomatically;
    public String loadedItem;
    public Integer tags;
    public Argument[] arguments;
    public ReturnValue[] returnValues;

    public String getCleanName() {
        return this.name.replaceAll("\u00a7.", "");
    }

    public class_1799 getItem() {
        String line;
        int n;
        class_1799 item = ((class_1792)class_7923.field_41178.method_63535(class_2960.method_60656((String)this.material.toLowerCase()))).method_7854();
        DFItem dfItem = DFItem.of(item);
        ItemData data = dfItem.getItemData();
        ArrayList<class_2561> lore = new ArrayList<class_2561>();
        String[] stringArray = this.description;
        int n2 = stringArray.length;
        for (n = 0; n < n2; ++n) {
            line = stringArray[n];
            this.addToLore(lore, "\u00a77" + line);
        }
        if (this.example != null && this.example.length != 0) {
            this.addToLore(lore, "");
            this.addToLore(lore, "Example:");
            stringArray = this.example;
            n2 = stringArray.length;
            for (n = 0; n < n2; ++n) {
                line = stringArray[n];
                this.addToLore(lore, "\u00a77" + line);
            }
        }
        if (this.arguments != null && this.arguments.length != 0) {
            this.addToLore(lore, "");
            this.addToLore(lore, "Chest Parameters:");
            boolean hasOptional = false;
            Argument[] argumentArray = this.arguments;
            n = argumentArray.length;
            for (int line2 = 0; line2 < n; ++line2) {
                Argument arg = argumentArray[line2];
                lore.addAll(arg.getLore());
            }
            if (this.tags != null && this.tags != 0) {
                lore.add((class_2561)class_2561.method_43470((String)"# ").method_27692(class_124.field_1062).method_27694(s -> s.method_10978(Boolean.valueOf(false))).method_10852((class_2561)class_2561.method_43470((String)(this.tags + " Tag" + (this.tags != 1 ? "s" : ""))).method_27692(class_124.field_1080)));
            }
            if (hasOptional) {
                lore.add((class_2561)class_2561.method_43473());
                lore.add((class_2561)class_2561.method_43470((String)"*Optional").method_27692(class_124.field_1080).method_27694(s -> s.method_10978(Boolean.valueOf(false))));
            }
        }
        if (this.returnValues != null && this.returnValues.length != 0) {
            this.addToLore(lore, "");
            this.addToLore(lore, "Returns Value:");
            ReturnValue[] returnValueArray = this.returnValues;
            int n3 = returnValueArray.length;
            for (n = 0; n < n3; ++n) {
                ReturnValue returnValue = returnValueArray[n];
                if (returnValue.text != null) {
                    this.addToLore(lore, returnValue.text);
                    continue;
                }
                lore.add((class_2561)class_2561.method_43473().method_10852((class_2561)class_2561.method_43470((String)returnValue.type.display).method_10862(class_2583.field_24360.method_27703(returnValue.type.color).method_10978(Boolean.valueOf(false)))).method_10852((class_2561)class_2561.method_43470((String)" - ").method_27692(class_124.field_1063)).method_10852((class_2561)class_2561.method_43470((String)returnValue.description[0]).method_27692(class_124.field_1080).method_27694(s -> s.method_10978(Boolean.valueOf(false)))));
                boolean first = true;
                for (String description : returnValue.description) {
                    if (first) {
                        first = false;
                        continue;
                    }
                    this.addToLore(lore, "\u00a77" + description);
                }
            }
        }
        if (this.additionalInfo != null && this.additionalInfo.length != 0) {
            this.addToLore(lore, "");
            this.addToLore(lore, "\u00a79Additional Info:");
            for (String[] group : this.additionalInfo) {
                int i = 0;
                for (String line3 : group) {
                    if (i == 0) {
                        this.addToLore(lore, "\u00a7b\u00bb \u00a77" + line3);
                    } else {
                        this.addToLore(lore, "\u00a77" + line3);
                    }
                    ++i;
                }
            }
        }
        if (this.cancellable != null && this.cancellable.booleanValue()) {
            this.addToLore(lore, "");
            if (this.cancelledAutomatically.booleanValue()) {
                this.addToLore(lore, "\u00a74\u2205 \u00a7cCancelled automatically");
            } else {
                this.addToLore(lore, "\u00a74\u2205 \u00a7cCancellable");
            }
        }
        if (this.requireTokens) {
            this.addToLore(lore, "");
            lore.add((class_2561)class_2561.method_43470((String)"Unlock with Tokens").method_54663(16765994));
        }
        if (this.requiredRank != null) {
            if (this.requireTokens) {
                lore.add((class_2561)class_2561.method_43470((String)"OR").method_54663(0xFF55AA));
                lore.add((class_2561)class_2561.method_43470((String)("Unlock with " + this.requiredRank.name)).method_54663(this.requiredRank.color.method_27716()));
            } else {
                this.addToLore(lore, "");
                lore.add((class_2561)class_2561.method_43470((String)(this.requiredRank.name + " Exclusive")).method_10862(class_2583.field_24360.method_36139(this.requiredRank.color.method_27716()).method_10978(Boolean.valueOf(false))));
            }
        }
        dfItem.setName((class_2561)Utility.textFromString(this.name));
        dfItem.setLore(lore);
        dfItem.hideFlags();
        if (this.color != null) {
            dfItem.setDyeColor(this.color.getColor());
        }
        if (this.head != null) {
            dfItem.setProfile(class_156.field_25140, this.head, null);
        }
        dfItem.setCustomModelData(5000);
        return item;
    }

    private void addToLore(ArrayList<class_2561> lore, String text) {
        lore.add((class_2561)Utility.textFromString(text));
    }

    public List<ArgumentGroup> getArgGroups() {
        ArrayList<ArgumentGroup> groups = new ArrayList<ArgumentGroup>();
        ArrayList<Argument> group = new ArrayList<Argument>();
        for (Argument arg : this.arguments) {
            if (!arg.isSplitter()) {
                group.add(arg);
                continue;
            }
            groups.add(new ArgumentGroup(group));
            group = new ArrayList();
        }
        groups.add(new ArgumentGroup(group));
        return groups;
    }

    public record ReturnValue(Type type, String[] description, String text) {
    }

    public static enum Type {
        TEXT(class_5251.method_27718((class_124)class_124.field_1075), "String", class_1802.field_8276, Text::new),
        COMPONENT(class_5251.method_27717((int)8377386), "Styled Text", class_1802.field_8529, Component::new),
        NUMBER(class_5251.method_27718((class_124)class_124.field_1061), "Number", class_1802.field_8777, Number::new),
        BYTE(class_5251.method_27718((class_124)class_124.field_1061), "Byte", class_1802.field_8777, Number::new),
        LOCATION(class_5251.method_27718((class_124)class_124.field_1060), "Location", class_1802.field_8407, Location::new),
        VECTOR(class_5251.method_27717((int)0x2AFFAA), "Vector", class_1802.field_8662, Vector::new),
        SOUND(class_5251.method_27718((class_124)class_124.field_1078), "Sound", class_1802.field_8864, Sound::new),
        PARTICLE(class_5251.method_27717((int)0xAA55FF), "Particle Effect", class_1802.field_8446),
        POTION(class_5251.method_27717((int)0xFF557F), "Potion Effect", class_1802.field_8613, Potion::new),
        VARIABLE(class_5251.method_27718((class_124)class_124.field_1054), "Variable", class_1802.field_8135, Variable::new),
        ANY_TYPE(class_5251.method_27717((int)16766079), "Any Value", class_1802.field_8567),
        ITEM(GOLD, "Item", class_1802.field_8143, Text::new),
        BLOCK(GOLD, "Block", class_1802.field_8583, Text::new),
        ENTITY_TYPE(GOLD, "Entity Type", class_1802.field_8493),
        SPAWN_EGG(GOLD, "Spawn Egg", class_1802.field_8346),
        VEHICLE(GOLD, "Vehicle", class_1802.field_8533),
        PROJECTILE(GOLD, "Projectile", class_1802.field_8107),
        BLOCK_TAG(class_5251.method_27718((class_124)class_124.field_1075), "Block Tag", class_1802.field_8799, Text::new),
        LIST(class_5251.method_27718((class_124)class_124.field_1077), "List", class_1802.field_8891),
        DICT(class_5251.method_27717((int)0x55AAFF), "Dictionary", class_1802.field_8361),
        NONE(class_5251.method_27717((int)0x808080), "None", class_1802.field_8162);

        public final class_5251 color;
        public final String display;
        private final class_1799 icon;
        @Nullable
        public final getVarItem getVarItem;

        private Type(class_5251 color, String display, class_1792 icon) {
            class_1799 item;
            this.color = color;
            this.display = display;
            this.icon = item = icon.method_7854();
            this.getVarItem = null;
        }

        private Type(class_5251 color, @Nullable String display, class_1792 icon, getVarItem getVarItem2) {
            this.color = color;
            this.display = display;
            this.icon = icon.method_7854();
            this.getVarItem = getVarItem2;
        }

        public class_1799 getIcon() {
            return this.icon.method_7972();
        }

        public static interface getVarItem {
            public VarItem run();
        }
    }

    public static enum RequiredRank {
        Noble("Noble", class_5251.method_27717((int)0x7FFF7F)),
        Emperor("Emperor", class_5251.method_27717((int)0x55AAFF)),
        Mythic("Mythic", class_5251.method_27717((int)13904596)),
        Overlord("Overlord", class_5251.method_27718((class_124)class_124.field_1061)),
        Dev("", class_5251.method_27717((int)0));

        public final String name;
        public final class_5251 color;

        private RequiredRank(String name, class_5251 color) {
            this.name = name;
            this.color = color;
        }
    }

    public static class Color {
        int red;
        int green;
        int blue;

        public int getColor() {
            return (this.red << 16) + (this.green << 8) + this.blue;
        }
    }

    public record ArgumentGroup(List<Argument> arguments) {
        public List<ArgumentPossibilities> getPossibilities() {
            ArrayList<ArgumentPossibilities> groups = new ArrayList<ArgumentPossibilities>();
            ArrayList<Argument> group = new ArrayList<Argument>();
            for (Argument arg : this.arguments) {
                if (!arg.isOr()) {
                    group.add(arg);
                    continue;
                }
                groups.add(new ArgumentPossibilities(group));
                group = new ArrayList();
            }
            groups.add(new ArgumentPossibilities(group));
            return groups;
        }

        public record ArgumentPossibilities(List<Argument> arguments) {
        }
    }
}

