/*
 * Decompiled with CFR 0.152.
 */
package dev.dfonline.codeclient.hypercube.item;

import com.google.gson.JsonObject;
import dev.dfonline.codeclient.Utility;
import dev.dfonline.codeclient.data.DFItem;
import dev.dfonline.codeclient.hypercube.actiondump.ActionDump;
import dev.dfonline.codeclient.hypercube.item.VarItem;
import java.util.Arrays;
import java.util.Optional;
import net.minecraft.class_124;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_5250;

public class Potion
extends VarItem {
    private String potion;
    private int duration;
    private int amplifier;
    public static final int INFINITE = 1000000;

    @Override
    public String getId() {
        return "pot";
    }

    @Override
    protected class_1792 getIconItem() {
        return class_1802.field_8613;
    }

    @Override
    public JsonObject getDefaultData() {
        JsonObject object = new JsonObject();
        object.addProperty("pot", "Speed");
        object.addProperty("dur", (Number)1000000);
        object.addProperty("amp", (Number)0);
        return object;
    }

    public Potion(JsonObject var) {
        super(var);
        this.potion = this.data.get("pot").getAsString();
        this.duration = this.data.get("dur").getAsInt();
        this.amplifier = this.data.get("amp").getAsInt();
    }

    public Potion() {
        this.potion = "Speed";
        this.duration = 1000000;
        this.amplifier = 0;
    }

    public static String durationToString(int duration) {
        if (duration >= 1000000) {
            return "Infinite";
        }
        if (duration % 20 != 0) {
            return "%d ticks".formatted(duration);
        }
        int seconds = duration / 20;
        return "%d:%02d".formatted(seconds / 60, seconds % 60);
    }

    public String getPotion() {
        return this.potion;
    }

    public void setPotion(String potion) {
        this.data.addProperty("pot", potion);
        this.potion = potion;
    }

    public int getDuration() {
        return this.duration;
    }

    public void setDuration(int duration) {
        this.data.addProperty("dur", (Number)duration);
        this.duration = duration;
    }

    public int getAmplifier() {
        return this.amplifier;
    }

    public void setAmplifier(int amplifier) {
        this.data.addProperty("amp", (Number)amplifier);
        this.amplifier = amplifier;
    }

    @Override
    public class_1799 toStack() {
        class_5250 name;
        class_1799 stack = super.toStack();
        DFItem dfItem = DFItem.of(stack);
        dfItem.setName((class_2561)class_2561.method_43470((String)"Potion Effect").method_10862(class_2583.field_24360.method_10978(Boolean.valueOf(false)).method_10977(class_124.field_1068)));
        try {
            ActionDump db = ActionDump.getActionDump();
            Optional<dev.dfonline.codeclient.hypercube.actiondump.Potion> value = Arrays.stream(db.potions).filter(gv -> gv.icon.getCleanName().equals(this.potion)).findFirst();
            if (value.isEmpty()) {
                throw new Exception("");
            }
            name = class_2561.method_43470((String)value.get().icon.name);
        }
        catch (Exception e) {
            name = class_2561.method_43470((String)this.potion).method_10862(class_2583.field_24360);
        }
        Utility.addLore(dfItem.getItemStack(), new class_2561[]{name, class_2561.method_43473(), class_2561.method_43473().method_10852((class_2561)class_2561.method_43470((String)"Amplifier: ").method_10862(class_2583.field_24360.method_10978(Boolean.valueOf(false)).method_10977(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)String.valueOf(this.amplifier + 1)).method_10862(class_2583.field_24360.method_10977(class_124.field_1068)))), class_2561.method_43473().method_10852((class_2561)class_2561.method_43470((String)"Duration: ").method_10862(class_2583.field_24360.method_10978(Boolean.valueOf(false)).method_10977(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)this.duration()).method_10862(class_2583.field_24360.method_10977(class_124.field_1068))))});
        return dfItem.getItemStack();
    }

    public String duration() {
        return Potion.durationToString(this.duration);
    }
}

