/*
 * Decompiled with CFR 0.152.
 */
package dev.dfonline.codeclient.hypercube.item;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import dev.dfonline.codeclient.data.DFItem;
import dev.dfonline.codeclient.data.PublicBukkitValues;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.class_1792;
import net.minecraft.class_1799;

public abstract class VarItem {
    protected JsonObject data;

    public abstract String getId();

    protected abstract class_1792 getIconItem();

    public abstract JsonObject getDefaultData();

    public VarItem(class_1799 item) throws Exception {
        this(VarItem.prefetch(item));
    }

    public VarItem(JsonObject var) {
        String id = var.get("id").getAsString();
        if (!Objects.equals(id, this.getId())) {
            throw new IllegalArgumentException("Given wrong id, expecting (%s) but expected (%s)".formatted(id, this.getId()));
        }
        this.data = var.get("data").getAsJsonObject();
    }

    public VarItem() {
        this.data = this.getDefaultData();
    }

    public static JsonObject prefetch(class_1799 item) throws Exception {
        DFItem dfItem = DFItem.of(item);
        PublicBukkitValues pbv = dfItem.getPublicBukkitValues();
        Optional<String> varitem = pbv.getHypercubeStringValue("varitem");
        if (varitem.isEmpty()) {
            throw new Exception("Item does not have a varitem");
        }
        return JsonParser.parseString((String)varitem.get()).getAsJsonObject();
    }

    public class_1799 getIcon() {
        class_1799 item = this.getIconItem().method_7854();
        DFItem dfItem = DFItem.of(item);
        dfItem.setCustomModelData(5000);
        return item;
    }

    public class_1799 toStack() {
        DFItem dfItem = DFItem.of(this.getIcon());
        dfItem.editData(itemData -> {
            JsonObject varItem = new JsonObject();
            varItem.addProperty("id", this.getId());
            varItem.add("data", (JsonElement)this.data);
            itemData.setHypercubeStringValue("varitem", varItem.toString());
        });
        return dfItem.getItemStack();
    }

    public JsonObject getData() {
        return this.data;
    }

    public JsonObject getVar() {
        JsonObject var = new JsonObject();
        var.addProperty("id", this.getId());
        var.add("data", (JsonElement)this.getData());
        return var;
    }
}

