/*
 * Decompiled with CFR 0.152.
 */
package dev.dfonline.codeclient.mixin.render.hud;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import dev.dfonline.codeclient.CodeClient;
import dev.dfonline.codeclient.OverlayManager;
import dev.dfonline.codeclient.config.Config;
import dev.dfonline.codeclient.data.DFItem;
import dev.dfonline.codeclient.dev.overlay.ChestPeeker;
import dev.dfonline.codeclient.dev.overlay.SignPeeker;
import dev.dfonline.codeclient.hypercube.item.Scope;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_327;
import net.minecraft.class_329;
import net.minecraft.class_332;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_9779;
import net.minecraft.class_9848;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_329.class})
public abstract class MInGameHud {
    @Shadow
    private class_1799 field_2031;
    @Shadow
    private int field_2040;

    @Shadow
    public abstract class_327 method_1756();

    @Inject(method={"render"}, at={@At(value="HEAD")})
    private void onRender(class_332 context, class_9779 tickCounter, CallbackInfo ci) {
        int scaledWidth = context.method_51421();
        int scaledHeight = context.method_51443();
        class_327 textRenderer = this.method_1756();
        ArrayList<class_2561> overlay = new ArrayList<class_2561>(List.copyOf(OverlayManager.getOverlayText()));
        class_2561 cpuUsage = OverlayManager.getCpuUsage();
        if (cpuUsage != null && Config.getConfig().CPUDisplayCorner == Config.CPUDisplayCornerOption.TOP_LEFT) {
            if (overlay.isEmpty()) {
                overlay.add(cpuUsage);
            } else {
                overlay.add(0, cpuUsage);
                overlay.add(1, (class_2561)class_2561.method_43473());
            }
        }
        if (!overlay.isEmpty()) {
            int index = 0;
            for (class_2561 text : overlay) {
                context.method_27535(textRenderer, Objects.requireNonNullElseGet(text, () -> class_2561.method_43470((String)"NULL")), 30, 30 + index * 9, -1);
                ++index;
            }
        }
        if (cpuUsage != null && Config.getConfig().CPUDisplayCorner != Config.CPUDisplayCornerOption.TOP_LEFT) {
            int margin = 30;
            int x = switch (Config.getConfig().CPUDisplayCorner) {
                default -> throw new MatchException(null, null);
                case Config.CPUDisplayCornerOption.TOP_LEFT, Config.CPUDisplayCornerOption.BOTTOM_LEFT -> margin;
                case Config.CPUDisplayCornerOption.TOP_RIGHT, Config.CPUDisplayCornerOption.BOTTOM_RIGHT -> scaledWidth - margin - textRenderer.method_27525((class_5348)cpuUsage);
            };
            int y = switch (Config.getConfig().CPUDisplayCorner) {
                default -> throw new MatchException(null, null);
                case Config.CPUDisplayCornerOption.TOP_LEFT, Config.CPUDisplayCornerOption.TOP_RIGHT -> margin;
                case Config.CPUDisplayCornerOption.BOTTOM_LEFT, Config.CPUDisplayCornerOption.BOTTOM_RIGHT -> scaledHeight - margin - 3;
            };
            context.method_27535(textRenderer, cpuUsage, x, y, -1);
        }
        int x = scaledWidth / 2 + Config.getConfig().ChestPeekerX;
        int yOrig = scaledHeight / 2 + Config.getConfig().ChestPeekerY;
        try {
            List<class_2561> peeker = CodeClient.getFeature(ChestPeeker.class).map(ChestPeeker::getOverlayText).orElse(null);
            if (peeker == null || peeker.isEmpty()) {
                peeker = SignPeeker.getOverlayText();
            }
            if (peeker != null && !peeker.isEmpty()) {
                context.method_51434(textRenderer, peeker, x, yOrig);
                context.method_71279();
            }
        }
        catch (Exception ignored) {
            context.method_51438(textRenderer, (class_2561)class_2561.method_43470((String)"An error occurred"), x, yOrig);
        }
    }

    @Inject(method={"renderHeldItemTooltip"}, at={@At(value="HEAD")}, cancellable=true)
    public void renderHeldItemTooltip(class_332 context, CallbackInfo ci) {
        if (!Config.getConfig().ShowVariableScopeBelowName) {
            return;
        }
        DFItem dfItem = DFItem.of(this.field_2031);
        if (!dfItem.hasHypercubeKey("varitem")) {
            return;
        }
        Optional<String> varItem = dfItem.getHypercubeStringValue("varitem");
        if (varItem.isEmpty()) {
            return;
        }
        int scaledWidth = context.method_51421();
        int scaledHeight = context.method_51443();
        try {
            JsonObject varItemJson = JsonParser.parseString((String)varItem.get()).getAsJsonObject();
            String type = varItemJson.get("id").getAsString();
            JsonElement varName = varItemJson.getAsJsonObject("data").get("name");
            if (varName == null) {
                return;
            }
            if (type.equals("var")) {
                ci.cancel();
                class_5250 nameText = class_2561.method_43470((String)varName.getAsString());
                int x1 = (scaledWidth - this.method_1756().method_27525((class_5348)nameText)) / 2;
                int y1 = scaledHeight - 45;
                context.method_27535(this.method_1756(), (class_2561)nameText, x1, y1, 0xFFFFFF);
                context.method_60649(this.method_1756(), (class_2561)nameText, x1, y1, 0xFFFFFF, class_9848.method_61330((int)255, (int)-1));
                try {
                    Scope scope = Scope.valueOf(varItemJson.getAsJsonObject("data").get("scope").getAsString());
                    int x2 = (scaledWidth - this.method_1756().method_1727(scope.longName)) / 2;
                    int y2 = scaledHeight - 35;
                    context.method_27535(this.method_1756(), (class_2561)class_2561.method_43470((String)scope.longName).method_27696(class_2583.field_24360.method_27703(scope.color)), x2, y2, 0xFFFFFF);
                    context.method_60649(this.method_1756(), (class_2561)class_2561.method_43470((String)scope.longName).method_27696(class_2583.field_24360.method_27703(scope.color)), x2, y2, 0xFFFFFF, class_9848.method_61330((int)255, (int)-1));
                }
                catch (Exception exception) {}
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

