/*
 * Decompiled with CFR 0.152.
 */
package dev.dfonline.codeclient.switcher;

import java.util.ArrayList;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_10799;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_3675;
import net.minecraft.class_437;
import net.minecraft.class_6382;

public abstract class GenericSwitcher
extends class_437 {
    private static final class_2960 TEXTURE = class_2960.method_60656((String)"textures/gui/container/gamemode_switcher.png");
    private static final class_2960 SLOT_TEXTURE = class_2960.method_60656((String)"gamemode_switcher/slot");
    private static final class_2960 SELECTED_TEXTURE = class_2960.method_60656((String)"gamemode_switcher/selection");
    public final int HOLD_KEY;
    public final int PRESS_KEY;
    private final List<SelectableButtonWidget> buttons = new ArrayList<SelectableButtonWidget>();
    protected boolean hasClicked = false;
    protected Integer selected;
    protected class_2561 footer = class_2561.method_43471((String)"codeclient.switcher.footer");
    private boolean usingMouseToSelect = false;
    private Integer lastMouseX;
    private Integer lastMouseY;

    protected GenericSwitcher(class_2561 title, int holdKey, int pressKey) {
        super(title);
        this.HOLD_KEY = holdKey;
        this.PRESS_KEY = pressKey;
    }

    abstract List<Option> getOptions();

    protected void method_25426() {
        super.method_25426();
        this.usingMouseToSelect = false;
        List<Option> options = this.getOptions();
        int width = options.size() * 31 - 5;
        int i = 0;
        for (Option option : options) {
            this.buttons.add(new SelectableButtonWidget(option, this.field_22789 / 2 - width / 2 + i * 31, this.field_22790 / 2 - 31));
            ++i;
        }
    }

    protected void method_37067() {
        super.method_37067();
        this.buttons.clear();
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        Option selected;
        if (this.checkFinished()) {
            return;
        }
        int centerX = this.field_22789 / 2 - 62;
        int centerY = this.field_22790 / 2 - 31 - 27;
        context.method_25290(class_10799.field_56883, TEXTURE, centerX, centerY, 0.0f, 0.0f, 125, 75, 128, 128);
        super.method_25394(context, mouseX, mouseY, delta);
        if (this.lastMouseX == null) {
            this.lastMouseX = mouseX;
        }
        if (this.lastMouseY == null) {
            this.lastMouseY = mouseY;
        }
        if (!this.usingMouseToSelect) {
            if (this.lastMouseX != mouseX || this.lastMouseY != mouseY) {
                this.usingMouseToSelect = true;
            }
            this.lastMouseX = mouseX;
            this.lastMouseY = mouseY;
        }
        class_2561 selectedText = (selected = this.getSelected()) != null ? selected.text : class_2561.method_43471((String)"codeclient.switcher.select");
        context.method_27534(this.field_22793, selectedText, this.field_22789 / 2, this.field_22790 / 2 - 51, -1);
        context.method_27534(this.field_22793, this.footer, this.field_22789 / 2, this.field_22790 / 2 + 5, -1);
        int i = 0;
        for (SelectableButtonWidget button : this.buttons) {
            if (this.usingMouseToSelect && button.method_46426() < mouseX && button.method_46426() + 31 > mouseX) {
                this.selected = i;
            }
            button.selected = this.selected == i;
            context.method_52706(class_10799.field_56883, SLOT_TEXTURE, button.method_46426(), button.method_46427(), 26, 26);
            if (button.selected) {
                context.method_52706(class_10799.field_56883, SELECTED_TEXTURE, button.method_46426(), button.method_46427(), 26, 26);
            }
            button.method_25394(context, mouseX, mouseY, delta);
            ++i;
        }
    }

    public void method_25420(class_332 context, int mouseX, int mouseY, float delta) {
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (keyCode == this.PRESS_KEY) {
            this.usingMouseToSelect = false;
            Integer n = this.selected;
            this.selected = this.selected + 1;
            this.selected = this.selected % this.getOptions().size();
            return true;
        }
        if (keyCode == 256) {
            this.method_25419();
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        int i = 0;
        for (SelectableButtonWidget widget : this.buttons) {
            if ((double)widget.method_46426() < mouseX && (double)(widget.method_46426() + 31) > mouseX && (double)widget.method_46427() < mouseY && (double)(widget.method_46427() + 31) > mouseY) {
                this.selected = i;
            }
            boolean bl = widget.selected = this.selected == i;
            if (widget.selected) {
                this.hasClicked = true;
                return true;
            }
            ++i;
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    protected boolean checkFinished() {
        if (this.field_22787 == null) {
            return false;
        }
        if (this.hasClicked || !class_3675.method_15987((long)this.field_22787.method_22683().method_4490(), (int)this.HOLD_KEY)) {
            Option selected = this.getSelected();
            if (selected != null) {
                selected.run();
            }
            this.field_22787.method_1507(null);
            return true;
        }
        return false;
    }

    protected Option getSelected() {
        List<Option> options = this.getOptions();
        if (this.selected >= options.size()) {
            return null;
        }
        if (this.selected < 0) {
            return null;
        }
        return options.get(this.selected);
    }

    public boolean method_25421() {
        return false;
    }

    public boolean method_25422() {
        return true;
    }

    @Environment(value=EnvType.CLIENT)
    public record Option(class_2561 text, class_1799 icon, Callback callback) {
        public void run() {
            this.callback.run();
        }
    }

    @Environment(value=EnvType.CLIENT)
    private class SelectableButtonWidget
    extends class_339 {
        final Option option;
        public boolean selected;

        public SelectableButtonWidget(Option option, int x, int y) {
            super(x, y, 26, 26, option.text());
            this.selected = false;
            this.option = option;
        }

        public void method_48579(class_332 context, int mouseX, int mouseY, float delta) {
            context.method_25290(class_10799.field_56883, TEXTURE, 0, 0, 0.0f, 75.0f, 26, 26, 128, 128);
            context.method_51427(this.option.icon, this.method_46426() + 5, this.method_46427() + 5);
            context.method_51431(GenericSwitcher.this.field_22793, this.option.icon, this.method_46426() + 5, this.method_46427() + 5);
            if (this.selected) {
                context.method_70846(class_10799.field_56883, TEXTURE, 0, 0, 26, 75, 26, 26, 128, 128);
            }
        }

        protected void method_47399(class_6382 builder) {
            this.method_37021(builder);
        }
    }

    public static interface Callback {
        public void run();
    }
}

