/*
 * Decompiled with CFR 0.152.
 */
package dev.dfonline.codeclient.websocket;

import dev.dfonline.codeclient.ChatType;
import dev.dfonline.codeclient.CodeClient;
import dev.dfonline.codeclient.Utility;
import dev.dfonline.codeclient.websocket.SocketHandler;
import java.net.InetSocketAddress;
import net.minecraft.class_2561;
import org.java_websocket.WebSocket;
import org.java_websocket.handshake.ClientHandshake;
import org.java_websocket.server.WebSocketServer;

public class SocketServer
extends WebSocketServer {
    private final SocketHandler handler;

    public SocketServer(InetSocketAddress address, SocketHandler socketHandler) {
        super(address);
        this.handler = socketHandler;
    }

    public void onOpen(WebSocket conn, ClientHandshake handshake) {
        CodeClient.LOGGER.info("connection");
        this.handler.setConnection(conn);
        CodeClient.LOGGER.info("{} has just connected to the CodeClient API.", (Object)conn.getRemoteSocketAddress().toString());
        Utility.sendMessage((class_2561)class_2561.method_43471((String)"codeclient.api.connect"), ChatType.INFO);
    }

    public void onClose(WebSocket conn, int code, String reason, boolean remote) {
        CodeClient.LOGGER.info("{} has just disconnected from the CodeClient API.", (Object)conn.getRemoteSocketAddress().toString());
        this.handler.setConnection(null);
    }

    public void onMessage(WebSocket conn, String message) {
        if (conn == null) {
            return;
        }
        this.handler.onMessage(message);
    }

    public void onError(WebSocket conn, Exception ex) {
    }

    public void onStart() {
        CodeClient.LOGGER.info("CodeClient API started!");
    }
}

