/*
 * Decompiled with CFR 0.152.
 */
package dev.dfonline.codeclient;

import dev.dfonline.codeclient.CodeClient;
import dev.dfonline.codeclient.config.Config;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import net.fabricmc.loader.api.FabricLoader;

public class FileManager {
    public static Path Path() {
        Path path = CodeClient.MC.field_1697.toPath().resolve("codeclient");
        path.toFile().mkdir();
        return path;
    }

    public static Path templatesPath() {
        Path path = FileManager.Path().resolve("templates");
        path.toFile().mkdir();
        return path;
    }

    public static Path recentValuesPath() {
        return FileManager.Path().resolve("recent_values.json");
    }

    public static Path writeFile(String fileName, String content) throws IOException {
        return FileManager.writeFile(fileName, content, true);
    }

    public static File getConfigFile() {
        return new File(FabricLoader.getInstance().getConfigDir().toFile(), "codeclient.json");
    }

    public static void writeConfig(String content) throws IOException {
        File file = FileManager.getConfigFile();
        Files.deleteIfExists(file.toPath());
        Files.createFile(file.toPath(), new FileAttribute[0]);
        if (!file.exists()) {
            boolean bl = file.createNewFile();
        }
        Files.write(file.toPath(), content.getBytes(), StandardOpenOption.WRITE);
    }

    public static String readConfig() throws IOException {
        return Files.readString(FileManager.getConfigFile().toPath());
    }

    public static Path writeFile(String fileName, String content, boolean doCharSet) throws IOException {
        Path path = FileManager.Path().resolve(fileName);
        Files.deleteIfExists(path);
        Files.createFile(path, new FileAttribute[0]);
        if (doCharSet) {
            Files.write(path, content.getBytes(Config.getConfig().SaveCharSet.charSet), StandardOpenOption.WRITE);
        } else {
            Files.write(path, content.getBytes(), StandardOpenOption.WRITE);
        }
        return path;
    }

    public static String readFile(String fileName, Charset charset) throws IOException {
        return Files.readString(FileManager.Path().resolve(fileName), charset);
    }

    public static boolean exists(String fileName) {
        return Files.exists(FileManager.Path().resolve(fileName), new LinkOption[0]);
    }

    public static String readFile(String fileName) throws IOException {
        return FileManager.readFile(fileName, Config.getConfig().FileCharSet.charSet);
    }
}

