/*
 * Decompiled with CFR 0.152.
 */
package dev.dfonline.codeclient.action.impl;

import com.google.gson.JsonParser;
import dev.dfonline.codeclient.Callback;
import dev.dfonline.codeclient.CodeClient;
import dev.dfonline.codeclient.Utility;
import dev.dfonline.codeclient.action.Action;
import dev.dfonline.codeclient.action.impl.GoTo;
import dev.dfonline.codeclient.data.DFItem;
import dev.dfonline.codeclient.hypercube.template.Template;
import dev.dfonline.codeclient.hypercube.template.TemplateBlock;
import dev.dfonline.codeclient.location.Dev;
import dev.dfonline.codeclient.location.Location;
import dev.dfonline.codeclient.mixin.entity.player.ClientPlayerInteractionManagerAccessor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Pattern;
import net.minecraft.class_10185;
import net.minecraft.class_1268;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2596;
import net.minecraft.class_2637;
import net.minecraft.class_2680;
import net.minecraft.class_2846;
import net.minecraft.class_2851;
import net.minecraft.class_2885;
import net.minecraft.class_3944;
import net.minecraft.class_3965;
import net.minecraft.class_634;
import net.minecraft.class_746;
import net.minecraft.class_8242;
import org.apache.commons.lang3.ObjectUtils;
import org.jetbrains.annotations.Nullable;

public class PlaceTemplates
extends Action {
    private final ArrayList<Operation> operations;
    private int cooldown = 0;
    private class_1799 recoverMainHand;
    private GoTo goTo = null;
    private boolean shouldBeSwapping = false;

    public PlaceTemplates(List<class_1799> templates, Callback callback) {
        super(callback);
        ArrayList<TemplateToPlace> templatesToPlace;
        Location location = CodeClient.location;
        if (location instanceof Dev) {
            Dev plot = (Dev)location;
            int i = 0;
            templatesToPlace = new ArrayList<TemplateToPlace>();
            int rowSize = plot.assumeSize().codeWidth / 2 + 1;
            for (class_1799 template : templates) {
                int row = i % rowSize;
                int level = i / rowSize;
                ++i;
                class_243 pos = new class_243((double)plot.getX().intValue(), (double)plot.getFloorY(), (double)plot.getZ().intValue()).method_1031((double)((2 + row * 3) * -1), (double)(level * 5), 0.0);
                templatesToPlace.add(new TemplateToPlace(pos, template));
            }
        } else {
            throw new IllegalStateException("Player must be in dev mode.");
        }
        this.operations = templatesToPlace;
    }

    public PlaceTemplates(HashMap<class_2338, class_1799> templates, Callback callback) {
        super(callback);
        ArrayList<TemplateToPlace> templatesToPlace = new ArrayList<TemplateToPlace>();
        for (Map.Entry<class_2338, class_1799> template : templates.entrySet()) {
            templatesToPlace.add(new TemplateToPlace(template.getKey(), template.getValue()));
        }
        this.operations = templatesToPlace;
    }

    @Nullable
    public static PlaceTemplates createSwapper(List<class_1799> templates, Callback callback) {
        Location location = CodeClient.location;
        if (location instanceof Dev) {
            Dev dev = (Dev)location;
            HashMap<class_2338, class_1799> map = new HashMap<class_2338, class_1799>();
            HashMap<class_2338, class_8242> scan = dev.scanForSigns(Pattern.compile(".*"));
            ArrayList<class_1799> leftOvers = new ArrayList<class_1799>(templates);
            for (class_1799 item : templates) {
                DFItem dfItem = new DFItem(item);
                Optional<String> codeTemplateData = dfItem.getHypercubeStringValue("codetemplatedata");
                if (codeTemplateData.isEmpty()) continue;
                try {
                    Template template = Template.parse64(JsonParser.parseString((String)codeTemplateData.get()).getAsJsonObject().get("code").getAsString());
                    if (template == null || template.blocks.isEmpty()) continue;
                    TemplateBlock block = template.blocks.get(0);
                    if (block.block == null) continue;
                    TemplateBlock.Block blockName = TemplateBlock.Block.valueOf(block.block.toUpperCase());
                    String name = (String)ObjectUtils.firstNonNull((Object[])new String[]{block.action, block.data});
                    for (Map.Entry<class_2338, class_8242> sign : scan.entrySet()) {
                        class_8242 text = sign.getValue();
                        if (!text.method_49859(0, false).getString().equals(blockName.name) || !text.method_49859(1, false).getString().equals(name)) continue;
                        map.put(sign.getKey().method_10078(), item);
                        leftOvers.remove(item);
                    }
                }
                catch (Exception e) {
                    CodeClient.LOGGER.warn(e.getMessage());
                }
            }
            if (!leftOvers.isEmpty()) {
                class_2338 freePos = dev.findFreePlacePos();
                for (class_1799 item : leftOvers) {
                    if (freePos == null) {
                        return null;
                    }
                    map.put(freePos, item);
                    freePos = dev.findFreePlacePos(freePos.method_10088(2));
                }
            }
            return new PlaceTemplates(map, callback);
        }
        return null;
    }

    public static PlaceTemplates createPlacer(List<class_1799> templates, Callback callback) {
        return PlaceTemplates.createPlacer(templates, callback, false);
    }

    public static PlaceTemplates createPlacer(List<class_1799> templates, Callback callback, boolean compacter) {
        Location location = CodeClient.location;
        if (location instanceof Dev) {
            Dev dev = (Dev)location;
            HashMap<class_2338, class_1799> map = new HashMap<class_2338, class_1799>();
            if (!compacter) {
                class_2338 lastPos = dev.findFreePlacePos();
                for (class_1799 template : templates) {
                    if (lastPos == null) {
                        return null;
                    }
                    map.put(lastPos, template);
                    lastPos = dev.findFreePlacePos(lastPos.method_10088(2));
                }
            } else {
                class_2338 nextPos = dev.findFreePlacePos();
                for (class_1799 template : templates) {
                    Template parsed = Template.parse64(Utility.templateDataItem(template));
                    if (parsed == null) {
                        return null;
                    }
                    int size = parsed.getLength();
                    class_2338 placePos = nextPos;
                    if (placePos == null) {
                        return null;
                    }
                    class_2338 templateEndPos = placePos.method_10077(size);
                    if (dev.isInDev(templateEndPos).booleanValue()) {
                        nextPos = templateEndPos;
                    } else {
                        if ((placePos = dev.findFreePlacePos(placePos.method_10088(2))) == null) {
                            return null;
                        }
                        nextPos = placePos.method_10077(size);
                    }
                    map.put(placePos, template);
                }
            }
            return new PlaceTemplates(map, callback);
        }
        return null;
    }

    public PlaceTemplates swap() {
        this.shouldBeSwapping = true;
        return this;
    }

    @Override
    public void init() {
        this.cooldown = 4;
        assert (CodeClient.MC.field_1724 != null);
        this.recoverMainHand = CodeClient.MC.field_1724.method_6047();
    }

    @Override
    public boolean onReceivePacket(class_2596<?> packet) {
        if (packet instanceof class_3944) {
            return true;
        }
        if (packet instanceof class_2637) {
            class_2637 updates = (class_2637)packet;
            for (Operation operation : this.operations) {
                var block = new Object(this){
                    boolean isTemplate = false;
                    class_2680 state = null;
                };
                updates.method_30621((blockPos, blockState) -> {
                    if (operation.pos.equals(blockPos)) {
                        block.isTemplate = true;
                        block.state = blockState;
                    }
                });
                if (!(operation instanceof TemplateToPlace) || !block.isTemplate) continue;
                operation.setComplete();
            }
        }
        return super.onReceivePacket(packet);
    }

    @Override
    public void tick() {
        class_634 net = CodeClient.MC.method_1562();
        if (CodeClient.MC.field_1761 == null || CodeClient.MC.field_1724 == null || net == null) {
            return;
        }
        if (CodeClient.location instanceof Dev) {
            if (this.operations.isEmpty()) {
                this.callback();
                return;
            }
            if (this.goTo != null) {
                this.goTo.tick();
            }
            if (this.cooldown > 0) {
                --this.cooldown;
            }
            Operation closestOperation = null;
            this.operations.removeIf(Operation::isComplete);
            for (Operation operation : this.operations.stream().toList()) {
                double distanceToCurrentOperation = operation.pos().method_1022(CodeClient.MC.field_1724.method_33571());
                if (distanceToCurrentOperation <= 5.8 && operation.isOpen() && !operation.isComplete()) {
                    if (this.cooldown == 0 && operation instanceof TemplateToPlace) {
                        TemplateToPlace template = (TemplateToPlace)operation;
                        if (this.shouldBeSwapping) {
                            boolean sneaky;
                            class_746 player = CodeClient.MC.field_1724;
                            boolean bl = sneaky = !player.method_5715();
                            if (sneaky) {
                                net.method_52787((class_2596)new class_2851(new class_10185(false, false, false, false, false, true, false)));
                            }
                            net.method_52787((class_2596)new class_2846(class_2846.class_2847.field_12968, template.pos, class_2350.field_11036));
                            net.method_52787((class_2596)new class_2846(class_2846.class_2847.field_12971, template.pos, class_2350.field_11036));
                            if (sneaky) {
                                net.method_52787((class_2596)new class_2851(CodeClient.MC.field_1724.method_71091()));
                            }
                        }
                        Utility.makeHolding(template.template);
                        class_3965 blockHitResult = new class_3965(template.pos().method_1031(0.0, 1.0, 0.0), class_2350.field_11036, template.pos, false);
                        ((ClientPlayerInteractionManagerAccessor)CodeClient.MC.field_1761).invokeSequencedPacket(CodeClient.MC.field_1687, sequence -> new class_2885(class_1268.field_5808, blockHitResult, sequence));
                        template.setOpen(false);
                    }
                    return;
                }
                if (closestOperation != null && !(distanceToCurrentOperation < closestOperation.pos().method_1022(CodeClient.MC.field_1724.method_33571()))) continue;
                closestOperation = operation;
            }
            if (closestOperation == null) {
                Iterator<Object> iterator = this.operations.iterator();
                while (iterator.hasNext()) {
                    Operation operation;
                    operation.setOpen(!(operation = (Operation)iterator.next()).isComplete());
                }
            } else {
                this.goTo = new GoTo(closestOperation.pos().method_1031(-2.0, 0.5, 0.0), () -> {
                    this.goTo = null;
                });
                this.goTo.init();
                this.cooldown = 2;
            }
        }
    }

    private static class TemplateToPlace
    extends Operation {
        private final class_1799 template;

        public TemplateToPlace(class_243 pos, class_1799 template) {
            super(pos);
            this.template = template;
        }

        public TemplateToPlace(class_2338 pos, class_1799 template) {
            super(pos);
            this.template = template;
        }
    }

    private static abstract class Operation {
        protected final class_2338 pos;
        private boolean open = true;
        private boolean complete = false;

        public Operation(class_2338 pos) {
            this.pos = pos;
        }

        public Operation(class_243 pos) {
            this.pos = new class_2338((int)pos.field_1352, (int)pos.field_1351, (int)pos.field_1350);
        }

        public class_243 pos() {
            return this.pos.method_46558();
        }

        public boolean isOpen() {
            return this.open;
        }

        public void setOpen(boolean open) {
            this.open = open;
        }

        public void setComplete() {
            this.open = false;
            this.complete = true;
        }

        public boolean isComplete() {
            return this.complete;
        }
    }
}

