/*
 * Decompiled with CFR 0.152.
 */
package dev.dfonline.codeclient.command;

import com.mojang.brigadier.Message;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import dev.dfonline.codeclient.FileManager;
import dev.dfonline.codeclient.command.ActionCommand;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Stream;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_2561;

public abstract class TemplateActionCommand
extends ActionCommand {
    protected CompletableFuture<Suggestions> suggestDirectories(CommandContext<FabricClientCommandSource> context, SuggestionsBuilder builder) {
        return TemplateActionCommand.suggestTemplates(context, builder, false);
    }

    protected CompletableFuture<Suggestions> suggestTemplates(CommandContext<FabricClientCommandSource> context, SuggestionsBuilder builder) {
        return TemplateActionCommand.suggestTemplates(context, builder, true);
    }

    private static CompletableFuture<Suggestions> suggestTemplates(CommandContext<FabricClientCommandSource> ignored, SuggestionsBuilder builder, boolean suggestFiles) {
        try {
            ArrayList<CallSite> possibilities = new ArrayList<CallSite>();
            String[] path = builder.getRemaining().split("/", -1);
            String currentPath = String.join((CharSequence)"/", Arrays.stream(path).toList().subList(0, path.length - 1));
            Stream<Path> list = Files.list(FileManager.templatesPath().resolve(currentPath));
            for (Path path2 : list.toList()) {
                Object s;
                if (path2.getFileName().toString().equals(".git")) continue;
                Object object = s = currentPath.isEmpty() ? "" : currentPath + "/";
                if (Files.isDirectory(path2, new LinkOption[0])) {
                    possibilities.add((CallSite)((Object)((String)s + path2.getFileName().toString() + "/")));
                    continue;
                }
                if (!path2.getFileName().toString().endsWith(".dft")) continue;
                String name = path2.getFileName().toString();
                if (!suggestFiles) continue;
                possibilities.add((CallSite)((Object)((String)s + name.substring(0, name.length() - 4))));
            }
            list.close();
            for (String string : possibilities) {
                if (!string.toLowerCase().contains(builder.getRemainingLowerCase())) continue;
                builder.suggest(string, (Message)class_2561.method_43470((String)"Folder"));
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return CompletableFuture.completedFuture(builder.build());
    }

    protected static List<String> getAllTemplates(Path path) throws IOException {
        if (Files.notExists(path, new LinkOption[0])) {
            Path asName = path.getParent().resolve(String.valueOf(path.getFileName()) + ".dft");
            if (Files.exists(asName, new LinkOption[0])) {
                return TemplateActionCommand.getAllTemplates(asName);
            }
            return null;
        }
        if (Files.isDirectory(path, new LinkOption[0])) {
            ArrayList<String> list = new ArrayList<String>();
            Stream<Path> files = Files.list(path);
            for (Path file : files.toList()) {
                list.addAll(TemplateActionCommand.getAllTemplates(file));
            }
            files.close();
            return list;
        }
        byte[] data = Files.readAllBytes(path);
        return Collections.singletonList(new String(Base64.getEncoder().encode(data)));
    }
}

