/*
 * Decompiled with CFR 0.152.
 */
package dev.dfonline.codeclient.command.impl;

import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import dev.dfonline.codeclient.CodeClient;
import dev.dfonline.codeclient.action.None;
import dev.dfonline.codeclient.action.impl.GoTo;
import dev.dfonline.codeclient.command.Command;
import dev.dfonline.codeclient.location.Dev;
import dev.dfonline.codeclient.location.Location;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.regex.Pattern;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_7157;
import net.minecraft.class_8242;
import org.jetbrains.annotations.Nullable;

public class CommandJump
extends Command {
    private static void jump(JumpType type, String name) {
        Location location = CodeClient.location;
        if (location instanceof Dev) {
            Dev dev = (Dev)location;
            if (CodeClient.currentAction instanceof None) {
                @Nullable HashMap<class_2338, class_8242> results = type == JumpType.FUNCTION || type == JumpType.PROCESS ? dev.scanForSigns(type.pattern, Pattern.compile("^" + Pattern.quote(name) + "$")) : dev.scanForSigns(type.pattern, Pattern.compile("^" + Pattern.quote(name) + "$", 2));
                if (results == null) {
                    return;
                }
                Optional first = results.keySet().stream().findFirst();
                if (first.isEmpty()) {
                    results = dev.scanForSigns(type.pattern, Pattern.compile("^.*" + Pattern.quote(name) + ".*$", 2));
                    if (results == null) {
                        return;
                    }
                    first = results.keySet().stream().findFirst();
                    if (first.isEmpty()) {
                        return;
                    }
                }
                CodeClient.currentAction = new GoTo(((class_2338)first.get()).method_46558(), () -> {
                    CodeClient.currentAction = new None();
                });
                CodeClient.currentAction.init();
            }
        }
    }

    public static CompletableFuture<Suggestions> suggestJump(JumpType type, CommandContext<FabricClientCommandSource> ignored, SuggestionsBuilder builder, boolean lineStarters) {
        Location location = CodeClient.location;
        if (location instanceof Dev) {
            Dev dev = (Dev)location;
            ArrayList<String> possibilities = new ArrayList<String>();
            for (class_8242 signText : lineStarters ? dev.getLineStartCache().values() : dev.getActionCache().values()) {
                if (!type.pattern.matcher(signText.method_49859(0, false).getString()).matches()) continue;
                possibilities.add(signText.method_49859(1, false).getString());
            }
            for (String possibility : possibilities) {
                if (!possibility.toLowerCase().contains(builder.getRemainingLowerCase())) continue;
                builder.suggest(possibility, (Message)class_2561.method_43470((String)type.name().toLowerCase()));
            }
        }
        return CompletableFuture.completedFuture(builder.build());
    }

    @Override
    public String name() {
        return "jump";
    }

    @Override
    public String[] aliases() {
        return new String[]{"goto"};
    }

    @Override
    public LiteralArgumentBuilder<FabricClientCommandSource> create(LiteralArgumentBuilder<FabricClientCommandSource> cmd, class_7157 registryAccess) {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)cmd.then(ClientCommandManager.literal((String)"player").then(ClientCommandManager.argument((String)"name", (ArgumentType)StringArgumentType.greedyString()).suggests((context, builder) -> CommandJump.suggestJump(JumpType.PLAYER_EVENT, (CommandContext<FabricClientCommandSource>)context, builder, true)).executes(context -> {
            String name = (String)context.getArgument("name", String.class);
            CommandJump.jump(JumpType.PLAYER_EVENT, name);
            return 0;
        })))).then(ClientCommandManager.literal((String)"entity").then(ClientCommandManager.argument((String)"name", (ArgumentType)StringArgumentType.greedyString()).suggests((context, builder) -> CommandJump.suggestJump(JumpType.ENTITY_EVENT, (CommandContext<FabricClientCommandSource>)context, builder, true)).executes(context -> {
            String name = (String)context.getArgument("name", String.class);
            CommandJump.jump(JumpType.ENTITY_EVENT, name);
            return 0;
        })))).then(ClientCommandManager.literal((String)"func").then(ClientCommandManager.argument((String)"name", (ArgumentType)StringArgumentType.greedyString()).suggests((context, builder) -> CommandJump.suggestJump(JumpType.FUNCTION, (CommandContext<FabricClientCommandSource>)context, builder, true)).executes(context -> {
            String name = (String)context.getArgument("name", String.class);
            CommandJump.jump(JumpType.FUNCTION, name);
            return 0;
        })))).then(ClientCommandManager.literal((String)"proc").then(ClientCommandManager.argument((String)"name", (ArgumentType)StringArgumentType.greedyString()).suggests((context, builder) -> CommandJump.suggestJump(JumpType.PROCESS, (CommandContext<FabricClientCommandSource>)context, builder, true)).executes(context -> {
            String name = (String)context.getArgument("name", String.class);
            CommandJump.jump(JumpType.PROCESS, name);
            return 0;
        })));
    }

    public static enum JumpType {
        PLAYER_EVENT("PLAYER EVENT"),
        ENTITY_EVENT("ENTITY EVENT"),
        FUNCTION("FUNCTION"),
        PROCESS("PROCESS"),
        ANY("(((PLAYER)|(ENTITY)) EVENT)|(FUNCTION)|(PROCESS)"),
        ACTIONS("(PLAYER|ENTITY|GAME) ACTION|CALL FUNCTION|START PROCESS|CONTROL|REPEAT|SET VARIABLE|SELECT OBJECT|IF (GAME|ENTITY|PLAYER|VARIABLE)");

        public final Pattern pattern;

        private JumpType(String scan) {
            this.pattern = Pattern.compile("^" + scan + "$");
        }
    }
}

