/*
 * Decompiled with CFR 0.152.
 */
package dev.dfonline.codeclient.command.impl;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import dev.dfonline.codeclient.ChatType;
import dev.dfonline.codeclient.CodeClient;
import dev.dfonline.codeclient.FileManager;
import dev.dfonline.codeclient.Utility;
import dev.dfonline.codeclient.command.TemplateActionCommand;
import dev.dfonline.codeclient.data.DFItem;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Base64;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_7157;

public class CommandLoad
extends TemplateActionCommand {
    @Override
    public String name() {
        return "load";
    }

    @Override
    public LiteralArgumentBuilder<FabricClientCommandSource> create(LiteralArgumentBuilder<FabricClientCommandSource> cmd, class_7157 registryAccess) {
        return (LiteralArgumentBuilder)cmd.then(ClientCommandManager.argument((String)"path", (ArgumentType)StringArgumentType.greedyString()).suggests((x$0, x$1) -> this.suggestTemplates((CommandContext<FabricClientCommandSource>)x$0, x$1)).executes(context -> {
            if (CodeClient.MC.field_1724 == null) {
                return -1;
            }
            if (CodeClient.MC.field_1724.method_68878()) {
                String arg = (String)context.getArgument("path", String.class);
                Path path = FileManager.templatesPath().resolve(arg + ".dft");
                if (Files.notExists(path, new LinkOption[0])) {
                    Utility.sendMessage((class_2561)class_2561.method_43471((String)"codeclient.files.error.cant_read"), ChatType.FAIL);
                    return -1;
                }
                try {
                    byte[] data = Files.readAllBytes(path);
                    class_1799 template = Utility.makeTemplate(new String(Base64.getEncoder().encode(data)));
                    DFItem dfItem = new DFItem(template);
                    dfItem.setName((class_2561)class_2561.method_43473().method_27692(class_124.field_1061).method_27693("Saved Template").method_10852((class_2561)class_2561.method_43470((String)" \u00bb ").method_27695(new class_124[]{class_124.field_1079, class_124.field_1067})).method_27693(String.valueOf(FileManager.templatesPath().relativize(path))));
                    CodeClient.MC.field_1724.method_7270(dfItem.getItemStack());
                    Utility.sendInventory();
                }
                catch (Exception e) {
                    Utility.sendMessage((class_2561)class_2561.method_43469((String)"codeclient.files.error.read_file", (Object[])new Object[]{path}), ChatType.FAIL);
                    return -2;
                }
                return 0;
            }
            Utility.sendMessage((class_2561)class_2561.method_43471((String)"codeclient.warning.creative_mode"), ChatType.FAIL);
            return -1;
        }));
    }
}

