/*
 * Decompiled with CFR 0.152.
 */
package dev.dfonline.codeclient.command.impl;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import dev.dfonline.codeclient.CodeClient;
import dev.dfonline.codeclient.command.Command;
import dev.dfonline.codeclient.config.Config;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_7157;

public class CommandNode
extends Command {
    private static final Map<String, String> NODE_MAP = new HashMap<String, String>();
    private static final Pattern PRIVATE_NODE_PATTERN = Pattern.compile("^p(\\d+)$");

    public void loadNodes() {
        NODE_MAP.clear();
        NODE_MAP.put("1", "node1");
        NODE_MAP.put("2", "node2");
        NODE_MAP.put("3", "node3");
        NODE_MAP.put("4", "node4");
        NODE_MAP.put("5", "node5");
        NODE_MAP.put("6", "node6");
        NODE_MAP.put("7", "node7");
        NODE_MAP.put("beta", "beta");
        NODE_MAP.put("b", "beta");
        NODE_MAP.put("event", "event");
        if (Config.getConfig().DevNodes) {
            NODE_MAP.put("dev", "dev");
            NODE_MAP.put("dev1", "dev");
            NODE_MAP.put("dev2", "dev2");
            NODE_MAP.put("dev3", "dev3");
            NODE_MAP.put("d", "dev");
            NODE_MAP.put("d1", "dev");
            NODE_MAP.put("d2", "dev2");
            NODE_MAP.put("d3", "dev3");
        }
    }

    @Override
    public String name() {
        return "node";
    }

    @Override
    public LiteralArgumentBuilder<FabricClientCommandSource> create(LiteralArgumentBuilder<FabricClientCommandSource> cmd, class_7157 registryAccess) {
        return (LiteralArgumentBuilder)cmd.then(ClientCommandManager.argument((String)"node", (ArgumentType)StringArgumentType.word()).suggests((context, builder) -> {
            this.loadNodes();
            NODE_MAP.keySet().forEach(arg_0 -> ((SuggestionsBuilder)builder).suggest(arg_0));
            return builder.buildFuture();
        }).executes(context -> {
            Matcher privateNodeMatcher;
            String key = (String)context.getArgument("node", String.class);
            if (CodeClient.MC.method_1562() == null) {
                return -1;
            }
            Object serverId = NODE_MAP.getOrDefault(key, key);
            if (((String)serverId).equals(key) && (privateNodeMatcher = PRIVATE_NODE_PATTERN.matcher(key.trim())).find()) {
                serverId = "private" + privateNodeMatcher.group(1);
            }
            CodeClient.MC.method_1562().method_45730("server " + (String)serverId);
            return 0;
        }));
    }
}

