/*
 * Decompiled with CFR 0.152.
 */
package dev.dfonline.codeclient.dev;

import dev.dfonline.codeclient.Feature;
import dev.dfonline.codeclient.config.Config;
import dev.dfonline.codeclient.location.Dev;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import net.minecraft.class_2338;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlockBreakDeltaCalculator
extends Feature {
    private final RecentBlocks oldBlocks = new RecentBlocks();

    @Override
    public void onBreakBlock(@NotNull Dev dev, @NotNull class_2338 pos, @Nullable class_2338 breakPos) {
        if (breakPos != null) {
            this.oldBlocks.addBlock(pos);
        }
    }

    @Override
    public boolean enabled() {
        return Config.getConfig().CustomBlockBreaking;
    }

    public float calculateBlockDelta(class_2338 pos) {
        return 0.2f;
    }

    private static class RecentBlocks {
        private final ArrayList<RecentBlock> blocks = new ArrayList();

        private RecentBlocks() {
        }

        public void addBlock(class_2338 pos) {
            this.blocks.add(new RecentBlock(pos, new Date()));
        }

        public Stream<RecentBlock> getBlock(class_2338 pos) {
            return this.blocks.stream().filter(recentBlock -> Objects.equals(recentBlock.pos, pos));
        }

        public List<RecentBlock> getBlocks() {
            return this.blocks;
        }
    }

    private record RecentBlock(class_2338 pos, Date time) {
        public long howLongAgo() {
            return new Date().getTime() - this.time.getTime();
        }
    }
}

