/*
 * Decompiled with CFR 0.152.
 */
package dev.dfonline.codeclient.dev.highlighter;

import dev.dfonline.codeclient.config.Config;
import dev.dfonline.codeclient.hypercube.HypercubeMiniMessage;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import net.kyori.adventure.text.minimessage.Context;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.minimessage.ParsingException;
import net.kyori.adventure.text.minimessage.internal.parser.Token;
import net.kyori.adventure.text.minimessage.internal.parser.node.TagNode;
import net.kyori.adventure.text.minimessage.internal.parser.node.ValueNode;
import net.kyori.adventure.text.minimessage.tag.Tag;
import net.kyori.adventure.text.minimessage.tag.resolver.ArgumentQueue;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.kyori.adventure.text.minimessage.tag.standard.StandardTags;
import net.kyori.adventure.text.minimessage.tree.Node;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MiniMessageHighlighter {
    public MiniMessage HIGHLIGHTER = MiniMessage.builder().tags(TagResolver.resolver((TagResolver[])new TagResolver[]{new ShownTagResolver()})).build();
    public MiniMessage PARSER = MiniMessage.builder().tags(TagResolver.resolver((TagResolver[])new TagResolver[]{new ShownTagResolver(), HypercubeMiniMessage.NEWLINE_TAG, HypercubeMiniMessage.SPACE_TAG})).build();
    private final String RESET_TAG = "<reset>";

    private String getTagStyle() {
        return TextColor.color((int)Config.getConfig().MiniMessageTagColor).asHexString();
    }

    public Component highlight(String input) {
        String[] resets = input.split("(?i)<reset>");
        if (resets.length > 1 || input.toLowerCase().endsWith("<reset>")) {
            TextComponent value = Component.empty();
            Component reset = this.PARSER.deserialize((Object)(String.format("<%s>", this.getTagStyle()) + this.HIGHLIGHTER.escapeTags("<reset>") + String.format("</%s>", this.getTagStyle())));
            for (String partial : resets) {
                value = value.append(this.highlight(partial)).append(reset);
            }
            return value;
        }
        Node.Root root = this.PARSER.deserializeToTree(input);
        StringBuilder newInput = new StringBuilder(input.length());
        this.handle((Node)root, root.input(), newInput, new AtomicInteger(), new ArrayList<String>());
        return this.HIGHLIGHTER.deserialize((Object)newInput.toString());
    }

    private void handle(Node node, String full, StringBuilder sb, AtomicInteger index, ArrayList<String> decorations) {
        String tagName;
        String closing;
        Object tagNode;
        String style = this.getTagStyle();
        if (node instanceof TagNode) {
            tagNode = (TagNode)node;
            String tagString = this.getTokenString(tagNode.token(), full);
            index.addAndGet(tagString.length());
            this.appendEscapedTag(sb, tagString, style, decorations);
            String tagName2 = tagNode.name();
            if (StandardTags.decorations().has(tagName2)) {
                decorations.add(tagName2);
            }
            if (!tagString.contains("space") && !tagString.contains("newline")) {
                sb.append(tagString);
            }
        } else if (node instanceof ValueNode) {
            ValueNode valueNode = (ValueNode)node;
            String value = valueNode.value();
            index.addAndGet(value.length());
            sb.append(this.PARSER.escapeTags(value));
        }
        tagNode = node.children().iterator();
        while (tagNode.hasNext()) {
            Node child = (Node)tagNode.next();
            this.handle(child, full, sb, index, decorations);
        }
        if (node instanceof TagNode && full.startsWith(closing = String.format("</%s>", tagName = (tagNode = (TagNode)node).name()), index.get())) {
            if (StandardTags.decorations().has(tagName)) {
                decorations.remove(tagName);
            }
            index.addAndGet(closing.length());
            sb.append(closing);
            this.appendEscapedTag(sb, closing, style, decorations);
        }
    }

    private void appendEscapedTag(StringBuilder sb, String tag, String style, ArrayList<String> decorations) {
        StringBuilder opening = new StringBuilder();
        StringBuilder closing = new StringBuilder();
        decorations.forEach(decoration -> {
            this.interpolate(opening, "<", (String)decoration, ">");
            this.interpolate(closing, "</", (String)decoration, ">");
        });
        this.interpolate(sb, "<", style, ">", this.HIGHLIGHTER.escapeTags(tag), "</", style, ">");
    }

    private void interpolate(StringBuilder sb, String ... substrings) {
        for (String substring : substrings) {
            sb.append(substring);
        }
    }

    private String getTokenString(Token token, String root) {
        int start = token.startIndex();
        int end = token.endIndex();
        return root.substring(start, end);
    }

    private static class ShownTagResolver
    implements TagResolver {
        private final TagResolver standard = TagResolver.resolver((TagResolver[])new TagResolver[]{StandardTags.color(), StandardTags.decorations((TextDecoration)TextDecoration.BOLD), StandardTags.decorations((TextDecoration)TextDecoration.ITALIC), StandardTags.decorations((TextDecoration)TextDecoration.UNDERLINED), StandardTags.decorations((TextDecoration)TextDecoration.STRIKETHROUGH), StandardTags.reset(), StandardTags.gradient(), StandardTags.rainbow(), StandardTags.pride(), StandardTags.shadowColor()});

        private ShownTagResolver() {
        }

        @Nullable
        public Tag resolve(@NotNull String name, @NotNull ArgumentQueue arguments, @NotNull Context ctx) throws ParsingException {
            Tag tag = this.standard.resolve(name, arguments, ctx);
            return tag;
        }

        public boolean has(@NotNull String name) {
            return this.standard.has(name);
        }
    }
}

