/*
 * Decompiled with CFR 0.152.
 */
package dev.dfonline.codeclient.dev.menu.devinventory;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import dev.dfonline.codeclient.CodeClient;
import dev.dfonline.codeclient.FileManager;
import dev.dfonline.codeclient.Utility;
import dev.dfonline.codeclient.data.DFItem;
import dev.dfonline.codeclient.hypercube.actiondump.Action;
import dev.dfonline.codeclient.hypercube.actiondump.ActionDump;
import dev.dfonline.codeclient.hypercube.actiondump.CodeBlock;
import dev.dfonline.codeclient.hypercube.actiondump.GameValue;
import dev.dfonline.codeclient.hypercube.actiondump.Potion;
import dev.dfonline.codeclient.hypercube.actiondump.Searchable;
import dev.dfonline.codeclient.hypercube.actiondump.Sound;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2509;
import net.minecraft.class_2512;
import net.minecraft.class_2561;

public class DevInventoryGroup {
    public static final int TAB_WIDTH = 28;
    public static final int TAB_HEIGHT = 28;
    public static final DevInventoryGroup[] GROUPS = new DevInventoryGroup[21];
    public static final DevInventoryGroup PLAYER_EVENT = new DevInventoryGroup("event", "Player Event", class_1802.field_8603.method_7854(), true).useCodeBlock();
    public static final DevInventoryGroup PLAYER_IF = new DevInventoryGroup("if_player", "If Player", class_1802.field_8118.method_7854(), true).useCodeBlock();
    public static final DevInventoryGroup PLAYER_ACTION = new DevInventoryGroup("player_action", "Player Action", class_1802.field_20412.method_7854(), true).useCodeBlock();
    public static final DevInventoryGroup ENTITY_EVENT = new DevInventoryGroup("entity_event", "Entity Event", class_1802.field_8494.method_7854(), true).useCodeBlock();
    public static final DevInventoryGroup ENTITY_IF = new DevInventoryGroup("if_entity", "If Entity", class_1802.field_20390.method_7854(), true).useCodeBlock();
    public static final DevInventoryGroup ENTITY_ACTION = new DevInventoryGroup("entity_action", "Entity Action", class_1802.field_20392.method_7854(), true).useCodeBlock();
    public static final DevInventoryGroup SEARCH = new DevInventoryGroup("search", "Search All", class_1802.field_8251.method_7854(), true).useCodeBlock();
    public static final DevInventoryGroup VAR_SET = new DevInventoryGroup("set_var", "Set Variable", class_1802.field_8773.method_7854(), true).useCodeBlock();
    public static final DevInventoryGroup VAR_IF = new DevInventoryGroup("if_var", "If Variable", class_1802.field_8281.method_7854(), true).useCodeBlock();
    public static final DevInventoryGroup GAME_ACTION = new DevInventoryGroup("game_action", "Game Action", class_1802.field_8328.method_7854(), true).useCodeBlock();
    public static final DevInventoryGroup GAME_IF = new DevInventoryGroup("if_game", "If Game", class_1802.field_20410.method_7854(), true).useCodeBlock();
    public static final DevInventoryGroup CONTROL = new DevInventoryGroup("control", "Control", class_1802.field_8797.method_7854(), true).useCodeBlock();
    public static final DevInventoryGroup SELECT_OBJECT = new DevInventoryGroup("select_obj", "Select Object", class_1802.field_20393.method_7854(), true).useCodeBlock();
    public static final DevInventoryGroup REPEAT = new DevInventoryGroup("repeat", "Repeat", class_1802.field_20404.method_7854(), true).useCodeBlock();
    public static final DevInventoryGroup SOUNDS = new DevInventoryGroup("sound", "Sounds", class_1802.field_8864.method_7854(), false);
    public static final DevInventoryGroup PARTICLES = new DevInventoryGroup("particle", "Particles", class_1802.field_8446.method_7854(), false);
    public static final DevInventoryGroup POTIONS = new DevInventoryGroup("potion", "Potions", class_1802.field_8613.method_7854(), false);
    public static final DevInventoryGroup GAME_VALUES = new DevInventoryGroup("game_value", "Game Values", class_1802.field_8448.method_7854(), false);
    public static final DevInventoryGroup OTHERS = new DevInventoryGroup("others", "Other Items", class_1802.field_8620.method_7854(), false).disableSearch();
    public static final DevInventoryGroup SAVED_TEMPLATES = new DevInventoryGroup("saved_templates", "Saved Templates", class_1802.field_8466.method_7854(), false);
    public static final DevInventoryGroup INVENTORY = new DevInventoryGroup("inventory", "Inventory", class_1802.field_8106.method_7854(), false).disableSearch();
    public static int TOP_HALF = -1;
    private static int global = 0;
    private final int index = global;
    private final String id;
    private final class_1799 icon;
    private final class_2561 name;
    private final boolean topHalf;
    private boolean hasSearchBar = true;
    private ItemsProvider itemsProvider = null;

    public DevInventoryGroup(String id, String name, class_1799 icon, boolean topHalf) {
        this.id = id;
        this.icon = icon;
        this.name = class_2561.method_30163((String)name);
        this.topHalf = topHalf;
        if (!topHalf && TOP_HALF == -1) {
            TOP_HALF = global + 1;
        }
        DevInventoryGroup.GROUPS[this.index] = this;
        ++global;
    }

    private static ArrayList<Searchable> emptyMenu() {
        ArrayList<Searchable> items = new ArrayList<Searchable>();
        for (int i = 0; i < 45; ++i) {
            items.add(new Searchable.StaticSearchable(class_1802.field_8162.method_7854()));
        }
        return items;
    }

    private static ArrayList<Searchable> readTemplates(Path path) {
        return DevInventoryGroup.readTemplates(path, path);
    }

    private static ArrayList<Searchable> readTemplates(Path path, Path root) {
        ArrayList<Searchable> list = new ArrayList<Searchable>();
        try {
            Stream<Path> dir = Files.list(path);
            for (Path file : dir.toList()) {
                if (Files.isDirectory(file, new LinkOption[0])) {
                    list.addAll(DevInventoryGroup.readTemplates(file, root));
                }
                if (!file.getFileName().toString().endsWith(".dft")) continue;
                byte[] data = Files.readAllBytes(file);
                class_1799 template = Utility.makeTemplate(new String(Base64.getEncoder().encode(data)));
                DFItem item = DFItem.of(template);
                item.setName((class_2561)class_2561.method_43473().method_27692(class_124.field_1061).method_27693("Saved Template").method_10852((class_2561)class_2561.method_43470((String)" \u00bb ").method_27695(new class_124[]{class_124.field_1079, class_124.field_1067})).method_27693(String.valueOf(root.relativize(file))));
                list.add(new Searchable.StaticSearchable(item.getItemStack()));
            }
            dir.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return list;
    }

    private DevInventoryGroup disableSearch() {
        this.itemsProvider = null;
        this.hasSearchBar = false;
        return this;
    }

    private DevInventoryGroup setItemsProvider(ItemsProvider itemsProvider) {
        this.itemsProvider = itemsProvider;
        return this;
    }

    public List<Searchable> searchItems(String query) {
        if (this.itemsProvider == null) {
            return null;
        }
        return this.itemsProvider.run(query);
    }

    public class_2561 getName() {
        return this.name;
    }

    public int getIndex() {
        return this.index;
    }

    public class_1799 getIcon() {
        return this.icon;
    }

    public boolean hasSearchBar() {
        return this.hasSearchBar;
    }

    public boolean isTopHalf() {
        return this.topHalf;
    }

    public int getPlace() {
        return this.index;
    }

    public int getColumn() {
        return this.getPlace() % 7;
    }

    public int getRow() {
        return this.getPlace() / 7;
    }

    public int getDisplayX(int originX) {
        return originX + this.getColumn() * 28;
    }

    public int getDisplayY(int originY, int menuHeight) {
        int multiplier = 28 * (this.isTopHalf() ? -1 : 1);
        int y = originY + (this.isTopHalf() ? -32 + this.getRow() * multiplier : menuHeight);
        return y;
    }

    private DevInventoryGroup useCodeBlock() {
        this.itemsProvider = query -> {
            ArrayList<Searchable> items = new ArrayList<Searchable>();
            try {
                if (query == null) {
                    for (Searchable searchable : ActionDump.getActionDump().codeblocks) {
                        if (!((CodeBlock)searchable).identifier.equals(this.id)) continue;
                        items.add(searchable);
                    }
                }
                for (Searchable searchable : ActionDump.getActionDump().actions) {
                    String term;
                    if (!((Action)searchable).getCodeBlock().identifier.equals(this.id) || ((Action)searchable).isInvalid()) continue;
                    if (query == null) {
                        items.add(searchable);
                        continue;
                    }
                    Iterator<String> iterator = ((Action)searchable).getTerms().iterator();
                    if (!iterator.hasNext() || !(term = iterator.next()).toLowerCase().contains(query.toLowerCase())) continue;
                    items.add(searchable);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return items;
        };
        return this;
    }

    private DevInventoryGroup useCategory(Searchable[] categoryValues) {
        this.itemsProvider = query -> {
            ArrayList<Searchable> items = new ArrayList<Searchable>();
            block0: for (Searchable value : categoryValues) {
                if (query == null) {
                    items.add(value);
                    continue;
                }
                for (String term : value.getTerms()) {
                    if (!term.toLowerCase().replaceAll("[_ ]", "").contains(query.toLowerCase())) continue;
                    items.add(value);
                    continue block0;
                }
            }
            return items;
        };
        return this;
    }

    static {
        OTHERS.setItemsProvider(query -> {
            ArrayList<Searchable> items = DevInventoryGroup.emptyMenu();
            try {
                items.set(0, new Searchable.StaticSearchable((class_1799)((Pair)class_1799.field_24671.decode((DynamicOps)CodeClient.MC.field_1687.method_30349().method_57093((DynamicOps)class_2509.field_11560), (Object)class_2512.method_32260((String)"{components:{\"minecraft:attribute_modifiers\":{modifiers:[],show_in_tooltip:0b},\"minecraft:custom_data\":{PublicBukkitValues:{\"hypercube:varitem\":'{\"id\":\"txt\",\"data\":{\"name\":\"string\"}}'}},\"minecraft:custom_model_data\":5000,\"minecraft:custom_name\":'{\"extra\":[{\"bold\":false,\"color\":\"aqua\",\"italic\":false,\"obfuscated\":false,\"strikethrough\":false,\"text\":\"String\",\"underlined\":false}],\"text\":\"\"}',\"minecraft:hide_additional_tooltip\":{},\"minecraft:lore\":['{\"extra\":[{\"bold\":false,\"color\":\"gray\",\"italic\":false,\"obfuscated\":false,\"strikethrough\":false,\"text\":\"A series of characters which\",\"underlined\":false}],\"text\":\"\"}','{\"extra\":[{\"bold\":false,\"color\":\"gray\",\"italic\":false,\"obfuscated\":false,\"strikethrough\":false,\"text\":\"is highly manipulatable.\",\"underlined\":false}],\"text\":\"\"}','{\"extra\":[{\"bold\":false,\"color\":\"gray\",\"italic\":false,\"obfuscated\":false,\"strikethrough\":false,\"text\":\"Recommended for variable\",\"underlined\":false}],\"text\":\"\"}','{\"extra\":[{\"bold\":false,\"color\":\"gray\",\"italic\":false,\"obfuscated\":false,\"strikethrough\":false,\"text\":\"operations.\",\"underlined\":false}],\"text\":\"\"}','\"\"','{\"extra\":[{\"bold\":false,\"color\":\"light_purple\",\"italic\":false,\"obfuscated\":false,\"strikethrough\":false,\"text\":\"How to set:\",\"underlined\":false}],\"text\":\"\"}','{\"extra\":[{\"bold\":false,\"color\":\"gray\",\"italic\":false,\"obfuscated\":false,\"strikethrough\":false,\"text\":\"Type in the chat while\",\"underlined\":false}],\"text\":\"\"}','{\"extra\":[{\"bold\":false,\"color\":\"gray\",\"italic\":false,\"obfuscated\":false,\"strikethrough\":false,\"text\":\"holding this item.\",\"underlined\":false}],\"text\":\"\"}','{\"extra\":[{\"bold\":false,\"color\":\"gray\",\"italic\":false,\"obfuscated\":false,\"strikethrough\":false,\"text\":\"E.g. \\'\",\"underlined\":false},{\"color\":\"white\",\"italic\":false,\"text\":\"Sample text\"},{\"color\":\"gray\",\"italic\":false,\"text\":\"\\'\"}],\"text\":\"\"}']},count:1,id:\"minecraft:string\"}")).getOrThrow()).getFirst()));
                items.set(1, new Searchable.StaticSearchable((class_1799)((Pair)class_1799.field_24671.decode((DynamicOps)CodeClient.MC.field_1687.method_30349().method_57093((DynamicOps)class_2509.field_11560), (Object)class_2512.method_32260((String)"{components:{\"minecraft:attribute_modifiers\":{modifiers:[],show_in_tooltip:0b},\"minecraft:custom_data\":{PublicBukkitValues:{\"hypercube:varitem\":'{\"id\":\"comp\",\"data\":{\"name\":\"text\"}}'}},\"minecraft:custom_model_data\":5000,\"minecraft:custom_name\":'{\"extra\":[{\"bold\":false,\"color\":\"#7FD42A\",\"italic\":false,\"obfuscated\":false,\"strikethrough\":false,\"text\":\"Styled Text\",\"underlined\":false}],\"text\":\"\"}',\"minecraft:hide_additional_tooltip\":{},\"minecraft:lore\":['{\"extra\":[{\"bold\":false,\"color\":\"gray\",\"italic\":false,\"obfuscated\":false,\"strikethrough\":false,\"text\":\"Text with extra formatting via\",\"underlined\":false}],\"text\":\"\"}','{\"extra\":[{\"color\":\"white\",\"italic\":false,\"text\":\"MiniMessage\"},{\"color\":\"gray\",\"italic\":false,\"text\":\" tags such as \"},{\"color\":\"white\",\"italic\":false,\"text\":\"<color>\"},{\"color\":\"gray\",\"italic\":false,\"text\":\".\"}],\"text\":\"\"}','{\"extra\":[{\"bold\":false,\"color\":\"gray\",\"italic\":false,\"obfuscated\":false,\"strikethrough\":false,\"text\":\"Recommended for text displayed\",\"underlined\":false}],\"text\":\"\"}','{\"extra\":[{\"bold\":false,\"color\":\"gray\",\"italic\":false,\"obfuscated\":false,\"strikethrough\":false,\"text\":\"through chat, item names, and others.\",\"underlined\":false}],\"text\":\"\"}','\"\"','{\"extra\":[{\"bold\":false,\"color\":\"light_purple\",\"italic\":false,\"obfuscated\":false,\"strikethrough\":false,\"text\":\"How to set:\",\"underlined\":false}],\"text\":\"\"}','{\"extra\":[{\"bold\":false,\"color\":\"gray\",\"italic\":false,\"obfuscated\":false,\"strikethrough\":false,\"text\":\"Type in the chat while\",\"underlined\":false}],\"text\":\"\"}','{\"extra\":[{\"bold\":false,\"color\":\"gray\",\"italic\":false,\"obfuscated\":false,\"strikethrough\":false,\"text\":\"holding this item.\",\"underlined\":false}],\"text\":\"\"}','{\"extra\":[{\"bold\":false,\"color\":\"gray\",\"italic\":false,\"obfuscated\":false,\"strikethrough\":false,\"text\":\"E.g. \\'\",\"underlined\":false},{\"color\":\"white\",\"italic\":false,\"text\":\"<rainbow>Rainbow text!\"},{\"color\":\"gray\",\"italic\":false,\"text\":\"\\'\"}],\"text\":\"\"}']},count:1,id:\"minecraft:book\"}")).getOrThrow()).getFirst()));
                items.set(2, new Searchable.StaticSearchable((class_1799)((Pair)class_1799.field_24671.decode((DynamicOps)CodeClient.MC.field_1687.method_30349().method_57093((DynamicOps)class_2509.field_11560), (Object)class_2512.method_32260((String)"{components:{\"minecraft:attribute_modifiers\":{modifiers:[],show_in_tooltip:0b},\"minecraft:custom_data\":{PublicBukkitValues:{\"hypercube:varitem\":'{\"id\":\"num\",\"data\":{\"name\":\"0\"}}'}},\"minecraft:custom_model_data\":5000,\"minecraft:custom_name\":'{\"extra\":[{\"bold\":false,\"color\":\"red\",\"italic\":false,\"obfuscated\":false,\"strikethrough\":false,\"text\":\"Number\",\"underlined\":false}],\"text\":\"\"}',\"minecraft:hide_additional_tooltip\":{},\"minecraft:lore\":['{\"extra\":[{\"bold\":false,\"color\":\"gray\",\"italic\":false,\"obfuscated\":false,\"strikethrough\":false,\"text\":\"Represents a number of an\",\"underlined\":false}],\"text\":\"\"}','{\"extra\":[{\"bold\":false,\"color\":\"gray\",\"italic\":false,\"obfuscated\":false,\"strikethrough\":false,\"text\":\"integer or a decimal. It can\",\"underlined\":false}],\"text\":\"\"}','{\"extra\":[{\"bold\":false,\"color\":\"gray\",\"italic\":false,\"obfuscated\":false,\"strikethrough\":false,\"text\":\"have up to 3 decimal places.\",\"underlined\":false}],\"text\":\"\"}','\"\"','{\"extra\":[{\"bold\":false,\"color\":\"light_purple\",\"italic\":false,\"obfuscated\":false,\"strikethrough\":false,\"text\":\"How to set:\",\"underlined\":false}],\"text\":\"\"}','{\"extra\":[{\"bold\":false,\"color\":\"gray\",\"italic\":false,\"obfuscated\":false,\"strikethrough\":false,\"text\":\"Type a number in chat while\",\"underlined\":false}],\"text\":\"\"}','{\"extra\":[{\"bold\":false,\"color\":\"gray\",\"italic\":false,\"obfuscated\":false,\"strikethrough\":false,\"text\":\"holding this item.\",\"underlined\":false}],\"text\":\"\"}','{\"extra\":[{\"bold\":false,\"color\":\"gray\",\"italic\":false,\"obfuscated\":false,\"strikethrough\":false,\"text\":\"E.g. \",\"underlined\":false},{\"color\":\"white\",\"italic\":false,\"text\":\"4\"},{\"color\":\"gray\",\"italic\":false,\"text\":\" or \"},{\"color\":\"white\",\"italic\":false,\"text\":\"1.25\"}],\"text\":\"\"}']},count:1,id:\"minecraft:slime_ball\"}")).getOrThrow()).getFirst()));
                items.set(3, new Searchable.StaticSearchable((class_1799)((Pair)class_1799.field_24671.decode((DynamicOps)CodeClient.MC.field_1687.method_30349().method_57093((DynamicOps)class_2509.field_11560), (Object)class_2512.method_32260((String)"{components:{\"minecraft:attribute_modifiers\":{modifiers:[],show_in_tooltip:0b},\"minecraft:custom_data\":{PublicBukkitValues:{\"hypercube:varitem\":'{\"id\":\"loc\",\"data\":{\"isBlock\":false,\"loc\":{\"x\":0.0,\"y\":0.0,\"z\":0.0,\"pitch\":0.0,\"yaw\":0.0}}}'}},\"minecraft:custom_model_data\":5000,\"minecraft:custom_name\":'{\"extra\":[{\"bold\":false,\"color\":\"green\",\"italic\":false,\"obfuscated\":false,\"strikethrough\":false,\"text\":\"Location\",\"underlined\":false}],\"text\":\"\"}',\"minecraft:hide_additional_tooltip\":{},\"minecraft:lore\":['{\"extra\":[{\"bold\":false,\"color\":\"gray\",\"italic\":false,\"obfuscated\":false,\"strikethrough\":false,\"text\":\"Represents a location in the plot.\",\"underlined\":false}],\"text\":\"\"}','{\"extra\":[{\"bold\":false,\"color\":\"gray\",\"italic\":false,\"obfuscated\":false,\"strikethrough\":false,\"text\":\"[0,0,0] points to the north-west\",\"underlined\":false}],\"text\":\"\"}','{\"extra\":[{\"bold\":false,\"color\":\"gray\",\"italic\":false,\"obfuscated\":false,\"strikethrough\":false,\"text\":\"bottom corner of the plot.\",\"underlined\":false}],\"text\":\"\"}','\"\"','{\"extra\":[{\"bold\":false,\"color\":\"light_purple\",\"italic\":false,\"obfuscated\":false,\"strikethrough\":false,\"text\":\"How to set:\",\"underlined\":false}],\"text\":\"\"}','{\"extra\":[{\"bold\":false,\"color\":\"gray\",\"italic\":false,\"obfuscated\":false,\"strikethrough\":false,\"text\":\"Right-click this item to set it\",\"underlined\":false}],\"text\":\"\"}','{\"extra\":[{\"bold\":false,\"color\":\"gray\",\"italic\":false,\"obfuscated\":false,\"strikethrough\":false,\"text\":\"to your current location.\",\"underlined\":false}],\"text\":\"\"}','{\"extra\":[{\"bold\":false,\"color\":\"gray\",\"italic\":false,\"obfuscated\":false,\"strikethrough\":false,\"text\":\"Left-click to set it to a block.\",\"underlined\":false}],\"text\":\"\"}','{\"extra\":[{\"bold\":false,\"color\":\"gray\",\"italic\":false,\"obfuscated\":false,\"strikethrough\":false,\"text\":\"Shift left-click to teleport to it.\",\"underlined\":false}],\"text\":\"\"}']},count:1,id:\"minecraft:paper\"}")).getOrThrow()).getFirst()));
                items.set(4, new Searchable.StaticSearchable((class_1799)((Pair)class_1799.field_24671.decode((DynamicOps)CodeClient.MC.field_1687.method_30349().method_57093((DynamicOps)class_2509.field_11560), (Object)class_2512.method_32260((String)"{components:{\"minecraft:attribute_modifiers\":{modifiers:[],show_in_tooltip:0b},\"minecraft:custom_data\":{PublicBukkitValues:{\"hypercube:varitem\":'{\"id\":\"vec\",\"data\":{\"x\":0.0,\"y\":0.0,\"z\":0.0}}'}},\"minecraft:custom_model_data\":5000,\"minecraft:custom_name\":'{\"extra\":[{\"bold\":false,\"color\":\"#2AFFAA\",\"italic\":false,\"obfuscated\":false,\"strikethrough\":false,\"text\":\"Vector\",\"underlined\":false}],\"text\":\"\"}',\"minecraft:hide_additional_tooltip\":{},\"minecraft:lore\":['{\"extra\":[{\"bold\":false,\"color\":\"gray\",\"italic\":false,\"obfuscated\":false,\"strikethrough\":false,\"text\":\"A vector consists of X, Y and\",\"underlined\":false}],\"text\":\"\"}','{\"extra\":[{\"bold\":false,\"color\":\"gray\",\"italic\":false,\"obfuscated\":false,\"strikethrough\":false,\"text\":\"Z values. Used for multiple\",\"underlined\":false}],\"text\":\"\"}','{\"extra\":[{\"bold\":false,\"color\":\"gray\",\"italic\":false,\"obfuscated\":false,\"strikethrough\":false,\"text\":\"purposes such as representing\",\"underlined\":false}],\"text\":\"\"}','{\"extra\":[{\"bold\":false,\"color\":\"gray\",\"italic\":false,\"obfuscated\":false,\"strikethrough\":false,\"text\":\"a direction, motion or an offset.\",\"underlined\":false}],\"text\":\"\"}','\"\"','{\"extra\":[{\"bold\":false,\"color\":\"light_purple\",\"italic\":false,\"obfuscated\":false,\"strikethrough\":false,\"text\":\"How to set:\",\"underlined\":false}],\"text\":\"\"}','{\"extra\":[{\"bold\":false,\"color\":\"gray\",\"italic\":false,\"obfuscated\":false,\"strikethrough\":false,\"text\":\"Use the /vector command or\",\"underlined\":false}],\"text\":\"\"}','{\"extra\":[{\"bold\":false,\"color\":\"gray\",\"italic\":false,\"obfuscated\":false,\"strikethrough\":false,\"text\":\"type \",\"underlined\":false},{\"color\":\"aqua\",\"italic\":false,\"text\":\"\\\\\"<x> <y> <z>\\\\\"\"},{\"color\":\"gray\",\"italic\":false,\"text\":\" to set the\"}],\"text\":\"\"}','{\"extra\":[{\"bold\":false,\"color\":\"gray\",\"italic\":false,\"obfuscated\":false,\"strikethrough\":false,\"text\":\"components. Left-click to\",\"underlined\":false}],\"text\":\"\"}','{\"extra\":[{\"bold\":false,\"color\":\"gray\",\"italic\":false,\"obfuscated\":false,\"strikethrough\":false,\"text\":\"preview it.\",\"underlined\":false}],\"text\":\"\"}']},count:1,id:\"minecraft:prismarine_shard\"}")).getOrThrow()).getFirst()));
                items.set(5, new Searchable.StaticSearchable((class_1799)((Pair)class_1799.field_24671.decode((DynamicOps)CodeClient.MC.field_1687.method_30349().method_57093((DynamicOps)class_2509.field_11560), (Object)class_2512.method_32260((String)"{components:{\"minecraft:attribute_modifiers\":{modifiers:[],show_in_tooltip:0b},\"minecraft:custom_data\":{PublicBukkitValues:{\"hypercube:varitem\":'{\"id\":\"snd\",\"data\":{\"pitch\":1.0,\"vol\":2.0,\"sound\":\"Pling\"}}'}},\"minecraft:custom_model_data\":5000,\"minecraft:custom_name\":'{\"extra\":[{\"bold\":false,\"color\":\"blue\",\"italic\":false,\"obfuscated\":false,\"strikethrough\":false,\"text\":\"Sound\",\"underlined\":false}],\"text\":\"\"}',\"minecraft:hide_additional_tooltip\":{},\"minecraft:lore\":['{\"extra\":[{\"bold\":false,\"color\":\"gray\",\"italic\":false,\"obfuscated\":false,\"strikethrough\":false,\"text\":\"Represents a Minecraft sound or a\",\"underlined\":false}],\"text\":\"\"}','{\"extra\":[{\"bold\":false,\"color\":\"gray\",\"italic\":false,\"obfuscated\":false,\"strikethrough\":false,\"text\":\"custom sound from resource pack.\",\"underlined\":false}],\"text\":\"\"}','\"\"','{\"extra\":[{\"bold\":false,\"color\":\"light_purple\",\"italic\":false,\"obfuscated\":false,\"strikethrough\":false,\"text\":\"How to set:\",\"underlined\":false}],\"text\":\"\"}','{\"extra\":[{\"bold\":false,\"color\":\"gray\",\"italic\":false,\"obfuscated\":false,\"strikethrough\":false,\"text\":\"Right-click this item to select\",\"underlined\":false}],\"text\":\"\"}','{\"extra\":[{\"bold\":false,\"color\":\"gray\",\"italic\":false,\"obfuscated\":false,\"strikethrough\":false,\"text\":\"a sound effect.\",\"underlined\":false}],\"text\":\"\"}','{\"extra\":[{\"bold\":false,\"color\":\"gray\",\"italic\":false,\"obfuscated\":false,\"strikethrough\":false,\"text\":\"Shift right-click to select\",\"underlined\":false}],\"text\":\"\"}','{\"extra\":[{\"bold\":false,\"color\":\"gray\",\"italic\":false,\"obfuscated\":false,\"strikethrough\":false,\"text\":\"a variant of the sound.\",\"underlined\":false}],\"text\":\"\"}','{\"extra\":[{\"bold\":false,\"color\":\"gray\",\"italic\":false,\"obfuscated\":false,\"strikethrough\":false,\"text\":\"To add a pitch & volume, type\",\"underlined\":false}],\"text\":\"\"}','{\"extra\":[{\"bold\":false,\"color\":\"gray\",\"italic\":false,\"obfuscated\":false,\"strikethrough\":false,\"text\":\"them in one chat line, in order.\",\"underlined\":false}],\"text\":\"\"}','{\"extra\":[{\"bold\":false,\"color\":\"gray\",\"italic\":false,\"obfuscated\":false,\"strikethrough\":false,\"text\":\"Left-click to preview it.\",\"underlined\":false}],\"text\":\"\"}']},count:1,id:\"minecraft:nautilus_shell\"}")).getOrThrow()).getFirst()));
                items.set(6, new Searchable.StaticSearchable((class_1799)((Pair)class_1799.field_24671.decode((DynamicOps)CodeClient.MC.field_1687.method_30349().method_57093((DynamicOps)class_2509.field_11560), (Object)class_2512.method_32260((String)"{components:{\"minecraft:attribute_modifiers\":{modifiers:[],show_in_tooltip:0b},\"minecraft:custom_data\":{PublicBukkitValues:{\"hypercube:varitem\":'{\"id\":\"part\",\"data\":{\"particle\":\"Cloud\",\"cluster\":{\"amount\":1,\"horizontal\":0.0,\"vertical\":0.0},\"data\":{\"x\":1.0,\"y\":0.0,\"z\":0.0,\"motionVariation\":100}}}'}},\"minecraft:custom_model_data\":5000,\"minecraft:custom_name\":'{\"extra\":[{\"bold\":false,\"color\":\"#AA55FF\",\"italic\":false,\"obfuscated\":false,\"strikethrough\":false,\"text\":\"Particle\",\"underlined\":false}],\"text\":\"\"}',\"minecraft:hide_additional_tooltip\":{},\"minecraft:lore\":['{\"extra\":[{\"bold\":false,\"color\":\"gray\",\"italic\":false,\"obfuscated\":false,\"strikethrough\":false,\"text\":\"Represents a particle effect with\",\"underlined\":false}],\"text\":\"\"}','{\"extra\":[{\"bold\":false,\"color\":\"gray\",\"italic\":false,\"obfuscated\":false,\"strikethrough\":false,\"text\":\"customizable parameters.\",\"underlined\":false}],\"text\":\"\"}','\"\"','{\"extra\":[{\"bold\":false,\"color\":\"light_purple\",\"italic\":false,\"obfuscated\":false,\"strikethrough\":false,\"text\":\"How to set:\",\"underlined\":false}],\"text\":\"\"}','{\"extra\":[{\"bold\":false,\"color\":\"gray\",\"italic\":false,\"obfuscated\":false,\"strikethrough\":false,\"text\":\"Right-click this item to select\",\"underlined\":false}],\"text\":\"\"}','{\"extra\":[{\"bold\":false,\"color\":\"gray\",\"italic\":false,\"obfuscated\":false,\"strikethrough\":false,\"text\":\"a particle effect.\",\"underlined\":false}],\"text\":\"\"}','{\"extra\":[{\"bold\":false,\"color\":\"gray\",\"italic\":false,\"obfuscated\":false,\"strikethrough\":false,\"text\":\"Use the /particle command\",\"underlined\":false}],\"text\":\"\"}','{\"extra\":[{\"bold\":false,\"color\":\"gray\",\"italic\":false,\"obfuscated\":false,\"strikethrough\":false,\"text\":\"to change its parameters.\",\"underlined\":false}],\"text\":\"\"}','{\"extra\":[{\"bold\":false,\"color\":\"gray\",\"italic\":false,\"obfuscated\":false,\"strikethrough\":false,\"text\":\"Left-click to preview it.\",\"underlined\":false}],\"text\":\"\"}']},count:1,id:\"minecraft:white_dye\"}")).getOrThrow()).getFirst()));
                items.set(9, new Searchable.StaticSearchable((class_1799)((Pair)class_1799.field_24671.decode((DynamicOps)CodeClient.MC.field_1687.method_30349().method_57093((DynamicOps)class_2509.field_11560), (Object)class_2512.method_32260((String)"{components:{\"minecraft:attribute_modifiers\":{modifiers:[],show_in_tooltip:0b},\"minecraft:custom_data\":{PublicBukkitValues:{\"hypercube:varitem\":'{\"id\":\"pot\",\"data\":{\"pot\":\"Speed\",\"dur\":1000000,\"amp\":0}}'}},\"minecraft:custom_model_data\":5000,\"minecraft:custom_name\":'{\"extra\":[{\"bold\":false,\"color\":\"#FF557F\",\"italic\":false,\"obfuscated\":false,\"strikethrough\":false,\"text\":\"Potion Effect\",\"underlined\":false}],\"text\":\"\"}',\"minecraft:hide_additional_tooltip\":{},\"minecraft:lore\":['{\"extra\":[{\"bold\":false,\"color\":\"gray\",\"italic\":false,\"obfuscated\":false,\"strikethrough\":false,\"text\":\"Represents a potion effect with\",\"underlined\":false}],\"text\":\"\"}','{\"extra\":[{\"bold\":false,\"color\":\"gray\",\"italic\":false,\"obfuscated\":false,\"strikethrough\":false,\"text\":\"custom amplifier and duration.\",\"underlined\":false}],\"text\":\"\"}','\"\"','{\"extra\":[{\"bold\":false,\"color\":\"light_purple\",\"italic\":false,\"obfuscated\":false,\"strikethrough\":false,\"text\":\"How to set:\",\"underlined\":false}],\"text\":\"\"}','{\"extra\":[{\"bold\":false,\"color\":\"gray\",\"italic\":false,\"obfuscated\":false,\"strikethrough\":false,\"text\":\"Right-click this item to select\",\"underlined\":false}],\"text\":\"\"}','{\"extra\":[{\"bold\":false,\"color\":\"gray\",\"italic\":false,\"obfuscated\":false,\"strikethrough\":false,\"text\":\"a potion effect.\",\"underlined\":false}],\"text\":\"\"}','{\"extra\":[{\"bold\":false,\"color\":\"gray\",\"italic\":false,\"obfuscated\":false,\"strikethrough\":false,\"text\":\"Use the /potion command or\",\"underlined\":false}],\"text\":\"\"}','{\"extra\":[{\"bold\":false,\"color\":\"gray\",\"italic\":false,\"obfuscated\":false,\"strikethrough\":false,\"text\":\"type \",\"underlined\":false},{\"color\":\"aqua\",\"italic\":false,\"text\":\"\\\\\"<amplifier> [duration]\\\\\"\"},{\"color\":\"gray\",\"italic\":false,\"text\":\"\"}],\"text\":\"\"}','{\"extra\":[{\"bold\":false,\"color\":\"gray\",\"italic\":false,\"obfuscated\":false,\"strikethrough\":false,\"text\":\"to set its options. Left-click\",\"underlined\":false}],\"text\":\"\"}','{\"extra\":[{\"bold\":false,\"color\":\"gray\",\"italic\":false,\"obfuscated\":false,\"strikethrough\":false,\"text\":\"to preview it.\",\"underlined\":false}],\"text\":\"\"}']},count:1,id:\"minecraft:dragon_breath\"}")).getOrThrow()).getFirst()));
                items.set(10, new Searchable.StaticSearchable((class_1799)((Pair)class_1799.field_24671.decode((DynamicOps)CodeClient.MC.field_1687.method_30349().method_57093((DynamicOps)class_2509.field_11560), (Object)class_2512.method_32260((String)"{components:{\"minecraft:attribute_modifiers\":{modifiers:[],show_in_tooltip:0b},\"minecraft:custom_data\":{PublicBukkitValues:{\"hypercube:varitem\":'{\"id\":\"var\",\"data\":{\"name\":\"\u00a7eVariable\",\"scope\":\"unsaved\"}}'}},\"minecraft:custom_model_data\":5000,\"minecraft:custom_name\":'{\"extra\":[{\"bold\":false,\"color\":\"yellow\",\"italic\":false,\"obfuscated\":false,\"strikethrough\":false,\"text\":\"Variable\",\"underlined\":false}],\"text\":\"\"}',\"minecraft:hide_additional_tooltip\":{},\"minecraft:lore\":['{\"extra\":[{\"bold\":false,\"color\":\"gray\",\"italic\":false,\"obfuscated\":false,\"strikethrough\":false,\"text\":\"Variables can store values inside.\",\"underlined\":false}],\"text\":\"\"}','{\"extra\":[{\"bold\":false,\"color\":\"gray\",\"italic\":false,\"obfuscated\":false,\"strikethrough\":false,\"text\":\"Give a name to your variable, and\",\"underlined\":false}],\"text\":\"\"}','{\"extra\":[{\"bold\":false,\"color\":\"gray\",\"italic\":false,\"obfuscated\":false,\"strikethrough\":false,\"text\":\"use \",\"underlined\":false},{\"color\":\"white\",\"italic\":false,\"text\":\"Set Variable\"},{\"color\":\"gray\",\"italic\":false,\"text\":\" to set its value.\"}],\"text\":\"\"}','\"\"','{\"extra\":[{\"bold\":false,\"color\":\"light_purple\",\"italic\":false,\"obfuscated\":false,\"strikethrough\":false,\"text\":\"How to set:\",\"underlined\":false}],\"text\":\"\"}','{\"extra\":[{\"bold\":false,\"color\":\"gray\",\"italic\":false,\"obfuscated\":false,\"strikethrough\":false,\"text\":\"Type a variable name in chat\",\"underlined\":false}],\"text\":\"\"}','{\"extra\":[{\"bold\":false,\"color\":\"gray\",\"italic\":false,\"obfuscated\":false,\"strikethrough\":false,\"text\":\"while holding this item.\",\"underlined\":false}],\"text\":\"\"}','{\"extra\":[{\"bold\":false,\"color\":\"gray\",\"italic\":false,\"obfuscated\":false,\"strikethrough\":false,\"text\":\"Shift right-click for options.\",\"underlined\":false}],\"text\":\"\"}']},count:1,id:\"minecraft:magma_cream\"}")).getOrThrow()).getFirst()));
                items.set(11, new Searchable.StaticSearchable((class_1799)((Pair)class_1799.field_24671.decode((DynamicOps)CodeClient.MC.field_1687.method_30349().method_57093((DynamicOps)class_2509.field_11560), (Object)class_2512.method_32260((String)"{components:{\"minecraft:attribute_modifiers\":{modifiers:[],show_in_tooltip:0b},\"minecraft:custom_data\":{PublicBukkitValues:{\"hypercube:varitem\":'{\"id\":\"g_val\",\"data\":{\"type\":\"Location\",\"target\":\"Default\"}}'}},\"minecraft:custom_model_data\":5000,\"minecraft:custom_name\":'{\"extra\":[{\"bold\":false,\"color\":\"#FFD47F\",\"italic\":false,\"obfuscated\":false,\"strikethrough\":false,\"text\":\"Game Value\",\"underlined\":false}],\"text\":\"\"}',\"minecraft:hide_additional_tooltip\":{},\"minecraft:lore\":['{\"extra\":[{\"bold\":false,\"color\":\"gray\",\"italic\":false,\"obfuscated\":false,\"strikethrough\":false,\"text\":\"An automatically set value based\",\"underlined\":false}],\"text\":\"\"}','{\"extra\":[{\"bold\":false,\"color\":\"gray\",\"italic\":false,\"obfuscated\":false,\"strikethrough\":false,\"text\":\"on the game\\'s current conditions\",\"underlined\":false}],\"text\":\"\"}','{\"extra\":[{\"bold\":false,\"color\":\"gray\",\"italic\":false,\"obfuscated\":false,\"strikethrough\":false,\"text\":\"(e.g. a player\\'s location).\",\"underlined\":false}],\"text\":\"\"}','\"\"','{\"extra\":[{\"bold\":false,\"color\":\"light_purple\",\"italic\":false,\"obfuscated\":false,\"strikethrough\":false,\"text\":\"How to set:\",\"underlined\":false}],\"text\":\"\"}','{\"extra\":[{\"bold\":false,\"color\":\"gray\",\"italic\":false,\"obfuscated\":false,\"strikethrough\":false,\"text\":\"Right-click to select a game\",\"underlined\":false}],\"text\":\"\"}','{\"extra\":[{\"bold\":false,\"color\":\"gray\",\"italic\":false,\"obfuscated\":false,\"strikethrough\":false,\"text\":\"value and its target.\",\"underlined\":false}],\"text\":\"\"}']},count:1,id:\"minecraft:name_tag\"}")).getOrThrow()).getFirst()));
                items.set(12, new Searchable.StaticSearchable((class_1799)((Pair)class_1799.field_24671.decode((DynamicOps)CodeClient.MC.field_1687.method_30349().method_57093((DynamicOps)class_2509.field_11560), (Object)class_2512.method_32260((String)"{components:{\"minecraft:attribute_modifiers\":{modifiers:[],show_in_tooltip:0b},\"minecraft:custom_data\":{PublicBukkitValues:{\"hypercube:varitem\":'{\"id\":\"pn_el\",\"data\":{\"name\":\"name\",\"type\":\"any\",\"plural\":false,\"optional\":false}}'}},\"minecraft:custom_model_data\":5000,\"minecraft:custom_name\":'{\"extra\":[{\"bold\":false,\"color\":\"#AAFFAA\",\"italic\":false,\"obfuscated\":false,\"strikethrough\":false,\"text\":\"Parameter\",\"underlined\":false}],\"text\":\"\"}',\"minecraft:hide_additional_tooltip\":{},\"minecraft:lore\":['{\"extra\":[{\"bold\":false,\"color\":\"gray\",\"italic\":false,\"obfuscated\":false,\"strikethrough\":false,\"text\":\"A parameter to put in the\",\"underlined\":false}],\"text\":\"\"}','{\"extra\":[{\"bold\":false,\"color\":\"gray\",\"italic\":false,\"obfuscated\":false,\"strikethrough\":false,\"text\":\"code chest of a \",\"underlined\":false},{\"color\":\"aqua\",\"italic\":false,\"text\":\"function\"},{\"color\":\"gray\",\"italic\":false,\"text\":\".\"}],\"text\":\"\"}','\"\"','{\"extra\":[{\"bold\":false,\"color\":\"light_purple\",\"italic\":false,\"obfuscated\":false,\"strikethrough\":false,\"text\":\"How to set:\",\"underlined\":false}],\"text\":\"\"}','{\"extra\":[{\"bold\":false,\"color\":\"gray\",\"italic\":false,\"obfuscated\":false,\"strikethrough\":false,\"text\":\"Type in chat to edit name.\",\"underlined\":false}],\"text\":\"\"}','{\"extra\":[{\"bold\":false,\"color\":\"gray\",\"italic\":false,\"obfuscated\":false,\"strikethrough\":false,\"text\":\"Right-click to open the editor.\",\"underlined\":false}],\"text\":\"\"}']},count:1,id:\"minecraft:ender_eye\"}")).getOrThrow()).getFirst()));
                int i = 0;
                for (CodeBlock codeblock : ActionDump.getActionDump().codeblocks) {
                    items.set(27 + i, codeblock);
                    ++i;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return items;
        });
        try {
            ActionDump actionDump = ActionDump.getActionDump();
            GAME_VALUES.useCategory(actionDump.gameValues);
            SOUNDS.useCategory(actionDump.sounds);
            POTIONS.useCategory(actionDump.potions);
            PARTICLES.useCategory(actionDump.particles);
            SAVED_TEMPLATES.setItemsProvider(query -> {
                ArrayList<Searchable> items = new ArrayList<Searchable>();
                if (query == null) {
                    query = "";
                }
                query = query.toLowerCase();
                block0: for (Searchable template : DevInventoryGroup.readTemplates(FileManager.templatesPath())) {
                    for (String term : template.getTerms()) {
                        if (!term.toLowerCase().contains(query)) continue;
                        items.add(template);
                        continue block0;
                    }
                }
                return items;
            });
            SEARCH.setItemsProvider(query -> {
                ArrayList<Searchable> items = new ArrayList<Searchable>();
                query = query == null ? "" : query.toLowerCase();
                block0: for (Action action : actionDump.actions) {
                    if (action.isInvalid()) continue;
                    for (String term : action.getTerms()) {
                        if (!term.toLowerCase().contains(query)) continue;
                        items.add(action);
                        continue block0;
                    }
                }
                block2: for (Searchable searchable : actionDump.gameValues) {
                    for (String term : ((GameValue)searchable).getTerms()) {
                        if (!term.toLowerCase().contains(query)) continue;
                        items.add(searchable);
                        continue block2;
                    }
                }
                block4: for (Searchable searchable : actionDump.sounds) {
                    for (String term : ((Sound)searchable).getTerms()) {
                        if (!term.toLowerCase().contains(query)) continue;
                        items.add(searchable);
                        continue block4;
                    }
                }
                block6: for (Searchable searchable : actionDump.potions) {
                    for (String term : ((Potion)searchable).getTerms()) {
                        if (!term.toLowerCase().contains(query)) continue;
                        items.add(searchable);
                        continue block6;
                    }
                }
                return items;
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static interface ItemsProvider {
        public List<Searchable> run(String var1);
    }
}

