/*
 * Decompiled with CFR 0.152.
 */
package dev.dfonline.codeclient.dev.menu.devinventory;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonParseException;
import dev.dfonline.codeclient.ChatType;
import dev.dfonline.codeclient.CodeClient;
import dev.dfonline.codeclient.Utility;
import dev.dfonline.codeclient.config.Config;
import dev.dfonline.codeclient.config.KeyBinds;
import dev.dfonline.codeclient.dev.menu.devinventory.DevInventoryGroup;
import dev.dfonline.codeclient.hypercube.actiondump.ActionDump;
import dev.dfonline.codeclient.hypercube.actiondump.Searchable;
import java.io.IOException;
import java.net.URI;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_10799;
import net.minecraft.class_124;
import net.minecraft.class_1263;
import net.minecraft.class_1268;
import net.minecraft.class_1277;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1712;
import net.minecraft.class_1713;
import net.minecraft.class_1723;
import net.minecraft.class_1735;
import net.minecraft.class_1761;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_465;
import net.minecraft.class_478;
import net.minecraft.class_481;
import net.minecraft.class_490;
import net.minecraft.class_5244;
import net.minecraft.class_746;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public class DevInventoryScreen
extends class_465<class_481.class_483> {
    static final class_1277 Inventory = new class_1277(45);
    private static final class_2960 TEXTURE = CodeClient.getId("textures/gui/container/dev_inventory/tabs.png");
    private static final class_2561 DELETE_ITEM_SLOT_TEXT = class_2561.method_43471((String)"inventory.binSlot");
    private static int selectedTab;
    private double scrollPosition;
    private int scrollHeight = 0;
    private class_342 searchBox;
    @Nullable
    private List<class_1735> survivalInventorySwapList;
    private List<Searchable> searchResults;
    @Nullable
    private class_1735 deleteItemSlot;
    private class_478 listener;
    private boolean ignoreNextKey = false;
    private boolean scrolling = false;

    public DevInventoryScreen(class_746 player) {
        super((class_1703)new class_481.class_483((class_1657)player), player.method_31548(), class_5244.field_39003);
        player.field_7512 = this.field_2797;
        this.field_2779 = 136;
        this.field_2792 = 195;
    }

    public void method_37432() {
        super.method_37432();
    }

    protected void method_2383(@Nullable class_1735 slot, int slotId, int button, class_1713 actionType) {
        if (slot == null) {
            return;
        }
        this.searchBox.method_1872(false);
        this.searchBox.method_1884(0);
        if (slot == this.deleteItemSlot) {
            ((class_481.class_483)this.field_2797).method_34254(class_1799.field_8037);
            return;
        }
        if (slot.field_7871 instanceof class_1277 && actionType == class_1713.field_7790) {
            if (((class_481.class_483)this.field_2797).method_34255().method_7909().equals(class_1802.field_8162)) {
                ((class_481.class_483)this.field_2797).method_34254(slot.method_7677());
            } else {
                ((class_481.class_483)this.field_2797).method_34254(class_1802.field_8162.method_7854());
            }
        }
        if (slot.field_7871 instanceof class_1661) {
            class_1799 slotStack = slot.method_7677();
            class_1799 cursorItem = ((class_481.class_483)this.field_2797).method_34255();
            slot.method_53512(cursorItem);
            ((class_481.class_483)this.field_2797).method_34254(slotStack);
            ((class_481.class_483)this.field_2797).method_34252();
            this.listener.method_7635(this.field_2797, slot.field_7874 - 9, slot.method_7677());
        }
    }

    protected void method_25426() {
        super.method_25426();
        if (this.field_22787 == null || this.field_22787.field_1724 == null) {
            return;
        }
        try {
            ActionDump.getActionDump();
        }
        catch (JsonParseException | IOException e) {
            CodeClient.LOGGER.error(e.getMessage());
            Utility.sendMessage((class_2561)class_2561.method_43469((String)"codeclient.parse_db", (Object[])new Object[]{class_2561.method_43470((String)"https://github.com/DFOnline/CodeClient/wiki/actiondump").method_27695(new class_124[]{class_124.field_1075, class_124.field_1073})}).method_10862(class_2583.field_24360.method_10958((class_2558)new class_2558.class_10608(URI.create("https://github.com/DFOnline/CodeClient/wiki/actiondump")))), ChatType.FAIL);
        }
        class_327 textRenderer = this.field_22793;
        Objects.requireNonNull(this.field_22793);
        this.searchBox = new class_342(textRenderer, this.field_2776 + 82, this.field_2800 + 6, 80, 9, (class_2561)class_2561.method_43471((String)"itemGroup.search"));
        this.searchBox.method_1880(100);
        this.searchBox.method_1858(false);
        this.searchBox.method_1862(true);
        this.searchBox.method_1868(0xFFFFFF);
        this.method_25429((class_364)this.searchBox);
        this.setSelectedTab(6);
        if (Config.getConfig().FocusSearch) {
            this.searchBox.method_25365(true);
        }
        this.searchBox.method_1872(false);
        this.searchBox.method_1884(0);
        this.field_22787.field_1724.field_7498.method_7603((class_1712)this.listener);
        this.listener = new class_478(this.field_22787);
        this.field_22787.field_1724.field_7498.method_7596((class_1712)this.listener);
    }

    public void method_25432() {
        super.method_25432();
        if (this.field_22787 != null && this.field_22787.field_1724 != null && this.field_22787.field_1724.method_31548() != null) {
            this.field_22787.field_1724.field_7498.method_7603((class_1712)this.listener);
        }
    }

    protected void method_2388(class_332 context, int mouseX, int mouseY) {
        DevInventoryGroup itemGroup = DevInventoryGroup.GROUPS[selectedTab];
        if (itemGroup != DevInventoryGroup.INVENTORY) {
            context.method_51439(this.field_22793, itemGroup.getName(), 8, 6, 0x404040, false);
        }
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (button == 0) {
            Integer clicked = this.getGroupFromMouse(mouseX, mouseY);
            if (clicked != null && clicked != selectedTab) {
                this.setSelectedTab(clicked);
            }
            if (this.isClickInScrollbar(mouseX, mouseY)) {
                this.scrolling = true;
            }
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        if (button == 0) {
            this.scrolling = false;
        }
        return super.method_25406(mouseX, mouseY, button);
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (this.scrolling) {
            int scrollOriginY = this.field_2800 + 18;
            int scrollEnd = scrollOriginY + 112;
            double percentThrough = class_3532.method_15363((float)(((float)mouseY - (float)scrollOriginY - 7.5f) / ((float)(scrollEnd - scrollOriginY) - 15.0f)), (float)0.0f, (float)1.0f);
            this.scrollPosition = (double)this.scrollHeight / 9.0 * percentThrough;
            this.scroll();
        }
        return super.method_25403(mouseX, mouseY, button, deltaX, deltaY);
    }

    private Integer getGroupFromMouse(double mouseX, double mouseY) {
        double x = mouseX - (double)this.field_2776;
        double y = mouseY - (double)this.field_2800;
        DevInventoryGroup[] groups = DevInventoryGroup.GROUPS;
        for (int i = 0; i < groups.length; ++i) {
            DevInventoryGroup itemGroup = groups[i];
            if (!this.isClickInTab(itemGroup, x, y)) continue;
            return i;
        }
        return null;
    }

    private void setSelectedTab(int tab) {
        this.searchBox.method_1852("");
        DevInventoryGroup group = DevInventoryGroup.GROUPS[tab];
        this.searchBox.field_22763 = group.hasSearchBar();
        selectedTab = tab;
        if (this.field_22787 == null || this.field_22787.field_1724 == null) {
            return;
        }
        if (group == DevInventoryGroup.INVENTORY && this.survivalInventorySwapList == null) {
            class_1723 playerScreenHandler = this.field_22787.field_1724.field_7498;
            this.survivalInventorySwapList = ImmutableList.copyOf((Collection)((class_481.class_483)this.field_2797).field_7761);
            ((class_481.class_483)this.field_2797).field_7761.clear();
            for (class_1735 slot : this.survivalInventorySwapList) {
                if (!(slot.field_7871 instanceof class_1661)) continue;
                ((class_481.class_483)this.field_2797).field_7761.add((Object)slot);
            }
            this.deleteItemSlot = new class_1735((class_1263)Inventory, 0, 173, 112);
            ((class_481.class_483)this.field_2797).field_7761.add((Object)this.deleteItemSlot);
            int slotSize = 18;
            for (int i = 0; i < 27 && i < playerScreenHandler.field_7761.size(); ++i) {
                int slotIndex = i + 9;
                int x = 9 + slotIndex % 9 * slotSize;
                int y = 36 + slotIndex / 9 * slotSize;
                class_1735 slot = new class_1735(((class_1735)playerScreenHandler.field_7761.get((int)slotIndex)).field_7871, slotIndex, x, y);
                ((class_481.class_483)this.field_2797).field_7761.add((Object)slot);
            }
            return;
        }
        if (this.survivalInventorySwapList != null) {
            ((class_481.class_483)this.field_2797).field_7761.clear();
            ((class_481.class_483)this.field_2797).field_7761.addAll(this.survivalInventorySwapList);
            this.survivalInventorySwapList = null;
        }
        this.scrollPosition = 0.0;
        this.populate();
    }

    private void scroll() {
        if (this.searchResults == null) {
            return;
        }
        this.scrollHeight = Math.max(0, (int)Math.ceil((double)(this.searchResults.size() - 45) / 9.0) * 9);
        for (int i = 0; i < 45; ++i) {
            int value = i + (int)this.scrollPosition * 9;
            if (value < this.searchResults.size()) {
                ((class_1735)((class_481.class_483)this.field_2797).field_7761.get(i)).method_53512(this.searchResults.get(value).getItem());
                continue;
            }
            ((class_1735)((class_481.class_483)this.field_2797).field_7761.get(i)).method_53512(class_1802.field_8162.method_7854());
        }
    }

    private void populate() {
        try {
            DevInventoryGroup group = DevInventoryGroup.GROUPS[selectedTab];
            String text = this.searchBox.method_1882();
            if (text.equals("")) {
                text = null;
            }
            this.searchResults = group.searchItems(text);
            if (this.searchResults != null) {
                this.scroll();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        this.method_25420(context, mouseX, mouseY, delta);
        super.method_25394(context, mouseX, mouseY, delta);
        Integer hoveredGroup = this.getGroupFromMouse(mouseX, mouseY);
        if (hoveredGroup != null) {
            DevInventoryGroup group = DevInventoryGroup.GROUPS[hoveredGroup];
            context.method_51438(this.field_22793, DevInventoryGroup.GROUPS[hoveredGroup].getName(), mouseX, mouseY);
        }
        if (this.deleteItemSlot != null && this.method_2378(this.deleteItemSlot.field_7873, this.deleteItemSlot.field_7872, 16, 16, mouseX, mouseY)) {
            context.method_51438(this.field_22793, DELETE_ITEM_SLOT_TEXT, mouseX, mouseY);
        }
        this.method_2380(context, mouseX, mouseY);
    }

    public boolean method_25400(char chr, int modifiers) {
        if (this.ignoreNextKey) {
            this.ignoreNextKey = false;
            return true;
        }
        if (this.searchBox.method_25400(chr, modifiers)) {
            this.populate();
            return true;
        }
        return false;
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 96) {
            this.method_25419();
        }
        if (keyCode >= 48 && keyCode <= 57) {
            int number = keyCode - 49;
            if (number == -1) {
                number = 9;
            }
            class_1735 slot = (class_1735)((class_481.class_483)this.field_2797).field_7761.get(number);
            if (this.field_22787 == null || this.field_22787.field_1724 == null) {
                return false;
            }
            this.field_22787.field_1724.method_6122(class_1268.field_5808, slot.method_7677());
            if (CodeClient.MC.method_1562() != null) {
                Utility.sendHandItem(slot.method_7677());
            }
            this.ignoreNextKey = true;
            return true;
        }
        if (keyCode == 265 || keyCode == 264) {
            selectedTab += 7 * (keyCode == 264 ? -1 : 1);
            if ((selectedTab %= DevInventoryGroup.GROUPS.length) < 0) {
                selectedTab = DevInventoryGroup.GROUPS.length + selectedTab;
            }
            this.setSelectedTab(selectedTab);
            return true;
        }
        if (keyCode != 258 && this.searchBox.method_25370()) {
            if (keyCode == 256) {
                this.searchBox.method_25365(false);
                this.method_25395(null);
                return false;
            }
            this.searchBox.method_25404(keyCode, scanCode, modifiers);
            this.populate();
            return true;
        }
        if (keyCode == 258 || keyCode == 262 || keyCode == 263) {
            if ((modifiers & 1) == 1 || keyCode == 263) {
                if (--selectedTab < 0) {
                    selectedTab = DevInventoryGroup.GROUPS.length + selectedTab;
                }
                this.setSelectedTab(selectedTab);
            } else {
                this.setSelectedTab((selectedTab + 1) % DevInventoryGroup.GROUPS.length);
            }
            return true;
        }
        if (this.searchBox.field_22763 && (CodeClient.MC.field_1690.field_1890.method_1417(keyCode, scanCode) || KeyBinds.editBind.method_1417(keyCode, scanCode))) {
            if (keyCode == 89) {
                this.setSelectedTab(DevInventoryGroup.SEARCH.getIndex());
            }
            this.searchBox.method_25365(true);
            this.searchBox.method_1872(false);
            this.searchBox.method_1884(0);
            this.ignoreNextKey = true;
            return true;
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    protected void method_2389(class_332 context, float delta, int mouseX, int mouseY) {
        DevInventoryGroup itemGroup = DevInventoryGroup.GROUPS[selectedTab];
        for (DevInventoryGroup group : DevInventoryGroup.GROUPS) {
            this.renderTabIcon(context, group);
        }
        String texture = "item_search";
        if (!itemGroup.hasSearchBar()) {
            texture = "items";
        }
        if (itemGroup == DevInventoryGroup.INVENTORY) {
            texture = "inventory";
        }
        context.method_25290(class_10799.field_56883, class_1761.method_60733((String)texture), this.field_2776, this.field_2800, 0.0f, 0.0f, this.field_2792, this.field_2779, 256, 256);
        this.renderTabIcon(context, itemGroup);
        if (itemGroup.hasSearchBar()) {
            this.searchBox.method_25394(context, mouseX, mouseY, delta);
        }
        if (itemGroup != DevInventoryGroup.INVENTORY) {
            int scrollbarX = this.field_2776 + 175;
            int scrollbarY = this.field_2800 + 18;
            if (this.scrollHeight == 0) {
                context.method_25290(class_10799.field_56883, TEXTURE, scrollbarX, scrollbarY, 244.0f, 0.0f, 12, 15, 256, 256);
            } else {
                context.method_25290(class_10799.field_56883, TEXTURE, scrollbarX, scrollbarY + 95 * (int)(this.scrollPosition * 9.0) / this.scrollHeight, 232.0f, 0.0f, 12, 15, 256, 256);
            }
        } else if (this.field_22787 != null && this.field_22787.field_1724 != null) {
            class_490.method_2486((class_332)context, (int)(this.field_2776 + 73), (int)(this.field_2800 + 6), (int)(this.field_2776 + 105), (int)(this.field_2800 + 49), (int)20, (float)0.0625f, (float)mouseX, (float)mouseY, (class_1309)this.field_22787.field_1724);
        }
    }

    protected boolean isClickInTab(DevInventoryGroup group, double mouseX, double mouseY) {
        int x = group.getDisplayX(0);
        int y = group.getDisplayY(0, this.field_2779);
        return mouseX >= (double)x && mouseX <= (double)(x + 28) && mouseY >= (double)y && mouseY <= (double)(y + 28);
    }

    protected void renderTabIcon(class_332 context, DevInventoryGroup group) {
        boolean isSelected = group.getIndex() == selectedTab;
        boolean isTopRow = group.isTopHalf();
        int column = group.getColumn();
        int mapX = column * 28;
        int mapY = 0;
        int originX = group.getDisplayX(this.field_2776);
        int originY = group.getDisplayY(this.field_2800, this.field_2779);
        if (isSelected) {
            mapY += 32;
        }
        if (!isTopRow) {
            mapY += 64;
        }
        context.method_25290(class_10799.field_56883, TEXTURE, originX, originY, (float)mapX, (float)mapY, 28, 32, 256, 256);
        int n = isTopRow ? 2 : -2;
        class_1799 itemStack = group.getIcon();
        context.method_51427(itemStack, originX += 6, originY += 8 + n);
    }

    public boolean method_25401(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        if (!DevInventoryGroup.GROUPS[selectedTab].hasSearchBar()) {
            return false;
        }
        this.scrollPosition -= verticalAmount;
        if (this.scrollPosition < 0.0) {
            this.scrollPosition = 0.0;
        }
        if (this.scrollPosition * 9.0 > (double)this.scrollHeight) {
            this.scrollPosition = (double)this.scrollHeight / 9.0;
        }
        this.scroll();
        return true;
    }

    protected boolean isClickInScrollbar(double mouseX, double mouseY) {
        if (!DevInventoryGroup.GROUPS[selectedTab].hasSearchBar()) {
            return false;
        }
        int windowX = this.field_2776;
        int windowY = this.field_2800;
        int scrollOriginX = windowX + 175;
        int scrollOriginY = windowY + 18;
        int scrollFarX = scrollOriginX + 14;
        int scrollFarY = scrollOriginY + 112;
        return mouseX >= (double)scrollOriginX && mouseY >= (double)scrollOriginY && mouseX < (double)scrollFarX && mouseY < (double)scrollFarY;
    }
}

