/*
 * Decompiled with CFR 0.152.
 */
package dev.dfonline.codeclient.dev.overlay;

import com.google.common.collect.Lists;
import dev.dfonline.codeclient.ChestFeature;
import dev.dfonline.codeclient.CodeClient;
import dev.dfonline.codeclient.Feature;
import dev.dfonline.codeclient.config.Config;
import dev.dfonline.codeclient.dev.menu.customchest.CustomChestHandler;
import dev.dfonline.codeclient.dev.menu.customchest.CustomChestMenu;
import dev.dfonline.codeclient.hypercube.ReferenceBook;
import dev.dfonline.codeclient.hypercube.actiondump.Action;
import dev.dfonline.codeclient.hypercube.actiondump.ActionDump;
import dev.dfonline.codeclient.location.Dev;
import dev.dfonline.codeclient.location.Location;
import java.util.List;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2595;
import net.minecraft.class_2625;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3965;
import net.minecraft.class_465;
import net.minecraft.class_476;
import net.minecraft.class_5684;
import net.minecraft.class_638;
import net.minecraft.class_8000;
import net.minecraft.class_8002;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector2i;
import org.joml.Vector2ic;

public class ActionViewer
extends Feature {
    private Action action = null;
    private ReferenceBook book = null;
    private boolean tall = false;

    @Override
    public void reset() {
        this.action = null;
        this.book = null;
        this.tall = false;
    }

    public boolean isValid() {
        return this.action != null || this.book != null;
    }

    @Override
    public void onClickChest(class_3965 hitResult) {
        class_2586 signEntity;
        Dev dev;
        this.reset();
        class_638 world = CodeClient.MC.field_1687;
        if (world == null || !Config.getConfig().ActionViewer) {
            return;
        }
        class_2338 position = hitResult.method_17777();
        Location location = CodeClient.location;
        if (location instanceof Dev && (dev = (Dev)location).isInDev(position).booleanValue() && world.method_8321(position) instanceof class_2595 && (signEntity = world.method_8321(position.method_10074().method_10067())) instanceof class_2625) {
            class_2625 sign = (class_2625)signEntity;
            try {
                this.action = ActionDump.getActionDump().findAction(sign.method_49853());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    @Nullable
    public ChestFeature makeChestFeature(class_465<?> screen) {
        return new Overlay(screen);
    }

    private class Overlay
    extends ChestFeature {
        private boolean hover;
        private int scroll;
        ActionTooltipPositioner positioner;

        public Overlay(class_465<?> screen) {
            super(screen);
            this.hover = false;
            this.scroll = 0;
            this.positioner = new ActionTooltipPositioner();
        }

        public List<class_2561> getOverlayText() {
            Location location = CodeClient.location;
            if (location instanceof Dev) {
                Dev dev = (Dev)location;
                if (!Config.getConfig().ActionViewer) {
                    return null;
                }
                if (ActionViewer.this.book != null) {
                    return ActionViewer.this.book.getTooltip();
                }
                if (ActionViewer.this.action == null) {
                    ReferenceBook referenceBook = dev.getReferenceBook();
                    if (referenceBook == null || referenceBook.isEmpty()) {
                        return null;
                    }
                    ActionViewer.this.book = referenceBook;
                    return referenceBook.getTooltip();
                }
                class_1799 item = ActionViewer.this.action.icon.getItem();
                return item.method_7950(class_1792.class_9635.field_51353, (class_1657)CodeClient.MC.field_1724, (class_1836)class_1836.field_41070);
            }
            return null;
        }

        @Override
        public void render(class_332 context, int mouseX, int mouseY, int x, int y, float delta) {
            List<class_2561> text = this.getOverlayText();
            if (text == null) {
                return;
            }
            this.positioner.setMousePosition(mouseX, mouseY);
            int z = this.hover ? 500 : 300;
            this.drawTooltip(context, this.screen, this.transformText(text), 176, this.scroll, z);
        }

        @Override
        public boolean mouseScrolled(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
            if (!(this.screen instanceof class_476) && !(this.screen instanceof CustomChestMenu)) {
                return false;
            }
            if (ActionViewer.this.isValid() && ActionViewer.this.tall && this.hover) {
                int modifier = Config.getConfig().InvertActionViewerScroll ? -8 : 8;
                this.scroll += modifier * (int)verticalAmount;
                return true;
            }
            return false;
        }

        private List<class_5684> transformText(List<class_2561> texts) {
            List orderedText = Lists.transform(texts, class_2561::method_30937);
            return orderedText.stream().map(class_5684::method_32662).toList();
        }

        private void drawTooltip(class_332 context, class_465<?> handledScreen, List<class_5684> components, int x, int y, int z) {
            class_327 textRenderer = CodeClient.MC.field_1772;
            if (handledScreen instanceof CustomChestMenu) {
                CustomChestMenu menu = (CustomChestMenu)handledScreen;
                CustomChestHandler handler = (CustomChestHandler)menu.method_17577();
                this.positioner.setBackgroundHeight(handler.numbers.MENU_HEIGHT);
                this.positioner.setBackgroundWidth(handler.numbers.MENU_WIDTH);
                x += handler.numbers.MENU_WIDTH - 176;
            } else {
                this.positioner.setBackgroundHeight(166);
                this.positioner.setBackgroundWidth(176);
            }
            if (components.isEmpty()) {
                return;
            }
            int tooltipWidth = 0;
            int tooltipHeight = components.size() == 1 ? -2 : 0;
            for (class_5684 tooltipComponent : components) {
                int width = tooltipComponent.method_32664(textRenderer);
                if (width > tooltipWidth) {
                    tooltipWidth = width;
                }
                tooltipHeight += tooltipComponent.method_32661(textRenderer);
            }
            Vector2ic vector = this.positioner.method_47944(context.method_51421(), context.method_51443(), x, y, tooltipWidth, tooltipHeight);
            int finalWidth = tooltipWidth;
            int finalHeight = tooltipHeight;
            class_8002.method_47946((class_332)context, (int)vector.x(), (int)vector.y(), (int)finalWidth, (int)finalHeight, null);
            int textY = vector.y();
            for (int index = 0; index < components.size(); ++index) {
                class_5684 tooltipComponent;
                class_5684 finalTooltipComponent = tooltipComponent = components.get(index);
                finalTooltipComponent.method_32665(context, textRenderer, vector.x(), textY);
                textY += tooltipComponent.method_32661(textRenderer) + (index == 0 ? 2 : 0);
            }
        }

        private class ActionTooltipPositioner
        implements class_8000 {
            private int backgroundHeight = 166;
            private int backgroundWidth = 176;
            private int mouseX = 0;
            private int mouseY = 0;

            private ActionTooltipPositioner() {
            }

            public Vector2ic method_47944(int screenWidth, int screenHeight, int x, int y, int width, int height) {
                Vector2i vector = new Vector2i(x, y);
                boolean centered = Config.getConfig().ActionViewerLocation == Config.ActionViewerAlignment.CENTER;
                int minHeight = Math.min(this.backgroundHeight, screenHeight - 8);
                if (minHeight < height + 6) {
                    int actual_scroll;
                    if (!ActionViewer.this.tall) {
                        ActionViewer.this.tall = true;
                    }
                    int max = (height + 8 - minHeight) / 2;
                    int n = actual_scroll = centered ? Math.max(-max, Math.min(max, Overlay.this.scroll)) : Math.max(max * -2, Math.min(0, Overlay.this.scroll));
                    if (actual_scroll != Overlay.this.scroll) {
                        int change = actual_scroll - Overlay.this.scroll;
                        vector.add(0, change);
                        Overlay.this.scroll = actual_scroll;
                    }
                }
                int difference = centered ? (height - this.backgroundHeight) / 2 : -4;
                vector.add(6, -difference);
                if (this.backgroundHeight > screenHeight) {
                    vector.add(0, (this.backgroundHeight - (screenHeight - 8)) / 2);
                }
                int space = (screenWidth - this.backgroundWidth) / 2 - 6;
                Overlay.this.hover = this.isMouseInside(x + 6, y - difference, width, height, screenWidth, screenHeight);
                if (width + 6 > space && Overlay.this.hover) {
                    vector.add(space - width - 5, 0);
                }
                return vector;
            }

            private boolean isMouseInside(int x, int y, int width, int height, int screenWidth, int screenHeight) {
                x += (screenWidth - this.backgroundWidth) / 2;
                y += (screenHeight - this.backgroundHeight) / 2;
                y -= 5;
                height += 6;
                if ((x -= 4) <= this.mouseX && this.mouseX <= x + (width += 6)) {
                    return y <= this.mouseY && this.mouseY <= y + height;
                }
                return false;
            }

            public void setBackgroundHeight(int backgroundHeight) {
                this.backgroundHeight = backgroundHeight;
            }

            public void setBackgroundWidth(int backgroundWidth) {
                this.backgroundWidth = backgroundWidth;
            }

            public void setMousePosition(int x, int y) {
                this.mouseX = x;
                this.mouseY = y;
            }
        }
    }
}

