/*
 * Decompiled with CFR 0.152.
 */
package dev.dfonline.codeclient.dev.overlay;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import dev.dfonline.codeclient.CodeClient;
import dev.dfonline.codeclient.Feature;
import dev.dfonline.codeclient.config.Config;
import dev.dfonline.codeclient.data.DFItem;
import dev.dfonline.codeclient.hypercube.item.Scope;
import dev.dfonline.codeclient.location.Dev;
import dev.dfonline.codeclient.location.Location;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.class_10370;
import net.minecraft.class_124;
import net.minecraft.class_1661;
import net.minecraft.class_1723;
import net.minecraft.class_1799;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_239;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2596;
import net.minecraft.class_2653;
import net.minecraft.class_2735;
import net.minecraft.class_2868;
import net.minecraft.class_2873;
import net.minecraft.class_3965;
import net.minecraft.class_5250;
import net.minecraft.class_5251;
import net.minecraft.class_634;
import net.minecraft.class_9288;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChestPeeker
extends Feature {
    private static class_2338 currentBlock = null;
    private static List<class_1799> items = new ArrayList<class_1799>();
    private static boolean itemsFetched = false;
    private int timeOut = 0;
    private static Consumer<List<class_1799>> currentCallback = null;
    private static boolean expectingItems = false;

    public static void pick(Consumer<List<class_1799>> callback) {
        currentCallback = callback;
        currentBlock = null;
        items = new ArrayList<class_1799>();
        itemsFetched = false;
    }

    @Override
    public void tick() {
        if (this.timeOut > 0) {
            if (this.timeOut == 1) {
                expectingItems = false;
            }
            --this.timeOut;
            return;
        }
        if (CodeClient.MC.field_1687 == null) {
            return;
        }
        if (!Config.getConfig().ChestPeeker && currentCallback == null) {
            return;
        }
        Location location = CodeClient.location;
        if (location instanceof Dev) {
            Dev dev = (Dev)location;
            class_239 class_2392 = CodeClient.MC.field_1765;
            if (class_2392 instanceof class_3965) {
                class_3965 block = (class_3965)class_2392;
                class_2338 pos = block.method_17777();
                if (pos.equals((Object)currentBlock)) {
                    return;
                }
                if (currentBlock == null && !itemsFetched) {
                    if (!dev.isInDev(pos).booleanValue()) {
                        return;
                    }
                    if (CodeClient.MC.field_1687.method_8320(pos).method_26204() != class_2246.field_10034) {
                        return;
                    }
                    currentBlock = pos;
                    items = new ArrayList<class_1799>();
                    itemsFetched = false;
                    if (!expectingItems) {
                        class_634 network = CodeClient.MC.method_1562();
                        if (network == null) {
                            return;
                        }
                        network.method_52787((class_2596)new class_10370(currentBlock, true));
                        expectingItems = true;
                        return;
                    }
                }
            }
        }
        currentBlock = null;
        items.clear();
        itemsFetched = false;
    }

    @Override
    public boolean onReceivePacket(class_2596<?> packet) {
        class_634 net = CodeClient.MC.method_1562();
        if (net == null) {
            return false;
        }
        if (!Config.getConfig().ChestPeeker && currentCallback == null) {
            return false;
        }
        if (CodeClient.MC.field_1724 == null) {
            return false;
        }
        class_1661 inv = CodeClient.MC.field_1724.method_31548();
        if (CodeClient.location instanceof Dev) {
            if (currentBlock != null && expectingItems && packet instanceof class_2735) {
                net.method_52787((class_2596)new class_2868(inv.method_67532()));
                return true;
            }
            if (expectingItems && packet instanceof class_2653) {
                class_2653 slot = (class_2653)packet;
                class_1723 handler = CodeClient.MC.field_1724.field_7498;
                class_1799 removedItem = handler.method_7611(slot.method_11450()).method_7677();
                net.method_52787((class_2596)new class_2873(slot.method_11450(), removedItem));
                CodeClient.MC.field_1724.field_7498.method_7619(slot.method_11450(), 0, removedItem);
                DFItem item = DFItem.of(slot.method_11449());
                class_9288 container = item.getContainer();
                if (container == null) {
                    return class_1799.method_7984((class_1799)CodeClient.MC.field_1724.method_6047(), (class_1799)slot.method_11449());
                }
                items.clear();
                container.method_59714().forEach(stack -> items.add((class_1799)stack));
                itemsFetched = true;
                expectingItems = false;
                if (currentCallback != null) {
                    currentCallback.accept(items);
                    currentCallback = null;
                }
                return true;
            }
        }
        return false;
    }

    public List<class_2561> getOverlayText() {
        if (!Config.getConfig().ChestPeeker) {
            return null;
        }
        if (CodeClient.location instanceof Dev && currentBlock != null) {
            ArrayList<class_2561> texts = new ArrayList<class_2561>();
            if (!itemsFetched) {
                return null;
            }
            if (items.isEmpty()) {
                texts.add((class_2561)class_2561.method_43471((String)"codeclient.peeker.empty").method_27692(class_124.field_1065));
            } else {
                texts.add((class_2561)class_2561.method_43471((String)"codeclient.peeker.contents").method_27692(class_124.field_1065));
                for (class_1799 item : items) {
                    DFItem dfItem = DFItem.of(item);
                    List<class_2561> currentLore = dfItem.getLore();
                    ArrayList<class_2561> lore = new ArrayList<class_2561>(currentLore);
                    class_5250 text = class_2561.method_43473();
                    text.method_10852((class_2561)class_2561.method_43470((String)" \u2022 ").method_27692(class_124.field_1063));
                    Optional<String> varItem = dfItem.getHypercubeStringValue("varitem");
                    if (varItem.isEmpty()) {
                        text.method_27693(item.method_7947() + "x ");
                        text.method_10852(item.method_7964());
                    } else {
                        JsonObject object = JsonParser.parseString((String)varItem.get()).getAsJsonObject();
                        try {
                            Type type = Type.valueOf(object.get("id").getAsString());
                            JsonObject data = object.get("data").getAsJsonObject();
                            text.method_10852((class_2561)class_2561.method_43470((String)type.name.toUpperCase()).method_27696(class_2583.field_24360.method_27703(type.color)).method_27693(" "));
                            if (type == Type.var) {
                                Scope scope = Scope.valueOf(data.get("scope").getAsString());
                                text.method_27693(scope.getShortName()).method_27696(class_2583.field_24360.method_27703(scope.color)).method_27693(" ");
                            }
                            if (type == Type.num || type == Type.txt || type == Type.comp || type == Type.var || type == Type.g_val || type == Type.pn_el) {
                                text.method_10852(item.method_7964());
                            }
                            if (type == Type.loc) {
                                JsonObject loc = data.get("loc").getAsJsonObject();
                                text.method_27693("[%.2f, %.2f, %.2f, %.2f, %.2f]".formatted(Float.valueOf(loc.get("x").getAsFloat()), Float.valueOf(loc.get("y").getAsFloat()), Float.valueOf(loc.get("z").getAsFloat()), Float.valueOf(loc.get("pitch").getAsFloat()), Float.valueOf(loc.get("yaw").getAsFloat())));
                            }
                            if (type == Type.vec) {
                                text.method_10852((class_2561)class_2561.method_43470((String)"<%.2f, %.2f, %.2f>".formatted(Float.valueOf(data.get("x").getAsFloat()), Float.valueOf(data.get("y").getAsFloat()), Float.valueOf(data.get("z").getAsFloat()))).method_27696(class_2583.field_24360.method_27703(Type.vec.color)));
                            }
                            if (type == Type.snd) {
                                text.method_10852(lore.getFirst());
                                text.method_10852((class_2561)class_2561.method_43470((String)" P: ").method_27692(class_124.field_1080));
                                text.method_10852((class_2561)class_2561.method_43470((String)"%.1f".formatted(Float.valueOf(data.get("pitch").getAsFloat()))));
                                text.method_10852((class_2561)class_2561.method_43470((String)" V: ").method_27692(class_124.field_1080));
                                text.method_10852((class_2561)class_2561.method_43470((String)"%.1f".formatted(Float.valueOf(data.get("vol").getAsFloat()))));
                            }
                            if (type == Type.part) {
                                text.method_10852((class_2561)class_2561.method_43470((String)"%dx ".formatted(data.get("cluster").getAsJsonObject().get("amount").getAsInt())));
                                text.method_10852(lore.getFirst());
                            }
                            if (type == Type.pot) {
                                text.method_10852(lore.getFirst());
                                text.method_10852((class_2561)class_2561.method_43470((String)" %d ".formatted(data.get("amp").getAsInt() + 1)));
                                int dur = data.get("dur").getAsInt();
                                text.method_27693((String)(dur >= 1000000 ? "Infinite" : (dur % 20 == 0 ? "%d:%02d".formatted(dur / 1200, dur / 20 % 60) : dur + "ticks")));
                            }
                            if (type == Type.bl_tag) {
                                text.method_10852((class_2561)class_2561.method_43470((String)data.get("tag").getAsString()).method_27692(class_124.field_1054));
                                text.method_10852((class_2561)class_2561.method_43470((String)" \u00bb ").method_27692(class_124.field_1062));
                                text.method_10852((class_2561)class_2561.method_43470((String)data.get("option").getAsString()).method_27692(class_124.field_1075));
                            }
                            if (type == Type.hint) {
                                continue;
                            }
                        }
                        catch (IllegalArgumentException ignored) {
                            text.method_10852((class_2561)class_2561.method_43470((String)object.get("id").getAsString().toUpperCase()).method_27694(style -> style.method_27703(class_5251.method_27717((int)0x808080))).method_27693(" "));
                            text.method_10852(item.method_7964());
                        }
                    }
                    texts.add((class_2561)text);
                }
            }
            return texts;
        }
        return null;
    }

    @Override
    public void onBreakBlock(@NotNull Dev dev, @NotNull class_2338 pos, @Nullable class_2338 breakPos) {
        this.reset();
    }

    @Override
    public void onClickChest(class_3965 hitResult) {
    }

    @Override
    public void reset() {
        items.clear();
        itemsFetched = false;
        currentBlock = null;
        this.timeOut = 10;
        currentCallback = null;
    }

    static enum Type {
        txt("str", class_124.field_1075),
        comp("txt", class_5251.method_27717((int)8377386)),
        num("num", class_124.field_1061),
        loc("loc", class_124.field_1060),
        vec("vec", class_5251.method_27717((int)0x2AFFAA)),
        snd("snd", class_124.field_1078),
        part("par", class_5251.method_27717((int)0xAA55FF)),
        pot("pot", class_5251.method_27717((int)0xFF557F)),
        var("var", class_124.field_1054),
        g_val("val", class_5251.method_27717((int)16766079)),
        pn_el("param", class_5251.method_27717((int)0xAAFFAA)),
        bl_tag("tag", class_124.field_1054),
        hint("hint", class_5251.method_27717((int)0xAAFF55));

        public final String name;
        public final class_5251 color;

        private Type(String name, class_5251 color) {
            this.name = name;
            this.color = color;
        }

        private Type(String name, class_124 color) {
            this.name = name;
            this.color = class_5251.method_27718((class_124)color);
        }
    }
}

