/*
 * Decompiled with CFR 0.152.
 */
package dev.dfonline.codeclient.hypercube;

import java.util.regex.Pattern;

public class HypercubeCommands {
    private static final Pattern ITEM = HypercubeCommands.argument("item", "i");
    private static final Pattern LORE = HypercubeCommands.argument("lore", "l");
    public static final Pattern ITEM_NAME = HypercubeCommands.multi(HypercubeCommands.command(ITEM, HypercubeCommands.argument("name", "n")), HypercubeCommands.command(HypercubeCommands.argument("rename")));
    public static final Pattern ITEM_LORE_ADD = HypercubeCommands.multi(HypercubeCommands.command(ITEM, LORE, HypercubeCommands.argument("add", "a")), HypercubeCommands.command(LORE, HypercubeCommands.argument("add", "a")), HypercubeCommands.command(HypercubeCommands.argument("addlore", "ila")));
    public static final Pattern ITEM_LORE_SET = HypercubeCommands.multi(HypercubeCommands.command(ITEM, LORE, HypercubeCommands.argument("set", "s")), HypercubeCommands.command(LORE, HypercubeCommands.argument("set", "s")), HypercubeCommands.command(HypercubeCommands.argument("setlore", "ils")));
    public static final Pattern ITEM_LORE_INSERT = HypercubeCommands.multi(HypercubeCommands.command(ITEM, LORE, HypercubeCommands.argument("insert", "i")), HypercubeCommands.command(LORE, HypercubeCommands.argument("insert", "i")));
    public static final Pattern PLOT_NAME = HypercubeCommands.command(HypercubeCommands.argument("plot", "p"), HypercubeCommands.argument("name"));
    public static final Pattern NUMBER = HypercubeCommands.command("number", "num");
    public static final Pattern STRING = HypercubeCommands.command("string", "str");
    public static final Pattern TEXT = HypercubeCommands.command("styledtext", "text", "stxt", "txt");
    public static final Pattern VARIABLE = HypercubeCommands.command("variable", "var");
    public static final Pattern RELORE = HypercubeCommands.command("relore");

    private static Pattern argument(String ... strings) {
        StringBuilder builder = new StringBuilder();
        boolean separator = false;
        for (String string : strings) {
            if (separator) {
                builder.append("|");
            } else {
                separator = true;
            }
            builder.append("(").append(string).append(")");
        }
        return Pattern.compile(builder.toString(), 2);
    }

    private static Pattern command(Pattern ... arguments) {
        StringBuilder builder = new StringBuilder();
        boolean separator = false;
        for (Pattern argument : arguments) {
            if (separator) {
                builder.append(" ");
            } else {
                separator = true;
            }
            builder.append("(").append(argument.pattern()).append(")");
        }
        builder.append(" ");
        return Pattern.compile(builder.toString(), 2);
    }

    private static Pattern command(String ... strings) {
        return Pattern.compile(HypercubeCommands.argument(strings).pattern() + " ");
    }

    private static Pattern multi(Pattern ... commands) {
        StringBuilder builder = new StringBuilder();
        boolean separator = false;
        for (Pattern command : commands) {
            if (separator) {
                builder.append("|");
            } else {
                separator = true;
            }
            builder.append("(").append(command.pattern()).append(")");
        }
        return Pattern.compile(builder.toString(), 2);
    }
}

