/*
 * Decompiled with CFR 0.152.
 */
package dev.dfonline.codeclient.hypercube.actiondump;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.dfonline.codeclient.CodeClient;
import dev.dfonline.codeclient.Utility;
import dev.dfonline.codeclient.data.DFItem;
import dev.dfonline.codeclient.hypercube.actiondump.ActionDump;
import dev.dfonline.codeclient.hypercube.actiondump.CodeBlock;
import dev.dfonline.codeclient.hypercube.actiondump.Icon;
import dev.dfonline.codeclient.hypercube.actiondump.Searchable;
import dev.dfonline.codeclient.hypercube.actiondump.Tag;
import dev.dfonline.codeclient.hypercube.item.BlockTag;
import dev.dfonline.codeclient.hypercube.template.Argument;
import dev.dfonline.codeclient.hypercube.template.Bracket;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1799;
import org.jetbrains.annotations.Nullable;

public class Action
implements Searchable {
    public String name;
    public String codeblockName;
    public Tag[] tags;
    public String[] aliases;
    public Icon icon;
    public String[] subActionBlocks;

    @Override
    public List<String> getTerms() {
        ArrayList<String> terms = new ArrayList<String>(Arrays.stream(this.aliases).toList());
        terms.add(this.name);
        terms.add(this.icon.name.replace("\u00a7.", ""));
        return terms;
    }

    @Nullable
    public CodeBlock getCodeBlock() {
        try {
            return ActionDump.getActionDump().getCodeBlock(this.codeblockName, false);
        }
        catch (IOException e) {
            return null;
        }
    }

    @Override
    public class_1799 getItem() {
        class_1799 item = this.icon.getItem();
        JsonObject CodeTemplateData = new JsonObject();
        CodeTemplateData.addProperty("author", CodeClient.MC.method_1548().method_1676());
        CodeTemplateData.addProperty("name", this.icon.name);
        CodeTemplateData.addProperty("version", (Number)1);
        CodeBlock codeBlock = this.getCodeBlock();
        JsonObject template = new JsonObject();
        JsonArray blocks = new JsonArray();
        boolean repeat = codeBlock.identifier.equals("repeat");
        boolean hasBrackets = codeBlock.identifier.contains("if") || repeat || codeBlock.identifier.equals("else");
        JsonObject action = new JsonObject();
        action.addProperty("id", "block");
        action.addProperty("block", codeBlock.identifier);
        action.addProperty("action", this.name);
        JsonObject args = new JsonObject();
        JsonArray items = new JsonArray();
        for (Tag tag : this.tags) {
            Optional<Tag.TagOption> defaultOption = Arrays.stream(tag.options).filter(tagOption -> tagOption.name.equals(tag.defaultOption)).findFirst();
            if (!defaultOption.isPresent()) continue;
            BlockTag blockTag = new BlockTag(tag.defaultOption, tag.name, this.name, this.getCodeBlock().identifier);
            items.add((JsonElement)new Argument(blockTag, tag.slot).toJsonObject());
        }
        args.add("items", (JsonElement)items);
        action.add("args", (JsonElement)args);
        blocks.add((JsonElement)action);
        if (hasBrackets) {
            blocks.add((JsonElement)new Bracket(false, repeat).toJsonObject());
            blocks.add((JsonElement)new Bracket(true, repeat).toJsonObject());
        }
        template.add("blocks", (JsonElement)blocks);
        try {
            CodeTemplateData.addProperty("code", Utility.compileTemplate(template.toString()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        DFItem dfItem = DFItem.of(item);
        dfItem.getItemData().setHypercubeStringValue("codetemplatedata", String.valueOf(CodeTemplateData));
        return dfItem.getItemStack();
    }

    public boolean isInvalid() {
        return this.icon.name.isEmpty();
    }
}

