/*
 * Decompiled with CFR 0.152.
 */
package dev.dfonline.codeclient.hypercube.actiondump;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.dfonline.codeclient.data.DFItem;
import dev.dfonline.codeclient.hypercube.actiondump.Searchable;
import dev.dfonline.codeclient.hypercube.actiondump.VarItem;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_2561;

public class Particle
extends VarItem
implements Searchable {
    public String particle;
    public String category;
    public ParticleField[] fields;

    @Override
    public List<String> getTerms() {
        return List.of(this.particle, this.icon.getCleanName());
    }

    @Override
    public class_1799 getItem() {
        JsonObject data = new JsonObject();
        data.addProperty("particle", this.icon.getCleanName());
        JsonObject cluster = new JsonObject();
        cluster.addProperty("amount", (Number)1);
        cluster.addProperty("horizontal", (Number)0.0);
        cluster.addProperty("vertical", (Number)0.0);
        data.add("cluster", (JsonElement)cluster);
        JsonObject particleData = new JsonObject();
        List<ParticleField> optionFields = Arrays.stream(this.fields).toList();
        if (optionFields.contains((Object)ParticleField.Motion)) {
            particleData.addProperty("x", (Number)1);
            particleData.addProperty("y", (Number)0);
            particleData.addProperty("z", (Number)0);
        }
        if (optionFields.contains((Object)ParticleField.MotionVariation)) {
            particleData.addProperty("motionVariation", (Number)100);
        }
        if (optionFields.contains((Object)ParticleField.Color)) {
            particleData.addProperty("rgb", (Number)0xFF0000);
        }
        if (optionFields.contains((Object)ParticleField.ColorVariation)) {
            particleData.addProperty("colorVariation", (Number)0);
        }
        if (optionFields.contains((Object)ParticleField.Size)) {
            particleData.addProperty("size", (Number)1);
        }
        if (optionFields.contains((Object)ParticleField.SizeVariation)) {
            particleData.addProperty("sizeVariation", (Number)0);
        }
        if (optionFields.contains((Object)ParticleField.Material)) {
            particleData.addProperty("material", "STONE");
        }
        data.add("data", (JsonElement)particleData);
        class_1799 item = super.getItem("part", data);
        DFItem dfItem = DFItem.of(item);
        List<class_2561> lore = dfItem.getLore();
        ArrayList<class_2561> newLore = new ArrayList<class_2561>(lore);
        newLore.add((class_2561)class_2561.method_43473());
        newLore.add((class_2561)class_2561.method_43470((String)"Additional Fields:").method_27692(class_124.field_1080));
        if (optionFields.isEmpty()) {
            newLore.add((class_2561)class_2561.method_43470((String)"None").method_27692(class_124.field_1063));
        } else {
            for (ParticleField field : optionFields) {
                if (field != null) {
                    newLore.add((class_2561)class_2561.method_43470((String)("\u2022 " + field.displayName)).method_27692(class_124.field_1068));
                    continue;
                }
                newLore.add(class_2561.method_30163((String)"NULL?"));
            }
        }
        dfItem.setLore(newLore);
        return item;
    }

    static enum ParticleField {
        Motion("Motion"),
        MotionVariation("Motion Variation"),
        Color("Color"),
        ColorVariation("Color Variation"),
        Material("Material"),
        Size("Size"),
        SizeVariation("Size Variation");

        public final String displayName;

        private ParticleField(String displayName) {
            this.displayName = displayName;
        }
    }
}

