/*
 * Decompiled with CFR 0.152.
 */
package dev.dfonline.codeclient.hypercube.item;

import com.google.gson.JsonObject;
import dev.dfonline.codeclient.Utility;
import dev.dfonline.codeclient.data.DFItem;
import dev.dfonline.codeclient.hypercube.actiondump.ActionDump;
import dev.dfonline.codeclient.hypercube.actiondump.Icon;
import dev.dfonline.codeclient.hypercube.item.VarItem;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.class_124;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_5250;
import org.jetbrains.annotations.Nullable;

public class Sound
extends VarItem {
    private String sound;
    private double pitch;
    private double volume;
    private String variant;
    public static final Map<String, Double> Notes;
    public static final Map<Double, String> Pitches;

    @Override
    public String getId() {
        return "snd";
    }

    @Override
    protected class_1792 getIconItem() {
        return class_1802.field_8864;
    }

    @Override
    public JsonObject getDefaultData() {
        JsonObject object = new JsonObject();
        object.addProperty("pitch", (Number)1);
        object.addProperty("vol", (Number)2);
        object.addProperty("sound", "Pling");
        return object;
    }

    public Sound(JsonObject var) {
        super(var);
        this.sound = this.data.get("sound").getAsString();
        this.pitch = this.data.get("pitch").getAsDouble();
        this.volume = this.data.get("vol").getAsDouble();
        if (this.data.has("variant")) {
            this.variant = this.data.get("variant").getAsString();
        }
    }

    public Sound() {
        this.sound = "Pling";
        this.volume = 2.0;
        this.pitch = 1.0;
    }

    public String getSound() {
        return this.sound;
    }

    public Optional<dev.dfonline.codeclient.hypercube.actiondump.Sound> getSoundId() {
        try {
            return Arrays.stream(ActionDump.getActionDump().sounds).filter(sound -> Objects.equals(sound.icon.getCleanName(), this.sound)).findFirst();
        }
        catch (IOException ignored) {
            return Optional.empty();
        }
    }

    public void setSound(String sound) {
        this.sound = sound;
        this.data.addProperty("sound", sound);
    }

    public double getPitch() {
        return this.pitch;
    }

    public void setPitch(double pitch) {
        this.pitch = pitch;
        this.data.addProperty("pitch", (Number)pitch);
    }

    @Nullable
    public String getNote() {
        return Pitches.get(this.getPitch());
    }

    public void setNote(String note) {
        boolean sharp = note.contains("#");
        String octave = note.replaceAll("[^012]", "");
        String key = note.toUpperCase().replaceAll("[^A-G]", "");
        Double pitch = Notes.get(sharp ? octave + key + "#" : octave + key);
        if (pitch != null) {
            this.pitch = pitch;
        }
    }

    public double getVolume() {
        return this.volume;
    }

    public void setVolume(double volume) {
        this.volume = volume;
        this.data.addProperty("vol", (Number)volume);
    }

    public String getVariant() {
        return this.variant;
    }

    @Override
    public class_1799 toStack() {
        class_5250 name;
        class_1799 stack = super.toStack();
        DFItem dfItem = DFItem.of(stack);
        dfItem.setName((class_2561)class_2561.method_43470((String)"Sound").method_10862(class_2583.field_24360.method_10978(Boolean.valueOf(false)).method_27703(Icon.Type.SOUND.color)));
        try {
            ActionDump db = ActionDump.getActionDump();
            Optional<dev.dfonline.codeclient.hypercube.actiondump.Sound> value = Arrays.stream(db.sounds).filter(gv -> gv.icon.getCleanName().equals(this.sound)).findFirst();
            if (value.isEmpty()) {
                throw new Exception("");
            }
            name = class_2561.method_43470((String)value.get().icon.name);
        }
        catch (Exception e) {
            name = class_2561.method_43470((String)this.sound).method_10862(class_2583.field_24360);
        }
        Utility.addLore(dfItem.getItemStack(), new class_2561[]{name, class_2561.method_43473(), class_2561.method_43473().method_10852((class_2561)class_2561.method_43470((String)"Pitch: ").method_10862(class_2583.field_24360.method_10978(Boolean.valueOf(false)).method_10977(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)"%.2f".formatted(this.pitch)).method_10862(class_2583.field_24360.method_10977(class_124.field_1068)))), class_2561.method_43473().method_10852((class_2561)class_2561.method_43470((String)"Volume: ").method_10862(class_2583.field_24360.method_10978(Boolean.valueOf(false)).method_10977(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)"%.2f".formatted(this.volume)).method_10862(class_2583.field_24360.method_10977(class_124.field_1068))))});
        return dfItem.getItemStack();
    }

    static {
        HashMap<String, Double> notes = new HashMap<String, Double>();
        notes.put("F#0", 0.5);
        notes.put("G0", 0.529732);
        notes.put("G#0", 0.561231);
        notes.put("A1", 0.594604);
        notes.put("A#1", 0.629961);
        notes.put("B1", 0.66742);
        notes.put("C1", 0.707107);
        notes.put("C#1", 0.749154);
        notes.put("D1", 0.793701);
        notes.put("D#1", 0.840896);
        notes.put("E1", 0.890899);
        notes.put("F1", 0.943874);
        notes.put("F#1", 1.0);
        notes.put("G1", 1.059463);
        notes.put("G#1", 1.122462);
        notes.put("A2", 1.189207);
        notes.put("A#2", 1.259921);
        notes.put("B2", 1.33484);
        notes.put("C2", 1.414214);
        notes.put("C#2", 1.498307);
        notes.put("D2", 1.587401);
        notes.put("D#2", 1.681793);
        notes.put("E2", 1.781797);
        notes.put("F2", 1.887749);
        notes.put("F#2", 2.0);
        HashMap<Double, String> pitches = new HashMap<Double, String>();
        for (Map.Entry entry : notes.entrySet()) {
            pitches.put((Double)entry.getValue(), (String)entry.getKey());
        }
        Notes = notes;
        Pitches = pitches;
    }
}

