/*
 * Decompiled with CFR 0.152.
 */
package dev.dfonline.codeclient.location;

import dev.dfonline.codeclient.CodeClient;
import dev.dfonline.codeclient.command.impl.CommandJump;
import dev.dfonline.codeclient.location.Location;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2625;
import net.minecraft.class_638;
import net.minecraft.class_8242;
import org.jetbrains.annotations.Nullable;

public abstract class Plot
extends Location {
    public static Pattern lineStarterPattern = Pattern.compile("(PLAYER|ENTITY) EVENT|FUNCTION|PROCESS");
    public class_243 devPos;
    protected Integer id;
    protected String name;
    protected String owner;
    protected Integer originX;
    protected Integer originZ;
    protected class_243 buildPos;
    protected boolean hasUnderground = false;
    protected Boolean hasBuild;
    protected Boolean hasDev;
    protected Size size;
    protected HashMap<class_2338, class_8242> lineStarterCache = new HashMap();
    protected HashMap<class_2338, class_8242> actionCache = new HashMap();

    public void setOrigin(int x, int z) {
        this.originX = x;
        this.originZ = z;
    }

    public class_243 getPos() {
        return new class_243((double)this.originX.intValue(), 0.0, (double)this.originZ.intValue());
    }

    public void copyValuesFrom(Plot plot) {
        if (plot.id != null) {
            this.id = plot.id;
        }
        if (plot.name != null) {
            this.name = plot.name;
        }
        if (plot.owner != null) {
            this.owner = plot.owner;
        }
        if (plot.originX != null) {
            this.originX = plot.originX;
        }
        if (plot.originZ != null) {
            this.originZ = plot.originZ;
        }
        if (plot.buildPos != null && this.buildPos == null) {
            this.buildPos = plot.buildPos;
        }
        if (plot.hasBuild != null) {
            this.hasBuild = plot.hasBuild;
        }
        if (plot.hasDev != null) {
            this.hasDev = plot.hasDev;
        }
        if (plot.size != null) {
            this.size = plot.size;
        }
        if (plot.devPos != null) {
            this.devPos = plot.devPos;
        }
    }

    public void setHasUnderground(boolean hasUnderground) {
        this.hasUnderground = hasUnderground;
    }

    @Nullable
    public Size getSize() {
        return this.size;
    }

    public void setSize(Size size) {
        this.size = size;
    }

    public Size assumeSize() {
        if (this.size == null) {
            return Size.MASSIVE;
        }
        return this.size;
    }

    public Integer getX() {
        return this.originX;
    }

    public Integer getZ() {
        return this.originZ;
    }

    public class_243 getBuildPos() {
        return this.buildPos;
    }

    public int getFloorY() {
        return this.hasUnderground ? 5 : 50;
    }

    public Boolean isInPlot(class_2338 pos) {
        return this.isInArea(pos.method_46558()) != false || this.isInDev(pos.method_46558()) != false;
    }

    public Boolean isInArea(class_243 pos) {
        Size size = this.assumeSize();
        double x = pos.method_10216();
        double z = pos.method_10215();
        boolean inX = x >= (double)this.originX.intValue() && x <= (double)(this.originX + size.size + 1);
        boolean inZ = z >= (double)this.originZ.intValue() && z <= (double)(this.originZ + size.size + 1);
        return inX && inZ;
    }

    public Boolean isInDev(class_2338 pos) {
        Size size = this.assumeSize();
        int x = pos.method_10263();
        int z = pos.method_10260();
        return x < this.originX && x >= this.originX - size.codeWidth && z >= this.originZ && z <= this.originZ + size.codeLength;
    }

    public Boolean isInDev(class_243 pos) {
        Size size = this.assumeSize();
        int x = (int)pos.method_10216();
        int z = (int)pos.method_10215();
        boolean inX = x <= this.originX && x >= this.originX - (size.codeLength - 1);
        boolean inZ = z >= this.originZ && z <= this.originZ + size.codeWidth;
        return inX && inZ;
    }

    @Nullable
    public HashMap<class_2338, class_8242> scanForSigns(Pattern name, Pattern scan) {
        if (CodeClient.MC.field_1687 == null || this.originX == null || this.originZ == null || !(CodeClient.location instanceof Plot)) {
            return null;
        }
        HashMap<class_2338, class_8242> signs = new HashMap<class_2338, class_8242>();
        Size size = this.assumeSize();
        for (int y = ((Plot)CodeClient.location).getFloorY(); y < 255; y += 5) {
            int xEnd = this.originX + 1;
            for (int x = this.originX - size.codeWidth; x < xEnd; ++x) {
                int zEnd = this.originZ + size.codeLength;
                for (int z = this.originZ.intValue(); z < zEnd; ++z) {
                    Matcher scanMatch;
                    class_2625 sign;
                    class_8242 text;
                    Matcher nameMatch;
                    class_2338 pos = new class_2338(x, y, z);
                    class_2586 block = CodeClient.MC.field_1687.method_8321(pos);
                    if (!(block instanceof class_2625) || !(nameMatch = name.matcher((text = (sign = (class_2625)block).method_49853()).method_49859(0, false).getString())).matches() || !(scanMatch = scan.matcher(text.method_49859(1, false).getString())).matches()) continue;
                    signs.put(pos, text);
                }
            }
        }
        return signs;
    }

    public HashMap<class_2338, class_8242> scanForSigns(Pattern scan) {
        return this.scanForSigns(lineStarterPattern, scan);
    }

    public HashMap<class_2338, class_8242> scanForActionSigns(Pattern scan) {
        return this.scanForSigns(CommandJump.JumpType.ACTIONS.pattern, scan);
    }

    public void clearLineStarterCache() {
        this.lineStarterCache.clear();
    }

    private void fillLineStarterCache() {
        this.clearLineStarterCache();
        this.lineStarterCache = this.scanForSigns(Pattern.compile(".*"));
    }

    public Map<class_2338, class_8242> getLineStartCache() {
        if (this.lineStarterCache.isEmpty()) {
            this.fillLineStarterCache();
        }
        return this.lineStarterCache;
    }

    public void clearActionCache() {
        this.actionCache.clear();
    }

    private void fillActionCache() {
        this.clearActionCache();
        this.actionCache = this.scanForActionSigns(Pattern.compile(".*"));
    }

    public Map<class_2338, class_8242> getActionCache() {
        if (this.actionCache.isEmpty()) {
            this.fillActionCache();
        }
        return this.actionCache;
    }

    @Nullable
    public class_2338 findFreePlacePos() {
        return this.findFreePlacePos(new class_2338(this.originX - 1, this.hasUnderground ? 5 : 50, this.originZ.intValue()));
    }

    @Nullable
    public class_2338 findFreePlacePos(class_2338 origin) {
        if (this.originX == null || CodeClient.MC.field_1687 == null) {
            return null;
        }
        class_638 world = CodeClient.MC.field_1687;
        int x = origin.method_10263();
        for (int y = Math.max(origin.method_10264(), 5); y < 255; y += 5) {
            while (this.originX - x <= this.assumeSize().codeWidth - 2) {
                class_2338 pos;
                if (!world.method_8320((pos = new class_2338(--x, y, this.originZ.intValue())).method_10078()).method_26215() || !world.method_8320(pos.method_10067()).method_26215()) continue;
                return pos;
            }
            x = this.originX - 1;
        }
        return null;
    }

    public Optional<Boolean> getHasDev() {
        return Optional.ofNullable(this.hasDev);
    }

    public static enum Size {
        BASIC(50),
        LARGE(100),
        MASSIVE(300),
        MEGA(1000, 300, 300);

        public final int size;
        public final int codeLength;
        public final int codeWidth;

        private Size(int size) {
            this.size = size;
            this.codeLength = size;
            this.codeWidth = 20;
        }

        private Size(int size, int codeLength, int codeWidth) {
            this.size = size;
            this.codeLength = codeLength;
            this.codeWidth = codeWidth;
        }
    }
}

