/*
 * Decompiled with CFR 0.152.
 */
package dev.dfonline.codeclient.switcher;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import dev.dfonline.codeclient.CodeClient;
import dev.dfonline.codeclient.Feature;
import dev.dfonline.codeclient.Utility;
import dev.dfonline.codeclient.config.Config;
import dev.dfonline.codeclient.data.DFItem;
import dev.dfonline.codeclient.data.PublicBukkitValues;
import dev.dfonline.codeclient.hypercube.item.Scope;
import dev.dfonline.codeclient.switcher.GenericSwitcher;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_437;

public class ScopeSwitcher
extends GenericSwitcher {
    private final String option;

    public ScopeSwitcher(String option) {
        super((class_2561)class_2561.method_43471((String)"codeclient.switcher.scope"), -1, 32);
        this.option = option;
    }

    @Override
    protected void method_25426() {
        this.footer = class_2561.method_43469((String)"codeclient.switcher.scope.select", (Object[])new Object[]{class_2561.method_43469((String)"codeclient.switcher.footer.brackets", (Object[])new Object[]{"Click"}).method_27692(class_124.field_1075)}).method_27692(class_124.field_1068);
        this.selected = switch (this.option) {
            case "saved" -> 1;
            case "local" -> 2;
            case "line" -> 3;
            default -> 0;
        };
        super.method_25426();
    }

    @Override
    List<GenericSwitcher.Option> getOptions() {
        return List.of(new GenericSwitcher.Option((class_2561)class_2561.method_43470((String)Scope.unsaved.longName).method_10862(class_2583.field_24360.method_10978(Boolean.valueOf(false)).method_27703(Scope.unsaved.color)), class_1802.field_8466.method_7854(), () -> this.run("unsaved")), new GenericSwitcher.Option((class_2561)class_2561.method_43470((String)Scope.saved.longName).method_10862(class_2583.field_24360.method_10978(Boolean.valueOf(false)).method_27703(Scope.saved.color)), class_1802.field_8106.method_7854(), () -> this.run("saved")), new GenericSwitcher.Option((class_2561)class_2561.method_43470((String)Scope.local.longName).method_10862(class_2583.field_24360.method_10978(Boolean.valueOf(false)).method_27703(Scope.local.color)), class_1802.field_8733.method_7854(), () -> this.run("local")), new GenericSwitcher.Option((class_2561)class_2561.method_43470((String)Scope.line.longName).method_10862(class_2583.field_24360.method_10978(Boolean.valueOf(false)).method_27703(Scope.line.color)), class_1802.field_8055.method_7854(), () -> this.run("line")));
    }

    private void run(String name) {
        class_1799 stack = CodeClient.MC.field_1724.method_5998(class_1268.field_5808);
        DFItem item = DFItem.of(stack);
        PublicBukkitValues pbv = item.getPublicBukkitValues();
        Optional<String> varItem = pbv.getHypercubeStringValue("varitem");
        if (varItem.isEmpty()) {
            return;
        }
        JsonObject var = JsonParser.parseString((String)varItem.get()).getAsJsonObject();
        if (!var.get("id").getAsString().equals("var")) {
            return;
        }
        JsonObject data = var.get("data").getAsJsonObject();
        data.addProperty("scope", name);
        pbv.setHypercubeStringValue("varitem", var.toString());
        item.getItemData().setPublicBukkitValues(pbv);
        item.setLore(List.of(this.getSelected().text()));
        Utility.sendHandItem(item.getItemStack());
        CodeClient.MC.field_1773.field_4012.method_3215(class_1268.field_5808);
    }

    @Override
    protected boolean checkFinished() {
        if (this.hasClicked) {
            GenericSwitcher.Option selected = this.getSelected();
            if (selected != null) {
                selected.run();
            }
            this.field_22787.method_1507(null);
            return true;
        }
        return false;
    }

    public static class ScopeSwitcherFeature
    extends Feature {
        @Override
        public boolean enabled() {
            return Config.getConfig().ScopeSwitcher;
        }

        public void open(String option) {
            CodeClient.MC.method_1507((class_437)new ScopeSwitcher(option));
        }
    }
}

