/*
 * Decompiled with CFR 0.152.
 */
package dev.dfonline.codeclient.websocket;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.serialization.DynamicOps;
import dev.dfonline.codeclient.Callback;
import dev.dfonline.codeclient.CodeClient;
import dev.dfonline.codeclient.Utility;
import dev.dfonline.codeclient.action.None;
import dev.dfonline.codeclient.action.impl.ClearPlot;
import dev.dfonline.codeclient.action.impl.GetPlotSize;
import dev.dfonline.codeclient.action.impl.MoveToSpawn;
import dev.dfonline.codeclient.action.impl.PlaceTemplates;
import dev.dfonline.codeclient.action.impl.ScanPlot;
import dev.dfonline.codeclient.location.Location;
import dev.dfonline.codeclient.location.Plot;
import dev.dfonline.codeclient.websocket.SocketServer;
import dev.dfonline.codeclient.websocket.scope.AuthScope;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.class_11343;
import net.minecraft.class_11352;
import net.minecraft.class_11362;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2522;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2583;
import net.minecraft.class_7225;
import net.minecraft.class_746;
import org.java_websocket.WebSocket;
import org.jetbrains.annotations.Nullable;

public class SocketHandler {
    public static final int PORT = 31375;
    private final ArrayList<Action> actionQueue = new ArrayList();
    @Nullable
    private WebSocket connection = null;
    private static final List<AuthScope> defaultAuthScopes = List.of(AuthScope.DEFAULT);
    private List<AuthScope> unapprovedAuthScopes = List.of();
    private List<AuthScope> authScopes = defaultAuthScopes;
    private final HashMap<String, List<AuthScope>> tokenMap = new HashMap();
    private String activeToken = null;
    private SocketServer websocket;

    public void start() {
        try {
            this.websocket = new SocketServer(new InetSocketAddress("localhost", 31375), this);
            Thread socketThread = new Thread((Runnable)((Object)this.websocket), "CodeClient-API");
            socketThread.start();
            CodeClient.LOGGER.info("Socket opened");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void stop() {
        try {
            this.websocket.stop();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setAcceptedScopes(boolean accepted) {
        if (this.connection == null) {
            return;
        }
        this.actionQueue.clear();
        if (accepted) {
            this.unapprovedAuthScopes.addAll(defaultAuthScopes);
            this.authScopes = this.unapprovedAuthScopes;
            this.connection.send("auth");
        } else {
            this.authScopes = defaultAuthScopes;
            this.connection.send("removed");
        }
        this.unapprovedAuthScopes = List.of();
    }

    public void setConnection(WebSocket socket) {
        if (socket != null) {
            this.actionQueue.clear();
        }
        if (this.connection != null) {
            this.connection.close();
            if (this.activeToken != null) {
                this.tokenMap.put(this.activeToken, this.authScopes);
            }
            this.activeToken = null;
            this.authScopes = defaultAuthScopes;
            this.unapprovedAuthScopes = List.of();
        }
        this.connection = socket;
    }

    public void onMessage(String message) {
        String content;
        assert (this.connection != null);
        String[] arguments = message.split(" ");
        Action topAction = this.getTopAction();
        if (arguments[0] == null) {
            return;
        }
        String string = content = arguments.length > 1 ? message.substring(arguments[0].length() + 1) : "";
        if (topAction != null && arguments.length > 1 && Objects.equals(topAction.name, arguments[0])) {
            topAction.message(this.connection, content);
            return;
        }
        switch (arguments[0]) {
            case "scopes": {
                this.handleScopeRequest(arguments);
                break;
            }
            case "token": {
                this.handleTokenRequest(arguments);
                break;
            }
            case "clear": {
                this.assertScopeLevel(new Clear());
                break;
            }
            case "spawn": {
                this.assertScopeLevel(new Spawn());
                break;
            }
            case "size": {
                this.assertScopeLevel(new Size());
                break;
            }
            case "scan": {
                this.assertScopeLevel(new Scan());
                break;
            }
            case "place": {
                this.assertScopeLevel(new Place());
                break;
            }
            case "inv": {
                this.assertScopeLevel(new SendInventory());
                break;
            }
            case "setinv": {
                this.assertScopeLevel(new SetInventory(content));
                break;
            }
            case "give": {
                this.assertScopeLevel(new Give(content));
                break;
            }
            case "mode": {
                this.assertScopeLevel(new Mode(content));
                break;
            }
            default: {
                this.connection.send("invalid");
            }
        }
        topAction = this.getTopAction();
        if (topAction != null && arguments.length > 1 && Objects.equals(topAction.name, arguments[0])) {
            topAction.message(this.connection, content);
        }
        if (this.actionQueue.isEmpty()) {
            return;
        }
        Action firstAction = this.actionQueue.get(0);
        if (firstAction == null) {
            return;
        }
        if (firstAction.active) {
            return;
        }
        this.next();
    }

    private Action getTopAction() {
        if (this.actionQueue.isEmpty()) {
            return null;
        }
        return this.actionQueue.get(this.actionQueue.size() - 1);
    }

    private void handleScopeRequest(String[] arguments) {
        assert (this.connection != null);
        List<String> args = Arrays.asList(arguments).subList(1, arguments.length);
        if (args.isEmpty()) {
            String scopesString = String.join((CharSequence)" ", (CharSequence[])this.authScopes.stream().map(authScope -> authScope.translationKey).toArray(String[]::new));
            this.connection.send(scopesString);
            return;
        }
        ArrayList<AuthScope> scopes = new ArrayList<AuthScope>();
        ArrayList<String> invalidScopes = new ArrayList<String>();
        for (String arg : args) {
            AuthScope scope;
            try {
                scope = AuthScope.valueOf(arg.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                invalidScopes.add(arg);
                continue;
            }
            scopes.add(scope);
        }
        if (!invalidScopes.isEmpty()) {
            this.connection.send("invalid scope " + String.join((CharSequence)" ", invalidScopes));
            Utility.sendMessage((class_2561)class_2561.method_43471((String)"codeclient.api.scope.invalid"));
            return;
        }
        this.unapprovedAuthScopes = scopes;
        this.promptUserAcceptScopes();
    }

    private void handleTokenRequest(String[] arguments) {
        assert (this.connection != null);
        List<String> args = Arrays.asList(arguments).subList(1, arguments.length);
        if (args.isEmpty()) {
            String token = this.activeToken == null ? Utility.genAuthToken() : this.activeToken;
            this.connection.send("token " + token);
            this.tokenMap.put(token, this.authScopes);
            this.activeToken = token;
        } else {
            String token = args.get(0);
            if (!this.tokenMap.containsKey(token)) {
                this.connection.send("invalid token");
                return;
            }
            this.authScopes = this.tokenMap.get(token);
            this.connection.send("auth");
            this.activeToken = token;
        }
    }

    private void assertScopeLevel(Action commandClass) {
        if (!this.authScopes.contains((Object)commandClass.authScope)) {
            if (this.connection != null) {
                this.connection.send("unauthed");
            }
            return;
        }
        this.actionQueue.add(commandClass);
    }

    private void promptUserAcceptScopes() {
        if (this.unapprovedAuthScopes.isEmpty()) {
            return;
        }
        if (CodeClient.MC.field_1724 == null) {
            return;
        }
        class_746 player = CodeClient.MC.field_1724;
        Utility.sendMessage((class_2561)class_2561.method_43471((String)"codeclient.api.scope.prompt"));
        for (AuthScope scope : this.unapprovedAuthScopes) {
            player.method_7353((class_2561)class_2561.method_43473().method_10852((class_2561)class_2561.method_43470((String)"- ").method_27692(class_124.field_1063)).method_10852((class_2561)class_2561.method_43471((String)("codeclient.api.scope.type." + scope.translationKey)).method_27692(class_124.field_1068).method_27693(" ").method_10852((class_2561)class_2561.method_43470((String)"(").method_10852((class_2561)class_2561.method_43471((String)("codeclient.api.danger." + scope.dangerLevel.translationKey))).method_10852((class_2561)class_2561.method_43470((String)")")).method_27695(new class_124[]{scope.dangerLevel.color, class_124.field_1056}))).method_10862(class_2583.field_24360.method_10949((class_2568)new class_2568.class_10613((class_2561)class_2561.method_43471((String)("codeclient.api.danger." + scope.dangerLevel.translationKey + ".description"))))), false);
        }
        Utility.sendMessage((class_2561)class_2561.method_43471((String)"codeclient.api.run_auth"));
    }

    private void next() {
        if (this.actionQueue.isEmpty()) {
            return;
        }
        Action firstAction = this.actionQueue.get(0);
        if (firstAction == null) {
            return;
        }
        if (firstAction.active) {
            this.actionQueue.remove(0);
            CodeClient.LOGGER.info(firstAction.name + " done");
            this.next();
            return;
        }
        CodeClient.LOGGER.info("starting " + firstAction.name);
        firstAction.active = true;
        firstAction.start(this.connection);
    }

    public void abort() {
        this.actionQueue.clear();
        if (this.connection != null) {
            this.connection.send("aborted");
        }
    }

    private static abstract class Action {
        public final String name;
        public final AuthScope authScope;
        boolean active = false;

        Action(String name, AuthScope authScope) {
            this.name = name;
            this.authScope = authScope;
        }

        public abstract void set(WebSocket var1);

        public abstract void start(WebSocket var1);

        public abstract void message(WebSocket var1, String var2);
    }

    private class Clear
    extends Action {
        Clear() {
            super("clear", AuthScope.CLEAR_PLOT);
        }

        @Override
        public void set(WebSocket responder) {
        }

        @Override
        public void start(WebSocket responder) {
            CodeClient.currentAction = new ClearPlot(SocketHandler.this::next);
            CodeClient.currentAction.init();
        }

        @Override
        public void message(WebSocket responder, String message) {
        }
    }

    private class Spawn
    extends Action {
        Spawn() {
            super("spawn", AuthScope.MOVEMENT);
        }

        @Override
        public void set(WebSocket responder) {
        }

        @Override
        public void start(WebSocket responder) {
            CodeClient.currentAction = new MoveToSpawn(SocketHandler.this::next);
            CodeClient.currentAction.init();
        }

        @Override
        public void message(WebSocket responder, String message) {
        }
    }

    private class Size
    extends Action {
        Size() {
            super("size", AuthScope.READ_PLOT);
        }

        @Override
        public void set(WebSocket responder) {
        }

        @Override
        public void start(WebSocket responder) {
            Location location = CodeClient.location;
            if (location instanceof Plot) {
                Plot plot = (Plot)location;
                if (plot.getSize() != null) {
                    if (responder.isOpen()) {
                        responder.send(plot.getSize().name());
                    }
                    SocketHandler.this.next();
                } else {
                    CodeClient.currentAction = new GetPlotSize(() -> {
                        if (responder.isOpen()) {
                            responder.send(plot.getSize().name());
                        }
                        SocketHandler.this.next();
                    });
                }
            }
        }

        @Override
        public void message(WebSocket responder, String message) {
        }
    }

    private class Scan
    extends Action {
        Scan() {
            super("scan", AuthScope.READ_PLOT);
        }

        @Override
        public void set(WebSocket responder) {
        }

        @Override
        public void start(WebSocket responder) {
            ArrayList<class_1799> items = new ArrayList<class_1799>();
            CodeClient.currentAction = new ScanPlot(() -> {
                if (items.isEmpty()) {
                    responder.send("empty");
                    CodeClient.currentAction = new None();
                    SocketHandler.this.next();
                    return;
                }
                StringBuilder builder = new StringBuilder();
                for (class_1799 item : items) {
                    String data = Utility.templateDataItem(item);
                    if (data == null) continue;
                    builder.append(data).append("\n");
                }
                builder.deleteCharAt(builder.length() - 1);
                responder.send(builder.toString());
                CodeClient.currentAction = new None();
                SocketHandler.this.next();
            }, items);
            CodeClient.currentAction.init();
        }

        @Override
        public void message(WebSocket responder, String message) {
        }
    }

    private class Place
    extends Action {
        private final ArrayList<class_1799> templates;
        public boolean ready;
        private Method method;

        Place() {
            super("place", AuthScope.WRITE_CODE);
            this.templates = new ArrayList();
            this.ready = false;
            this.method = Method.DEFAULT;
        }

        @Override
        public void set(WebSocket responder) {
        }

        @Override
        public void start(WebSocket responder) {
            if (!this.ready) {
                return;
            }
            PlaceTemplates placer = this.method.createPlacer.run(this.templates, SocketHandler.this::next, responder);
            if (placer == null) {
                return;
            }
            CodeClient.currentAction = placer;
            CodeClient.currentAction.init();
        }

        @Override
        public void message(WebSocket responder, String message) {
            switch (message) {
                case "compact": {
                    this.method = Method.COMPACT;
                    return;
                }
                case "swap": {
                    this.method = Method.SWAP;
                    return;
                }
                case "go": {
                    this.ready = true;
                    if (Objects.equals(SocketHandler.this.actionQueue.get(0), this)) {
                        this.start(responder);
                    }
                    return;
                }
            }
            this.templates.add(Utility.makeTemplate(message));
        }

        private static enum Method {
            DEFAULT((templates, next, responder) -> PlaceTemplates.createPlacer(templates, () -> {
                CodeClient.currentAction = new None();
                if (responder.isOpen()) {
                    responder.send("place done");
                }
                next.run();
            })),
            COMPACT((templates, next, responder) -> PlaceTemplates.createPlacer(templates, () -> {
                CodeClient.currentAction = new None();
                if (responder.isOpen()) {
                    responder.send("place done");
                }
                next.run();
            }, true)),
            SWAP((templates, next, responder) -> PlaceTemplates.createSwapper(templates, () -> {
                CodeClient.currentAction = new None();
                if (responder.isOpen()) {
                    responder.send("place done");
                }
                next.run();
            }).swap());

            public final CreatePlacer createPlacer;

            private Method(CreatePlacer createPlacer) {
                this.createPlacer = createPlacer;
            }
        }

        private static interface CreatePlacer {
            public PlaceTemplates run(ArrayList<class_1799> var1, Callback var2, WebSocket var3);
        }
    }

    private class SendInventory
    extends Action {
        SendInventory() {
            super("inv", AuthScope.INVENTORY);
        }

        @Override
        public void set(WebSocket responder) {
        }

        @Override
        public void start(WebSocket responder) {
            class_11362 view = class_11362.method_71459(null, (class_7225.class_7874)CodeClient.MC.field_1724.method_56673());
            CodeClient.MC.field_1724.method_31548().method_7384(view.method_71467("Inventory", class_11343.field_60354));
            responder.send(String.valueOf(view.method_71475().method_10580("Inventory")));
            SocketHandler.this.next();
        }

        @Override
        public void message(WebSocket responder, String message) {
        }
    }

    private class SetInventory
    extends Action {
        private final String content;

        SetInventory(String content) {
            super("setinv", AuthScope.INVENTORY);
            this.content = content;
        }

        @Override
        public void set(WebSocket responder) {
        }

        @Override
        public void start(WebSocket responder) {
            if (CodeClient.MC.field_1724 == null) {
                return;
            }
            if (!CodeClient.MC.field_1724.method_68878()) {
                responder.send("not creative mode");
                SocketHandler.this.next();
                return;
            }
            try {
                CodeClient.MC.field_1724.method_31548().method_7397(class_11352.method_71417(null, (class_7225.class_7874)CodeClient.MC.field_1724.method_56673(), (class_2487)class_2522.method_67315((String)("{Inventory:" + this.content + "}"))).method_71437("Inventory", class_11343.field_60354));
                Utility.sendInventory();
            }
            catch (CommandSyntaxException e) {
                responder.send("invalid nbt");
            }
            finally {
                SocketHandler.this.next();
            }
        }

        @Override
        public void message(WebSocket responder, String message) {
        }
    }

    private class Give
    extends Action {
        private final String content;

        Give(String content) {
            super("give", AuthScope.DEFAULT);
            this.content = content;
        }

        @Override
        public void set(WebSocket responder) {
        }

        @Override
        public void start(WebSocket responder) {
            if (CodeClient.MC.field_1724 == null) {
                return;
            }
            if (!CodeClient.MC.field_1724.method_68878()) {
                responder.send("not creative mode");
                SocketHandler.this.next();
                return;
            }
            try {
                if (CodeClient.MC.field_1687 == null) {
                    return;
                }
                Optional itemStack = class_1799.field_24671.parse((DynamicOps)CodeClient.MC.field_1724.method_56673().method_57093((DynamicOps)class_2509.field_11560), (Object)class_2522.method_67315((String)this.content)).result();
                if (itemStack.isEmpty()) {
                    return;
                }
                CodeClient.MC.field_1724.method_7270((class_1799)itemStack.get());
                Utility.sendInventory();
            }
            catch (CommandSyntaxException e) {
                responder.send("invalid nbt");
            }
            finally {
                SocketHandler.this.next();
            }
        }

        @Override
        public void message(WebSocket responder, String message) {
        }
    }

    private class Mode
    extends Action {
        private static final List<String> commands = List.of("play", "build", "code", "dev");
        private final String command;

        Mode(String command) {
            super("mode", AuthScope.MOVEMENT);
            this.command = commands.contains(command) ? command : "";
        }

        @Override
        public void set(WebSocket responder) {
        }

        @Override
        public void start(WebSocket responder) {
            if (CodeClient.location instanceof Plot && !this.command.isEmpty() && CodeClient.MC.method_1562() != null) {
                CodeClient.MC.method_1562().method_45730(this.command);
            } else {
                responder.send(CodeClient.location.name());
            }
            SocketHandler.this.next();
        }

        @Override
        public void message(WebSocket responder, String message) {
        }
    }
}

