/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.jfronny.respackopts.filters;

import io.gitlab.jfronny.libjf.ResourcePath;
import io.gitlab.jfronny.respackopts.filters.IEvents;
import io.gitlab.jfronny.respackopts.filters.util.FileExclusionProvider;
import io.gitlab.jfronny.respackopts.filters.util.FileExpansionProvider;
import io.gitlab.jfronny.respackopts.filters.util.FileFallbackProvider;
import io.gitlab.jfronny.respackopts.model.cache.CacheKey;
import io.gitlab.jfronny.respackopts.model.enums.PackCapability;
import io.gitlab.jfronny.respackopts.muscript.RespackoptsFS;
import io.gitlab.jfronny.respackopts.util.MetaCache;
import java.io.InputStream;
import java.util.HashSet;
import net.minecraft.class_2960;
import net.minecraft.class_3262;
import net.minecraft.class_3264;
import net.minecraft.class_7367;

public class FileFilterEvents
implements IEvents {
    @Override
    public class_7367<InputStream> open(class_7367<InputStream> previous, class_3262 pack, String name) {
        RespackoptsFS fs;
        CacheKey key = MetaCache.getKeyByPack(pack);
        if (FileExclusionProvider.fileHidden(key, fs = new RespackoptsFS(pack), name)) {
            return FileFallbackProvider.getReplacement(key, fs, name);
        }
        return FileExpansionProvider.replace(previous, key, fs, name);
    }

    @Override
    public class_3262.class_7664 findResources(class_3264 type, String namespace, String prefix, class_3262.class_7664 previous, class_3262 pack) {
        if (this.skip(pack)) {
            return previous;
        }
        HashSet alreadyConsumed = new HashSet();
        CacheKey key = MetaCache.getKeyByPack(pack);
        RespackoptsFS fs = new RespackoptsFS(pack);
        return (identifier, value) -> {
            String fileName = new ResourcePath(type, identifier).getName();
            if (!FileExclusionProvider.fileHidden(key, fs, fileName)) {
                alreadyConsumed.add(identifier);
                previous.accept(identifier, this.open(type, (class_2960)identifier, (class_7367<InputStream>)value, pack));
            } else {
                class_7367<InputStream> replacement = FileFallbackProvider.getReplacement(key, fs, fileName);
                if (replacement != null) {
                    alreadyConsumed.add(identifier);
                    previous.accept(identifier, replacement);
                }
            }
            FileFallbackProvider.addFallbackResources(type, namespace, prefix, previous, key, fs, identifier, alreadyConsumed);
        };
    }

    @Override
    public boolean skip(class_3262 pack) {
        return !MetaCache.hasCapability(pack, PackCapability.FileFilter);
    }
}

