/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.jfronny.respackopts.filters.util;

import io.gitlab.jfronny.commons.LazySupplier;
import io.gitlab.jfronny.muscript.data.additional.context.Scope;
import io.gitlab.jfronny.muscript.data.additional.impl.ObjectGraphPrinter;
import io.gitlab.jfronny.respackopts.Respackopts;
import io.gitlab.jfronny.respackopts.model.Condition;
import io.gitlab.jfronny.respackopts.model.DirRpo;
import io.gitlab.jfronny.respackopts.model.cache.CacheKey;
import io.gitlab.jfronny.respackopts.muscript.RespackoptsFS;
import io.gitlab.jfronny.respackopts.util.MetaCache;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public sealed interface DirRpoResult {
    public static final FixedState IGNORE = FixedState.IGNORE;
    public static final FixedState ORIGINAL = FixedState.ORIGINAL;

    public static Replacement replacement(String originalPrefix, String fallbackPrefix, int version) {
        return new Replacement(originalPrefix, fallbackPrefix, version);
    }

    public static DirRpoResult compute(String file, Iterable<DirRpo> rpos, CacheKey key, RespackoptsFS fs, int version) {
        LazySupplier scope = new LazySupplier(() -> MetaCache.getScope(key, fs));
        for (DirRpo rpo : rpos) {
            if (rpo.condition == null) continue;
            try {
                if (rpo.condition.get((Scope)scope.get())) continue;
                if (rpo.fallback == null) {
                    return IGNORE;
                }
                return DirRpoResult.replacement(rpo.path + "/", rpo.fallback, version);
            }
            catch (Condition.ConditionException e) {
                String res = "Could not evaluate condition for " + file + " (pack: " + key.packName() + ")";
                try {
                    Respackopts.LOGGER.error(res + " with condition:\n" + ObjectGraphPrinter.printGraph((Object)rpo.condition) + ")", (Throwable)e);
                }
                catch (Throwable ex) {
                    Respackopts.LOGGER.error(res, (Throwable)e);
                }
            }
        }
        return ORIGINAL;
    }

    public record Replacement(Prefix original, Prefix fallback, int version) implements DirRpoResult
    {
        public Replacement(String originalPrefix, String fallbackPrefix, int version) {
            this(new Prefix(originalPrefix), new Prefix(fallbackPrefix), version);
        }

        public String toFallback(String original) {
            Matcher m = this.original.pattern.matcher(original);
            if (this.version < 11) {
                return m.replaceAll(this.fallback.quoted);
            }
            if (!m.find()) {
                Respackopts.LOGGER.error("Attempted conversion to fallback path, but could not find original prefix for: {0}", new Object[]{original});
                return original;
            }
            return m.replaceFirst(this.fallback.quoted);
        }

        public String toOriginal(String fallback) {
            Matcher m = this.fallback.pattern.matcher(fallback);
            if (this.version < 11) {
                return m.replaceAll(this.original.quoted);
            }
            if (!m.find()) {
                Respackopts.LOGGER.error("Attempted conversion to original path, but could not find fallback prefix for: {0}", new Object[]{fallback});
                return fallback;
            }
            return m.replaceFirst(this.original.quoted);
        }

        public record Prefix(String prefix, String quoted, Pattern pattern) {
            public Prefix {
                if (!prefix.endsWith("/")) {
                    throw new IllegalArgumentException("Prefix must end with a slash");
                }
            }

            public Prefix(String prefix) {
                this(prefix, Matcher.quoteReplacement(prefix), Pattern.compile(Pattern.quote(prefix)));
            }
        }
    }

    public static enum FixedState implements DirRpoResult
    {
        IGNORE,
        ORIGINAL;

    }
}

