/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.jfronny.respackopts.model.naming;

import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class NameGuesser {
    private static final Pattern boundary = Pattern.compile("[\\s_-]|(?<=\\p{javaLowerCase})(?=\\p{javaUpperCase})|(?<=\\p{javaUpperCase})(?=\\p{javaUpperCase}\\p{javaLowerCase})|(?<=\\D)(?=\\d)|(?<=\\d)(?=\\D)");

    public static String guess(String id) {
        if (id == null || id.isEmpty()) {
            return id;
        }
        return boundary.splitAsStream(id).filter(Predicate.not(String::isBlank)).map(word -> {
            if (word.equals(word.toUpperCase())) {
                return word;
            }
            return word.substring(0, 1).toUpperCase() + word.substring(1).toLowerCase();
        }).collect(Collectors.joining(" "));
    }
}

