/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.jfronny.respackopts.platform.fabric;

import io.gitlab.jfronny.respackopts.integration.SaveHook;
import io.gitlab.jfronny.respackopts.platform.Platform;
import io.gitlab.jfronny.respackopts.platform.VersionParseException;
import java.nio.file.Path;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import net.fabricmc.api.EnvType;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.Version;
import net.fabricmc.loader.api.VersionParsingException;
import net.fabricmc.loader.api.metadata.version.VersionPredicate;

public enum PlatformImpl implements Platform<Version>
{
    INSTANCE;


    public static Platform<Version> getInstance() {
        return INSTANCE;
    }

    @Override
    public Path getGameDir() {
        return FabricLoader.getInstance().getGameDir();
    }

    @Override
    public Path getConfigDir() {
        return FabricLoader.getInstance().getConfigDir();
    }

    @Override
    public boolean isDedicatedServer() {
        return FabricLoader.getInstance().getEnvironmentType() == EnvType.SERVER;
    }

    @Override
    public boolean isClient() {
        return FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT;
    }

    @Override
    public List<SaveHook> getSaveHooks() {
        return FabricLoader.getInstance().getEntrypoints("respackopts:save_hook", SaveHook.class);
    }

    @Override
    public List<SaveHook.Client> getClientSaveHooks() {
        return FabricLoader.getInstance().getEntrypoints("respackopts:client_save_hook", SaveHook.Client.class);
    }

    @Override
    public Optional<Version> getVersion(String modId) {
        return FabricLoader.getInstance().getModContainer(modId).map(s -> s.getMetadata().getVersion());
    }

    @Override
    public Predicate<Version> parseVersionPredicate(String predicate) throws VersionParseException {
        try {
            return VersionPredicate.parse((String)predicate);
        }
        catch (VersionParsingException e) {
            throw new VersionParseException(e);
        }
    }
}

