/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.jfronny.respackopts.util;

import io.gitlab.jfronny.commons.throwable.ThrowingBiConsumer;
import io.gitlab.jfronny.libjf.LibJf;
import io.gitlab.jfronny.muscript.data.additional.context.Scope;
import io.gitlab.jfronny.muscript.data.dynamic.Dynamic;
import io.gitlab.jfronny.respackopts.Respackopts;
import io.gitlab.jfronny.respackopts.RespackoptsConfig;
import io.gitlab.jfronny.respackopts.filters.util.FileDependencyTracker;
import io.gitlab.jfronny.respackopts.integration.SaveHook;
import io.gitlab.jfronny.respackopts.model.DiscoveredPack;
import io.gitlab.jfronny.respackopts.model.PackMeta;
import io.gitlab.jfronny.respackopts.model.cache.CacheKey;
import io.gitlab.jfronny.respackopts.model.cache.CachedPackState;
import io.gitlab.jfronny.respackopts.model.enums.ConfigSyncMode;
import io.gitlab.jfronny.respackopts.model.enums.PackCapability;
import io.gitlab.jfronny.respackopts.model.tree.ConfigBranch;
import io.gitlab.jfronny.respackopts.model.tree.GC_ConfigBranch;
import io.gitlab.jfronny.respackopts.muscript.MuScriptScope;
import io.gitlab.jfronny.respackopts.muscript.RespackoptsFS;
import io.gitlab.jfronny.respackopts.platform.Platform;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_3262;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MetaCache {
    private static final Map<CacheKey, CachedPackState> PACK_STATES = new HashMap<CacheKey, CachedPackState>();
    private static final Map<String, CacheKey> KEYS_BY_DISPLAY_NAME = new HashMap<String, CacheKey>();
    private static final Map<String, CacheKey> KEYS_BY_PACK_NAME = new HashMap<String, CacheKey>();
    private static final Map<Path, CacheKey> KEYS_BY_DATA_LOCATION = new HashMap<Path, CacheKey>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void remove(CacheKey key) {
        Map<CacheKey, CachedPackState> map = PACK_STATES;
        synchronized (map) {
            CacheKey k = KEYS_BY_DATA_LOCATION.remove(key.dataLocation());
            if (k != null) {
                MetaCache.remove(k);
            }
            if ((k = KEYS_BY_PACK_NAME.remove(key.packName())) != null) {
                MetaCache.remove(k);
            }
            if ((k = KEYS_BY_DISPLAY_NAME.remove(key.displayName())) != null) {
                MetaCache.remove(k);
            }
            PACK_STATES.remove(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clear() {
        Map<CacheKey, CachedPackState> map = PACK_STATES;
        synchronized (map) {
            PACK_STATES.clear();
            KEYS_BY_DISPLAY_NAME.clear();
            KEYS_BY_PACK_NAME.clear();
            KEYS_BY_DATA_LOCATION.clear();
        }
    }

    public static int size() {
        return PACK_STATES.size();
    }

    public static Set<CacheKey> addFromScan(List<DiscoveredPack> discoveredPacks, Set<CacheKey> previousKeys) {
        HashSet<CacheKey> newKeys = new HashSet<CacheKey>();
        HashSet<String> ids = new HashSet<String>();
        for (DiscoveredPack pack : discoveredPacks) {
            newKeys.add(MetaCache.addFromScan(pack.displayName(), pack.packName(), pack.meta(), pack.dataLocation()));
            if (ids.add(pack.meta().id) || !RespackoptsConfig.debugLogs) continue;
            Respackopts.LOGGER.warn("Duplicate pack id: {0}", new Object[]{pack.meta().id});
        }
        previousKeys.stream().filter(s -> !newKeys.contains(s)).forEach(MetaCache::remove);
        MetaCache.save(SaveHook.Arguments.DO_NOTHING);
        return newKeys;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CacheKey addFromScan(String displayName, String packName, PackMeta meta, Path dataLocation) {
        Path legacyLocation;
        ConfigBranch branch;
        if (Respackopts.META_VERSION > meta.version && RespackoptsConfig.debugLogs) {
            Respackopts.LOGGER.warn("{0} uses an outdated RPO format ({1}). Although this is supported, using the latest version ({2}) is recommended", new Object[]{displayName, meta.version, Respackopts.META_VERSION});
        }
        meta.conf.setVersion(meta.version);
        if (meta.version < 5) {
            meta.capabilities.add(PackCapability.DirFilter);
        }
        if (meta.version < 14) {
            meta.capabilities.add(PackCapability.Shaders);
        }
        if (KEYS_BY_DATA_LOCATION.containsKey(dataLocation)) {
            branch = MetaCache.getState(KEYS_BY_DATA_LOCATION.get(dataLocation)).configBranch();
            branch.sync(meta.conf, ConfigSyncMode.RESPACK_LOAD);
        } else {
            branch = meta.conf.clone();
        }
        CacheKey key = new CacheKey(displayName, packName, dataLocation);
        CachedPackState state = new CachedPackState(key, meta, branch);
        MetaCache.remove(key);
        Map<CacheKey, CachedPackState> map = PACK_STATES;
        synchronized (map) {
            PACK_STATES.put(key, state);
            KEYS_BY_DISPLAY_NAME.put(key.displayName(), key);
            KEYS_BY_PACK_NAME.put(key.packName(), key);
            KEYS_BY_DATA_LOCATION.put(key.dataLocation(), key);
        }
        if (!dataLocation.startsWith(Respackopts.FALLBACK_CONF_DIR) && Files.exists(legacyLocation = Respackopts.FALLBACK_CONF_DIR.resolve(meta.id + ".json"), new LinkOption[0]) && !Files.exists(dataLocation, new LinkOption[0])) {
            try {
                Files.move(legacyLocation, dataLocation, new CopyOption[0]);
            }
            catch (IOException e) {
                Respackopts.LOGGER.error("Could not move data to new location", (Throwable)e);
            }
        }
        MetaCache.load(key);
        MetaCache.save(dataLocation, branch);
        return key;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CompletableFuture<Void> save(SaveHook.Arguments args) {
        if (RespackoptsConfig.debugLogs) {
            Respackopts.LOGGER.info("Saving configs", new Object[0]);
        }
        Map<CacheKey, CachedPackState> map = PACK_STATES;
        synchronized (map) {
            for (Map.Entry<CacheKey, CachedPackState> entry : PACK_STATES.entrySet()) {
                MetaCache.save(entry.getKey().dataLocation(), entry.getValue().configBranch());
            }
        }
        ArrayList<CompletableFuture<Void>> futures = new ArrayList<CompletableFuture<Void>>();
        for (SaveHook saveHook : Platform.getInstance().getSaveHooks()) {
            futures.add(saveHook.onSave(args));
        }
        if (Platform.getInstance().isClient()) {
            for (SaveHook saveHook : Platform.getInstance().getClientSaveHooks()) {
                futures.add(saveHook.onSave(args));
            }
        }
        return CompletableFuture.allOf((CompletableFuture[])futures.toArray(CompletableFuture[]::new));
    }

    private static void save(Path dataLocation, ConfigBranch branch) {
        try (BufferedWriter writer = Files.newBufferedWriter(dataLocation, new OpenOption[0]);){
            GC_ConfigBranch.serialize(branch, writer, LibJf.LENIENT_TRANSPORT);
        }
        catch (IOException ex) {
            Respackopts.LOGGER.error("Could not save config", (Throwable)ex);
        }
    }

    public static void load(CacheKey key) {
        if (Files.exists(key.dataLocation(), new LinkOption[0])) {
            if (RespackoptsConfig.debugLogs) {
                Respackopts.LOGGER.info("Loading configs for: {0}", new Object[]{key.displayName()});
            }
            try (BufferedReader reader = Files.newBufferedReader(key.dataLocation());){
                ConfigBranch b = GC_ConfigBranch.deserialize(reader, LibJf.LENIENT_TRANSPORT);
                if (PACK_STATES.containsKey(key)) {
                    MetaCache.getBranch(key).sync(b, ConfigSyncMode.CONF_LOAD);
                }
            }
            catch (IOException e) {
                Respackopts.LOGGER.error("Failed to load " + key.displayName(), (Throwable)e);
            }
        }
    }

    public static PackMeta getMeta(CacheKey key) {
        return MetaCache.getState(key).metadata();
    }

    @Nullable
    public static CacheKey getKeyByPack(class_3262 pack) {
        return MetaCache.getKeyByPackId(pack.method_14409());
    }

    @Nullable
    public static CacheKey getKeyByPackId(String packId) {
        return KEYS_BY_PACK_NAME.get(packId);
    }

    @Nullable
    public static CacheKey getKeyByDisplayName(String displayName) {
        return KEYS_BY_DISPLAY_NAME.get(displayName);
    }

    @Nullable
    public static CacheKey getKeyByDataLocation(Path dataLocation) {
        return KEYS_BY_DATA_LOCATION.get(dataLocation);
    }

    public static ConfigBranch getBranch(@NotNull CacheKey key) {
        return MetaCache.getState(key).configBranch();
    }

    public static String getId(CacheKey key) {
        return MetaCache.getState(key).packId();
    }

    public static CachedPackState getState(@NotNull CacheKey key) {
        return PACK_STATES.get(Objects.requireNonNull(key));
    }

    public static Scope getScope(int version) {
        Scope scope = MuScriptScope.fork(version);
        return MetaCache.populate(scope, null);
    }

    public static Scope getScope(@NotNull CacheKey key, RespackoptsFS fs) {
        CachedPackState state = MetaCache.getState(key);
        Scope scope = state.executionScope().fork();
        return MetaCache.populate(MuScriptScope.configureFS(scope, state, fs), state);
    }

    private static Scope populate(Scope scope, @Nullable CachedPackState pack) {
        MetaCache.forEach((id, state) -> {
            if (scope.has(state.packId())) {
                return;
            }
            if (pack != null && pack.packId().equals(state.packId()) && !pack.equals(state)) {
                return;
            }
            scope.set(state.packId(), (Dynamic)state.configBranch());
        });
        return scope;
    }

    public static void addDependency(CacheKey key, String to, String on) {
        FileDependencyTracker tracker = MetaCache.getState(key).tracker();
        if (tracker != null) {
            tracker.addDependency(to, on);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean hasCapability(class_3262 pack, PackCapability capability) {
        CacheKey key = MetaCache.getKeyByPack(pack);
        if (key == null) {
            return false;
        }
        if (!PACK_STATES.containsKey(key)) {
            StringBuilder sb = new StringBuilder("Could not get pack with \"");
            sb.append(key);
            sb.append("\" (available: ");
            Map<CacheKey, CachedPackState> map = PACK_STATES;
            synchronized (map) {
                for (CacheKey path : PACK_STATES.keySet()) {
                    sb.append(path).append(", ");
                }
            }
            throw new NullPointerException(sb.substring(0, sb.length() - 2) + ")");
        }
        return MetaCache.getMeta((CacheKey)key).capabilities.contains((Object)capability);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <TEx extends Exception> void forEach(ThrowingBiConsumer<CacheKey, CachedPackState, TEx> idAndBranchConsumer) throws TEx {
        Map<CacheKey, CachedPackState> map = PACK_STATES;
        synchronized (map) {
            for (Map.Entry entry : PACK_STATES.entrySet().stream().toList()) {
                idAndBranchConsumer.accept((Object)((CacheKey)entry.getKey()), (Object)((CachedPackState)entry.getValue()));
            }
        }
    }
}

