/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.jfronny.respackopts.util;

import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class OverlayMap<K, V>
extends AbstractMap<K, V> {
    private final Map<K, V> overlay;
    private final Map<K, V> lower;
    private final Set<K> masked = new HashSet<K>();
    private final Set<Map.Entry<K, V>> entrySet = new AbstractSet<Map.Entry<K, V>>(){

        @Override
        public int size() {
            return OverlayMap.this.size();
        }

        @Override
        public boolean isEmpty() {
            return OverlayMap.this.isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            Map.Entry e;
            return o instanceof Map.Entry && Objects.equals(OverlayMap.this.get((e = (Map.Entry)o).getKey()), e.getValue());
        }

        @Override
        public boolean add(Map.Entry<K, V> kvEntry) {
            return OverlayMap.this.put(kvEntry.getKey(), kvEntry.getValue()) == null;
        }

        @Override
        public boolean remove(Object o) {
            Map.Entry e;
            return o instanceof Map.Entry && OverlayMap.this.remove((e = (Map.Entry)o).getKey(), e.getValue());
        }

        @Override
        public void clear() {
            OverlayMap.this.clear();
        }

        @Override
        @NotNull
        public Iterator<Map.Entry<K, V>> iterator() {
            return new Iterator<Map.Entry<K, V>>(){
                private final Iterator<K> keys;
                private K previous;
                {
                    this.keys = OverlayMap.this.streamKeys().iterator();
                    this.previous = null;
                }

                @Override
                public boolean hasNext() {
                    return this.keys.hasNext();
                }

                @Override
                public Map.Entry<K, V> next() {
                    this.previous = this.keys.next();
                    return new Map.Entry<K, V>(){
                        private final K currentK;
                        private V currentV;
                        {
                            this.currentK = previous;
                            this.currentV = OverlayMap.this.get(this.currentK);
                        }

                        @Override
                        public K getKey() {
                            return this.currentK;
                        }

                        @Override
                        public V getValue() {
                            return this.currentV;
                        }

                        @Override
                        public V setValue(V value) {
                            Object result = OverlayMap.this.put(this.currentK, value);
                            this.currentV = value;
                            return result;
                        }
                    };
                }

                @Override
                public void remove() {
                    if (this.previous == null) {
                        throw new IllegalStateException();
                    }
                    OverlayMap.this.remove(this.previous);
                    this.previous = null;
                }
            };
        }
    };

    public OverlayMap(Map<K, V> overlay, Map<K, V> lower) {
        this.overlay = overlay;
        this.lower = lower;
    }

    @Override
    public int size() {
        return this.overlay.size() + (int)this.lower.keySet().stream().filter(s -> !this.overlay.containsKey(s) && !this.masked.contains(s)).count();
    }

    private Stream<K> streamKeys() {
        return Stream.concat(this.overlay.keySet().stream(), this.lower.keySet().stream().filter(s -> !this.overlay.containsKey(s) && !this.masked.contains(s)));
    }

    @Override
    public boolean isEmpty() {
        return this.overlay.isEmpty() && this.masked.size() >= this.lower.size();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.overlay.containsKey(key) || this.lower.containsKey(key) && !this.masked.contains(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.overlay.containsValue(value) || this.lower.entrySet().stream().filter(s -> Objects.equals(s.getValue(), value)).anyMatch(s -> !this.masked.contains(s.getKey()));
    }

    @Override
    public V get(Object key) {
        V result = this.overlay.get(key);
        if (result == null && !this.masked.contains(key)) {
            result = this.lower.get(key);
        }
        return result;
    }

    @Override
    @Nullable
    public V put(K key, V value) {
        V result = this.overlay.put(key, value);
        V low = this.lower.get(key);
        if (low != null && this.masked.add(key) && result == null) {
            result = low;
        }
        return result;
    }

    @Override
    public V remove(Object key) {
        V result = this.overlay.remove(key);
        V low = this.lower.get(key);
        if (low != null && this.masked.add(key) && result == null) {
            result = low;
        }
        return result;
    }

    @Override
    public void clear() {
        this.overlay.clear();
        this.masked.addAll(this.lower.keySet());
    }

    @Override
    @NotNull
    public Set<Map.Entry<K, V>> entrySet() {
        return this.entrySet;
    }
}

