/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.jfronny.respackopts.filters;

import io.gitlab.jfronny.libjf.ResourcePath;
import io.gitlab.jfronny.respackopts.filters.IEvents;
import io.gitlab.jfronny.respackopts.filters.util.FileExclusionProvider;
import io.gitlab.jfronny.respackopts.filters.util.FileExpansionProvider;
import io.gitlab.jfronny.respackopts.filters.util.FileFallbackProvider;
import io.gitlab.jfronny.respackopts.model.cache.CacheKey;
import io.gitlab.jfronny.respackopts.model.enums.PackCapability;
import io.gitlab.jfronny.respackopts.muscript.RespackoptsFS;
import io.gitlab.jfronny.respackopts.util.MetaCache;
import java.io.InputStream;
import java.util.HashSet;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.resources.IoSupplier;

public class FileFilterEvents
implements IEvents {
    @Override
    public IoSupplier<InputStream> open(IoSupplier<InputStream> previous, PackResources pack, String name) {
        RespackoptsFS fs;
        CacheKey key = MetaCache.getKeyByPack(pack);
        if (FileExclusionProvider.fileHidden(key, fs = new RespackoptsFS(pack), name)) {
            return FileFallbackProvider.getReplacement(key, fs, name);
        }
        return FileExpansionProvider.replace(previous, key, fs, name);
    }

    @Override
    public PackResources.ResourceOutput findResources(PackType type, String namespace, String prefix, PackResources.ResourceOutput previous, PackResources pack) {
        if (this.skip(pack)) {
            return previous;
        }
        HashSet alreadyConsumed = new HashSet();
        CacheKey key = MetaCache.getKeyByPack(pack);
        RespackoptsFS fs = new RespackoptsFS(pack);
        return (identifier, value) -> {
            String fileName = new ResourcePath(type, identifier).getName();
            if (!FileExclusionProvider.fileHidden(key, fs, fileName)) {
                alreadyConsumed.add(identifier);
                previous.accept(identifier, this.open(type, (ResourceLocation)identifier, (IoSupplier<InputStream>)value, pack));
            } else {
                IoSupplier<InputStream> replacement = FileFallbackProvider.getReplacement(key, fs, fileName);
                if (replacement != null) {
                    alreadyConsumed.add(identifier);
                    previous.accept(identifier, replacement);
                }
            }
            FileFallbackProvider.addFallbackResources(type, namespace, prefix, previous, key, fs, identifier, alreadyConsumed);
        };
    }

    @Override
    public boolean skip(PackResources pack) {
        return !MetaCache.hasCapability(pack, PackCapability.FileFilter);
    }
}

