/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.jfronny.respackopts.filters;

import io.gitlab.jfronny.commons.logger.SystemLoggerPlus;
import io.gitlab.jfronny.libjf.data.manipulation.api.ResourcePackInterceptor;
import io.gitlab.jfronny.respackopts.RespackoptsConfig;
import java.io.InputStream;
import java.util.HashSet;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.metadata.MetadataSectionType;
import net.minecraft.server.packs.resources.IoSupplier;

public class IOLogEvents
implements ResourcePackInterceptor {
    private static final SystemLoggerPlus LOG = SystemLoggerPlus.forName((String)"respackopts/io");

    public PackResources.ResourceOutput findResources(PackType type, String namespace, String prefix, PackResources.ResourceOutput previous, PackResources pack) {
        if (!RespackoptsConfig.ioLogs) {
            return previous;
        }
        LOG.info("FIND_RESOURCE " + String.valueOf(type) + " in " + namespace + " " + prefix + " of " + pack.packId(), new Object[0]);
        HashSet results = new HashSet();
        return (identifier, inputStreamInputSupplier) -> {
            if (!results.add(identifier)) {
                LOG.warn("Duplicate identifier returned by findResources: " + String.valueOf(identifier), new Object[0]);
            }
            previous.accept(identifier, inputStreamInputSupplier);
        };
    }

    public IoSupplier<InputStream> open(PackType type, ResourceLocation id, IoSupplier<InputStream> previous, PackResources pack) {
        if (RespackoptsConfig.ioLogs) {
            LOG.info("OPEN " + String.valueOf(type) + " at " + String.valueOf(id) + " of " + pack.packId(), new Object[0]);
        }
        return previous;
    }

    public IoSupplier<InputStream> openRoot(String[] fileName, IoSupplier<InputStream> previous, PackResources pack) {
        if (RespackoptsConfig.ioLogs) {
            LOG.info("OPEN_ROOT " + String.join((CharSequence)"/", fileName) + " of " + pack.packId(), new Object[0]);
        }
        return previous;
    }

    public <T> T parseMetadata(MetadataSectionType<T> reader, Supplier<T> previous, PackResources pack) {
        if (RespackoptsConfig.ioLogs) {
            LOG.info("PARSE_METADATA " + reader.name() + " of " + pack.packId(), new Object[0]);
        }
        return previous.get();
    }
}

