/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.jfronny.respackopts.integration;

import io.gitlab.jfronny.respackopts.Respackopts;
import io.gitlab.jfronny.respackopts.RespackoptsClient;
import io.gitlab.jfronny.respackopts.RespackoptsConfig;
import io.gitlab.jfronny.respackopts.integration.SaveHook;
import io.gitlab.jfronny.respackopts.model.enums.PackCapability;
import io.gitlab.jfronny.respackopts.platform.PlatformClient;
import io.gitlab.jfronny.respackopts.util.IndentingStringBuilder;
import io.gitlab.jfronny.respackopts.util.MetaCache;
import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;

public class ShaderIntegration
implements SaveHook.Client {
    private static String shaderImportSource;

    public static String getShaderImportSource() {
        if (shaderImportSource == null) {
            Respackopts.LOGGER.error("Shader import source is null", new Object[0]);
            return "";
        }
        return shaderImportSource;
    }

    @Override
    public CompletableFuture<Void> onSave(SaveHook.Arguments args) {
        if (RespackoptsConfig.debugLogs) {
            Respackopts.LOGGER.info("Generating shader code", new Object[0]);
        }
        IndentingStringBuilder sb = new IndentingStringBuilder();
        sb.append("#ifndef respackopts_loaded");
        sb.append("\n#define respackopts_loaded");
        MetaCache.forEach((key, state) -> {
            if (!state.metadata().capabilities.contains((Object)PackCapability.Shaders)) {
                return;
            }
            state.configBranch().buildShader(sb, state.packId());
        });
        sb.append("\n#endif");
        shaderImportSource = sb.toString();
        PlatformClient.getInstance().handleShadersUpdate();
        if (args.flagResourcesForReload()) {
            RespackoptsClient.forcePackReload = true;
        }
        ArrayList<CompletableFuture<Void>> futures = new ArrayList<CompletableFuture<Void>>();
        if (args.reloadResourcesImmediately()) {
            futures.add(RespackoptsClient.forceReloadResources());
        }
        if (args.reloadData()) {
            futures.add(RespackoptsClient.reloadIntegratedServerData());
        }
        return CompletableFuture.allOf((CompletableFuture[])futures.toArray(CompletableFuture[]::new));
    }
}

