/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.jfronny.respackopts.platform.neoforge;

import io.gitlab.jfronny.respackopts.integration.SaveHook;
import io.gitlab.jfronny.respackopts.platform.Platform;
import io.gitlab.jfronny.respackopts.platform.VersionParseException;
import io.gitlab.jfronny.respackopts.platform.neoforge.VersionPredicateParser;
import java.nio.file.Path;
import java.util.List;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.function.Predicate;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.fml.ModList;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.fml.loading.FMLPaths;
import org.apache.maven.artifact.versioning.ArtifactVersion;

public enum PlatformImpl implements Platform<ArtifactVersion>
{
    INSTANCE;


    public static Platform<ArtifactVersion> getInstance() {
        return INSTANCE;
    }

    @Override
    public Path getGameDir() {
        return FMLPaths.GAMEDIR.get();
    }

    @Override
    public Path getConfigDir() {
        return FMLPaths.CONFIGDIR.get();
    }

    @Override
    public boolean isDedicatedServer() {
        return FMLEnvironment.getDist() == Dist.DEDICATED_SERVER;
    }

    @Override
    public boolean isClient() {
        return FMLEnvironment.getDist() == Dist.CLIENT;
    }

    @Override
    public List<SaveHook> getSaveHooks() {
        return ServiceLoader.load(SaveHook.class).stream().map(ServiceLoader.Provider::get).toList();
    }

    @Override
    public List<SaveHook.Client> getClientSaveHooks() {
        if (!this.isClient()) {
            return List.of();
        }
        return ServiceLoader.load(SaveHook.Client.class).stream().map(ServiceLoader.Provider::get).toList();
    }

    @Override
    public Optional<ArtifactVersion> getVersion(String modId) {
        return ModList.get().getModContainerById(modId).map(s -> s.getModInfo().getVersion());
    }

    @Override
    public Predicate<ArtifactVersion> parseVersionPredicate(String predicate) throws VersionParseException {
        return VersionPredicateParser.parse(predicate);
    }
}

