/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.jfronny.respackopts.platform.neoforge;

import io.gitlab.jfronny.respackopts.platform.VersionParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.jetbrains.annotations.NotNull;

public class VersionPredicateParser {
    private static final Pattern VERSION_SPLITS = Pattern.compile("((?<=[.+-])|(?=[.+-]))");
    private static final Pattern WILDCARD_PATTERN = Pattern.compile("[xX*]");

    private static ArtifactVersion parseVersionWithWildcards(String version) {
        String[] split = VERSION_SPLITS.split(version);
        StringBuilder ret = new StringBuilder();
        int wildcard = -1;
        for (int i = 0; i < split.length; ++i) {
            if (i <= 6 && i % 2 == 0 && WILDCARD_PATTERN.matcher(split[i]).matches()) {
                ret.append("0");
                if (wildcard != -1) continue;
                wildcard = i / 2;
                continue;
            }
            ret.append(split[i]);
        }
        DefaultArtifactVersion result = new DefaultArtifactVersion(ret.toString());
        return wildcard != -1 ? new ArtifactVersionWithWildcards((ArtifactVersion)result, wildcard) : result;
    }

    public static Predicate<ArtifactVersion> parse(String predicate) throws VersionParseException {
        ArrayList<SingleVersionPredicate> predicateList = new ArrayList<SingleVersionPredicate>();
        for (String s : predicate.split(" ")) {
            ArtifactVersion version;
            if ((s = s.trim()).isEmpty() || s.equals("*")) continue;
            VersionComparisonOperator operator = VersionComparisonOperator.EQUAL;
            for (VersionComparisonOperator op : VersionComparisonOperator.values()) {
                if (op.getSerialized() == null || !s.startsWith(op.getSerialized())) continue;
                operator = op;
                s = s.substring(op.getSerialized().length());
                break;
            }
            if ((version = VersionPredicateParser.parseVersionWithWildcards(s)) instanceof ArtifactVersionWithWildcards) {
                ArtifactVersionWithWildcards w = (ArtifactVersionWithWildcards)version;
                if (operator != VersionComparisonOperator.EQUAL) {
                    throw new VersionParseException("Invalid predicate: " + predicate + ", version ranges with wildcards (.X) require using the equality operator or no operator at all!");
                }
                assert (w.wildcard == 1 || w.wildcard == 2 || w.wildcard == 3);
                operator = switch (w.wildcard) {
                    case 1 -> VersionComparisonOperator.SAME_TO_NEXT_MAJOR;
                    case 2 -> VersionComparisonOperator.SAME_TO_NEXT_MINOR;
                    default -> VersionComparisonOperator.SAME_TO_INCREMENTAL;
                };
            }
            predicateList.add(new SingleVersionPredicate(operator, version));
        }
        if (predicateList.isEmpty()) {
            return v -> true;
        }
        if (predicateList.size() == 1) {
            return (Predicate)predicateList.getFirst();
        }
        return new MultiVersionPredicate(predicateList);
    }

    private record ArtifactVersionWithWildcards(ArtifactVersion delegate, int wildcard) implements ArtifactVersion
    {
        public int getMajorVersion() {
            return this.wildcard == 0 ? 0 : this.delegate.getMajorVersion();
        }

        public int getMinorVersion() {
            return this.wildcard <= 1 ? 0 : this.delegate.getMinorVersion();
        }

        public int getIncrementalVersion() {
            return this.wildcard <= 2 ? 0 : this.delegate.getIncrementalVersion();
        }

        public int getBuildNumber() {
            return this.wildcard <= 3 ? 0 : this.delegate.getBuildNumber();
        }

        public String getQualifier() {
            return this.delegate.getQualifier();
        }

        public void parseVersion(String version) {
            this.delegate.parseVersion(version);
        }

        public int compareTo(@NotNull ArtifactVersion artifactVersion) {
            return this.delegate.compareTo((Object)artifactVersion);
        }

        @Override
        public String toString() {
            return this.delegate.getMajorVersion() + "." + this.delegate.getMinorVersion() + "." + this.delegate.getIncrementalVersion() + "-" + this.delegate.getBuildNumber();
        }
    }

    private static enum VersionComparisonOperator {
        GREATER_EQUAL(">="){

            @Override
            public boolean test(ArtifactVersion a, ArtifactVersion b) {
                return a.compareTo((Object)b) >= 0;
            }
        }
        ,
        LESS_EQUAL("<="){

            @Override
            public boolean test(ArtifactVersion a, ArtifactVersion b) {
                return a.compareTo((Object)b) <= 0;
            }
        }
        ,
        GREATER(">"){

            @Override
            public boolean test(ArtifactVersion a, ArtifactVersion b) {
                return a.compareTo((Object)b) > 0;
            }
        }
        ,
        LESS("<"){

            @Override
            public boolean test(ArtifactVersion a, ArtifactVersion b) {
                return a.compareTo((Object)b) < 0;
            }
        }
        ,
        EQUAL("="){

            @Override
            public boolean test(ArtifactVersion a, ArtifactVersion b) {
                return a.compareTo((Object)b) == 0;
            }
        }
        ,
        SAME_TO_INCREMENTAL(null){

            @Override
            public boolean test(ArtifactVersion a, ArtifactVersion b) {
                return a.compareTo((Object)b) >= 0 && a.getMajorVersion() == b.getMajorVersion() && a.getMinorVersion() == b.getMinorVersion() && a.getIncrementalVersion() == b.getIncrementalVersion();
            }
        }
        ,
        SAME_TO_NEXT_MINOR("~"){

            @Override
            public boolean test(ArtifactVersion a, ArtifactVersion b) {
                return a.compareTo((Object)b) >= 0 && a.getMajorVersion() == b.getMajorVersion() && a.getMinorVersion() == b.getMinorVersion();
            }
        }
        ,
        SAME_TO_NEXT_MAJOR("^"){

            @Override
            public boolean test(ArtifactVersion a, ArtifactVersion b) {
                return a.compareTo((Object)b) >= 0 && a.getMajorVersion() == b.getMajorVersion();
            }
        };

        private final String serialized;

        private VersionComparisonOperator(String serialized) {
            this.serialized = serialized;
        }

        public final String getSerialized() {
            return this.serialized;
        }

        public abstract boolean test(ArtifactVersion var1, ArtifactVersion var2);
    }

    private record SingleVersionPredicate(VersionComparisonOperator operator, ArtifactVersion refVersion) implements Predicate<ArtifactVersion>
    {
        @Override
        public boolean test(ArtifactVersion version) {
            return this.operator.test(Objects.requireNonNull(version, "null version"), this.refVersion);
        }
    }

    private record MultiVersionPredicate(List<SingleVersionPredicate> predicates) implements Predicate<ArtifactVersion>
    {
        @Override
        public boolean test(ArtifactVersion version) {
            Objects.requireNonNull(version, "null version");
            for (SingleVersionPredicate predicate : this.predicates) {
                if (predicate.test(version)) continue;
                return false;
            }
            return true;
        }
    }
}

